/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.api;

import com.tersesystems.echopraxia.api.Attributes;
import com.tersesystems.echopraxia.api.FieldBuilderResult;
import com.tersesystems.echopraxia.api.Value;
import com.tersesystems.echopraxia.spi.DefaultField;
import com.tersesystems.echopraxia.spi.EchopraxiaService;
import com.tersesystems.echopraxia.spi.PresentationHintAttributes;
import java.util.concurrent.atomic.LongAdder;
import org.jetbrains.annotations.NotNull;

public interface Field
extends FieldBuilderResult {
    public static final String ECHOPRAXIA_UNKNOWN = "echopraxia-unknown-";
    public static final LongAdder unknownFieldAdder = new LongAdder();

    @NotNull
    public String name();

    @NotNull
    public Value<?> value();

    @NotNull
    public Attributes attributes();

    @NotNull
    public static Field value(@NotNull String name, @NotNull Value<?> value) {
        return Field.value(name, value, DefaultField.class);
    }

    @NotNull
    public static <F extends Field> F value(@NotNull String name, @NotNull Value<?> value, Class<F> fieldClass) {
        return EchopraxiaService.getInstance().getFieldCreator(fieldClass).create(name, value, PresentationHintAttributes.valueOnlyAttributes());
    }

    @NotNull
    public static Field keyValue(@NotNull String name, @NotNull Value<?> value) {
        return Field.keyValue(name, value, DefaultField.class);
    }

    public static <F extends Field> F keyValue(@NotNull String name, @NotNull Value<?> value, Class<F> fieldClass) {
        return EchopraxiaService.getInstance().getFieldCreator(fieldClass).create(name, value, Attributes.empty());
    }

    public static String requireName(String name) {
        if (name != null) {
            return name;
        }
        unknownFieldAdder.increment();
        return ECHOPRAXIA_UNKNOWN + unknownFieldAdder.longValue();
    }

    public static Value<?> requireValue(Value<?> value) {
        if (value != null) {
            return value;
        }
        return Value.nullValue();
    }
}

