/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.api;

import com.tersesystems.echopraxia.api.Attribute;
import com.tersesystems.echopraxia.api.AttributeKey;
import com.tersesystems.echopraxia.api.Attributes;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.pcollections.Empty;
import org.pcollections.PMap;

final class AttributesImpl
implements Attributes {
    static final Attributes EMPTY = new AttributesImpl(Empty.map());
    private final PMap<AttributeKey<?>, Object> _map;

    AttributesImpl(PMap<AttributeKey<?>, Object> map) {
        this._map = map;
    }

    @Override
    public <A> A get(@NotNull AttributeKey<A> key) {
        return (A)this._map.get(key);
    }

    @Override
    @NotNull
    public <A> Optional<A> getOptional(@NotNull AttributeKey<A> key) {
        return Optional.ofNullable(this._map.get(key));
    }

    @Override
    public boolean containsKey(@NotNull AttributeKey<?> key) {
        return this._map.containsKey(key);
    }

    @Override
    @NotNull
    public <A> Attributes plus(@NotNull AttributeKey<A> key, A value) {
        return new AttributesImpl(this._map.plus(key, value));
    }

    @Override
    @NotNull
    public <A> Attributes plus(@NotNull Attribute<A> attr) {
        return this.plus(attr.key(), attr.value());
    }

    @Override
    @NotNull
    public Attributes plusAll(@NotNull Attributes attrs) {
        return new AttributesImpl(this._map.plusAll(((AttributesImpl)attrs)._map));
    }

    @Override
    @NotNull
    public Attributes plusAll(@NotNull Attribute<?> a1, @NotNull Attribute<?> a2) {
        return this.plus(a1).plus(a2);
    }

    @Override
    @NotNull
    public Attributes plusAll(@NotNull Map<AttributeKey<?>, ?> attrs) {
        return new AttributesImpl(this._map.plusAll(attrs));
    }

    @Override
    @NotNull
    public Attributes plusAll(@NotNull Collection<Attribute<?>> attrs) {
        HashMap attrsMap = new HashMap();
        for (Attribute<?> attr : attrs) {
            attrsMap.put(attr.key(), attr.value());
        }
        return this.plusAll(attrsMap);
    }

    @Override
    @NotNull
    public Attributes minus(@NotNull AttributeKey<?> key) {
        return new AttributesImpl(this._map.minus(key));
    }

    @Override
    @NotNull
    public Attributes minusAll(@NotNull Collection<AttributeKey<?>> keys) {
        return new AttributesImpl(this._map.minusAll(keys));
    }

    public String toString() {
        return "Attributes(" + this._map + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributesImpl that = (AttributesImpl)o;
        return Objects.equals(this._map, that._map);
    }

    public int hashCode() {
        return Objects.hash(this._map);
    }
}

