/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common;

public class DatatypeConverter {
    private static final char[] hexCode = "0123456789ABCDEF".toCharArray();
    private static final char[] encodeMap = DatatypeConverter.initEncodeMap();

    public static String printHexBinary(byte[] data) {
        StringBuilder r = new StringBuilder(data.length * 2);
        for (byte b : data) {
            r.append(hexCode[b >> 4 & 0xF]);
            r.append(hexCode[b & 0xF]);
        }
        return r.toString();
    }

    public static String printBase64Binary(byte[] input) {
        char[] buf = new char[(input.length + 2) / 3 * 4];
        int ptr = DatatypeConverter._printBase64Binary(input, 0, input.length, buf, 0);
        assert (ptr == buf.length);
        return new String(buf);
    }

    private static int _printBase64Binary(byte[] input, int offset, int len, char[] buf, int ptr) {
        int remaining = len;
        int i = offset;
        while (remaining >= 3) {
            buf[ptr++] = DatatypeConverter.encode(input[i] >> 2);
            buf[ptr++] = DatatypeConverter.encode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF);
            buf[ptr++] = DatatypeConverter.encode((input[i + 1] & 0xF) << 2 | input[i + 2] >> 6 & 3);
            buf[ptr++] = DatatypeConverter.encode(input[i + 2] & 0x3F);
            remaining -= 3;
            i += 3;
        }
        if (remaining == 1) {
            buf[ptr++] = DatatypeConverter.encode(input[i] >> 2);
            buf[ptr++] = DatatypeConverter.encode((input[i] & 3) << 4);
            buf[ptr++] = 61;
            buf[ptr++] = 61;
        }
        if (remaining == 2) {
            buf[ptr++] = DatatypeConverter.encode(input[i] >> 2);
            buf[ptr++] = DatatypeConverter.encode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF);
            buf[ptr++] = DatatypeConverter.encode((input[i + 1] & 0xF) << 2);
            buf[ptr++] = 61;
        }
        return ptr;
    }

    private static char[] initEncodeMap() {
        int i;
        char[] map = new char[64];
        for (i = 0; i < 26; ++i) {
            map[i] = (char)(65 + i);
        }
        for (i = 26; i < 52; ++i) {
            map[i] = (char)(97 + (i - 26));
        }
        for (i = 52; i < 62; ++i) {
            map[i] = (char)(48 + (i - 52));
        }
        map[62] = 43;
        map[63] = 47;
        return map;
    }

    public static char encode(int i) {
        return encodeMap[i & 0x3F];
    }
}

