/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeMalwareTimingScanSettingResponse extends AbstractModel {

    /**
    * 检测模式 0 全盘检测  1快速检测
    */
    @SerializedName("CheckPattern")
    @Expose
    private Long CheckPattern;

    /**
    * 检测周期 开始时间
    */
    @SerializedName("StartTime")
    @Expose
    private String StartTime;

    /**
    * 检测周期 超时结束时间
    */
    @SerializedName("EndTime")
    @Expose
    private String EndTime;

    /**
    * 是否全部服务器 1 全部 2 自选
    */
    @SerializedName("IsGlobal")
    @Expose
    private Long IsGlobal;

    /**
    * 自选服务器时必须 主机quuid的string数组
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("QuuidList")
    @Expose
    private String [] QuuidList;

    /**
    * 监控模式 0 标准 1深度
    */
    @SerializedName("MonitoringPattern")
    @Expose
    private Long MonitoringPattern;

    /**
    * 周期 1每天
    */
    @SerializedName("Cycle")
    @Expose
    private Long Cycle;

    /**
    * 定时检测开关 0 关闭1 开启
    */
    @SerializedName("EnableScan")
    @Expose
    private Long EnableScan;

    /**
    * 唯一ID
    */
    @SerializedName("Id")
    @Expose
    private Long Id;

    /**
    * 实时监控0 关闭 1开启
    */
    @SerializedName("RealTimeMonitoring")
    @Expose
    private Long RealTimeMonitoring;

    /**
    * 是否自动隔离：1-是，0-否
    */
    @SerializedName("AutoIsolation")
    @Expose
    private Long AutoIsolation;

    /**
    * 一键扫描超时时长，如：1800秒（s）
    */
    @SerializedName("ClickTimeout")
    @Expose
    private Long ClickTimeout;

    /**
    * 是否杀掉进程 1杀掉 0不杀掉 只有开启自动隔离才生效
    */
    @SerializedName("KillProcess")
    @Expose
    private Long KillProcess;

    /**
    * 1标准模式（只报严重、高危）、2增强模式（报严重、高危、中危）、3严格模式（报严重、高、中、低、提示）
    */
    @SerializedName("EngineType")
    @Expose
    private Long EngineType;

    /**
    * 启发引擎 0 关闭 1开启
    */
    @SerializedName("EnableInspiredEngine")
    @Expose
    private Long EnableInspiredEngine;

    /**
    * 是否开启恶意进程查杀[0:未开启,1:开启]
    */
    @SerializedName("EnableMemShellScan")
    @Expose
    private Long EnableMemShellScan;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 检测模式 0 全盘检测  1快速检测 
     * @return CheckPattern 检测模式 0 全盘检测  1快速检测
     */
    public Long getCheckPattern() {
        return this.CheckPattern;
    }

    /**
     * Set 检测模式 0 全盘检测  1快速检测
     * @param CheckPattern 检测模式 0 全盘检测  1快速检测
     */
    public void setCheckPattern(Long CheckPattern) {
        this.CheckPattern = CheckPattern;
    }

    /**
     * Get 检测周期 开始时间 
     * @return StartTime 检测周期 开始时间
     */
    public String getStartTime() {
        return this.StartTime;
    }

    /**
     * Set 检测周期 开始时间
     * @param StartTime 检测周期 开始时间
     */
    public void setStartTime(String StartTime) {
        this.StartTime = StartTime;
    }

    /**
     * Get 检测周期 超时结束时间 
     * @return EndTime 检测周期 超时结束时间
     */
    public String getEndTime() {
        return this.EndTime;
    }

    /**
     * Set 检测周期 超时结束时间
     * @param EndTime 检测周期 超时结束时间
     */
    public void setEndTime(String EndTime) {
        this.EndTime = EndTime;
    }

    /**
     * Get 是否全部服务器 1 全部 2 自选 
     * @return IsGlobal 是否全部服务器 1 全部 2 自选
     */
    public Long getIsGlobal() {
        return this.IsGlobal;
    }

    /**
     * Set 是否全部服务器 1 全部 2 自选
     * @param IsGlobal 是否全部服务器 1 全部 2 自选
     */
    public void setIsGlobal(Long IsGlobal) {
        this.IsGlobal = IsGlobal;
    }

    /**
     * Get 自选服务器时必须 主机quuid的string数组
注意：此字段可能返回 null，表示取不到有效值。 
     * @return QuuidList 自选服务器时必须 主机quuid的string数组
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String [] getQuuidList() {
        return this.QuuidList;
    }

    /**
     * Set 自选服务器时必须 主机quuid的string数组
注意：此字段可能返回 null，表示取不到有效值。
     * @param QuuidList 自选服务器时必须 主机quuid的string数组
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setQuuidList(String [] QuuidList) {
        this.QuuidList = QuuidList;
    }

    /**
     * Get 监控模式 0 标准 1深度 
     * @return MonitoringPattern 监控模式 0 标准 1深度
     */
    public Long getMonitoringPattern() {
        return this.MonitoringPattern;
    }

    /**
     * Set 监控模式 0 标准 1深度
     * @param MonitoringPattern 监控模式 0 标准 1深度
     */
    public void setMonitoringPattern(Long MonitoringPattern) {
        this.MonitoringPattern = MonitoringPattern;
    }

    /**
     * Get 周期 1每天 
     * @return Cycle 周期 1每天
     */
    public Long getCycle() {
        return this.Cycle;
    }

    /**
     * Set 周期 1每天
     * @param Cycle 周期 1每天
     */
    public void setCycle(Long Cycle) {
        this.Cycle = Cycle;
    }

    /**
     * Get 定时检测开关 0 关闭1 开启 
     * @return EnableScan 定时检测开关 0 关闭1 开启
     */
    public Long getEnableScan() {
        return this.EnableScan;
    }

    /**
     * Set 定时检测开关 0 关闭1 开启
     * @param EnableScan 定时检测开关 0 关闭1 开启
     */
    public void setEnableScan(Long EnableScan) {
        this.EnableScan = EnableScan;
    }

    /**
     * Get 唯一ID 
     * @return Id 唯一ID
     */
    public Long getId() {
        return this.Id;
    }

    /**
     * Set 唯一ID
     * @param Id 唯一ID
     */
    public void setId(Long Id) {
        this.Id = Id;
    }

    /**
     * Get 实时监控0 关闭 1开启 
     * @return RealTimeMonitoring 实时监控0 关闭 1开启
     */
    public Long getRealTimeMonitoring() {
        return this.RealTimeMonitoring;
    }

    /**
     * Set 实时监控0 关闭 1开启
     * @param RealTimeMonitoring 实时监控0 关闭 1开启
     */
    public void setRealTimeMonitoring(Long RealTimeMonitoring) {
        this.RealTimeMonitoring = RealTimeMonitoring;
    }

    /**
     * Get 是否自动隔离：1-是，0-否 
     * @return AutoIsolation 是否自动隔离：1-是，0-否
     */
    public Long getAutoIsolation() {
        return this.AutoIsolation;
    }

    /**
     * Set 是否自动隔离：1-是，0-否
     * @param AutoIsolation 是否自动隔离：1-是，0-否
     */
    public void setAutoIsolation(Long AutoIsolation) {
        this.AutoIsolation = AutoIsolation;
    }

    /**
     * Get 一键扫描超时时长，如：1800秒（s） 
     * @return ClickTimeout 一键扫描超时时长，如：1800秒（s）
     */
    public Long getClickTimeout() {
        return this.ClickTimeout;
    }

    /**
     * Set 一键扫描超时时长，如：1800秒（s）
     * @param ClickTimeout 一键扫描超时时长，如：1800秒（s）
     */
    public void setClickTimeout(Long ClickTimeout) {
        this.ClickTimeout = ClickTimeout;
    }

    /**
     * Get 是否杀掉进程 1杀掉 0不杀掉 只有开启自动隔离才生效 
     * @return KillProcess 是否杀掉进程 1杀掉 0不杀掉 只有开启自动隔离才生效
     */
    public Long getKillProcess() {
        return this.KillProcess;
    }

    /**
     * Set 是否杀掉进程 1杀掉 0不杀掉 只有开启自动隔离才生效
     * @param KillProcess 是否杀掉进程 1杀掉 0不杀掉 只有开启自动隔离才生效
     */
    public void setKillProcess(Long KillProcess) {
        this.KillProcess = KillProcess;
    }

    /**
     * Get 1标准模式（只报严重、高危）、2增强模式（报严重、高危、中危）、3严格模式（报严重、高、中、低、提示） 
     * @return EngineType 1标准模式（只报严重、高危）、2增强模式（报严重、高危、中危）、3严格模式（报严重、高、中、低、提示）
     */
    public Long getEngineType() {
        return this.EngineType;
    }

    /**
     * Set 1标准模式（只报严重、高危）、2增强模式（报严重、高危、中危）、3严格模式（报严重、高、中、低、提示）
     * @param EngineType 1标准模式（只报严重、高危）、2增强模式（报严重、高危、中危）、3严格模式（报严重、高、中、低、提示）
     */
    public void setEngineType(Long EngineType) {
        this.EngineType = EngineType;
    }

    /**
     * Get 启发引擎 0 关闭 1开启 
     * @return EnableInspiredEngine 启发引擎 0 关闭 1开启
     */
    public Long getEnableInspiredEngine() {
        return this.EnableInspiredEngine;
    }

    /**
     * Set 启发引擎 0 关闭 1开启
     * @param EnableInspiredEngine 启发引擎 0 关闭 1开启
     */
    public void setEnableInspiredEngine(Long EnableInspiredEngine) {
        this.EnableInspiredEngine = EnableInspiredEngine;
    }

    /**
     * Get 是否开启恶意进程查杀[0:未开启,1:开启] 
     * @return EnableMemShellScan 是否开启恶意进程查杀[0:未开启,1:开启]
     */
    public Long getEnableMemShellScan() {
        return this.EnableMemShellScan;
    }

    /**
     * Set 是否开启恶意进程查杀[0:未开启,1:开启]
     * @param EnableMemShellScan 是否开启恶意进程查杀[0:未开启,1:开启]
     */
    public void setEnableMemShellScan(Long EnableMemShellScan) {
        this.EnableMemShellScan = EnableMemShellScan;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeMalwareTimingScanSettingResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeMalwareTimingScanSettingResponse(DescribeMalwareTimingScanSettingResponse source) {
        if (source.CheckPattern != null) {
            this.CheckPattern = new Long(source.CheckPattern);
        }
        if (source.StartTime != null) {
            this.StartTime = new String(source.StartTime);
        }
        if (source.EndTime != null) {
            this.EndTime = new String(source.EndTime);
        }
        if (source.IsGlobal != null) {
            this.IsGlobal = new Long(source.IsGlobal);
        }
        if (source.QuuidList != null) {
            this.QuuidList = new String[source.QuuidList.length];
            for (int i = 0; i < source.QuuidList.length; i++) {
                this.QuuidList[i] = new String(source.QuuidList[i]);
            }
        }
        if (source.MonitoringPattern != null) {
            this.MonitoringPattern = new Long(source.MonitoringPattern);
        }
        if (source.Cycle != null) {
            this.Cycle = new Long(source.Cycle);
        }
        if (source.EnableScan != null) {
            this.EnableScan = new Long(source.EnableScan);
        }
        if (source.Id != null) {
            this.Id = new Long(source.Id);
        }
        if (source.RealTimeMonitoring != null) {
            this.RealTimeMonitoring = new Long(source.RealTimeMonitoring);
        }
        if (source.AutoIsolation != null) {
            this.AutoIsolation = new Long(source.AutoIsolation);
        }
        if (source.ClickTimeout != null) {
            this.ClickTimeout = new Long(source.ClickTimeout);
        }
        if (source.KillProcess != null) {
            this.KillProcess = new Long(source.KillProcess);
        }
        if (source.EngineType != null) {
            this.EngineType = new Long(source.EngineType);
        }
        if (source.EnableInspiredEngine != null) {
            this.EnableInspiredEngine = new Long(source.EnableInspiredEngine);
        }
        if (source.EnableMemShellScan != null) {
            this.EnableMemShellScan = new Long(source.EnableMemShellScan);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "CheckPattern", this.CheckPattern);
        this.setParamSimple(map, prefix + "StartTime", this.StartTime);
        this.setParamSimple(map, prefix + "EndTime", this.EndTime);
        this.setParamSimple(map, prefix + "IsGlobal", this.IsGlobal);
        this.setParamArraySimple(map, prefix + "QuuidList.", this.QuuidList);
        this.setParamSimple(map, prefix + "MonitoringPattern", this.MonitoringPattern);
        this.setParamSimple(map, prefix + "Cycle", this.Cycle);
        this.setParamSimple(map, prefix + "EnableScan", this.EnableScan);
        this.setParamSimple(map, prefix + "Id", this.Id);
        this.setParamSimple(map, prefix + "RealTimeMonitoring", this.RealTimeMonitoring);
        this.setParamSimple(map, prefix + "AutoIsolation", this.AutoIsolation);
        this.setParamSimple(map, prefix + "ClickTimeout", this.ClickTimeout);
        this.setParamSimple(map, prefix + "KillProcess", this.KillProcess);
        this.setParamSimple(map, prefix + "EngineType", this.EngineType);
        this.setParamSimple(map, prefix + "EnableInspiredEngine", this.EnableInspiredEngine);
        this.setParamSimple(map, prefix + "EnableMemShellScan", this.EnableMemShellScan);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

