/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeMalwareRiskWarningResponse extends AbstractModel {

    /**
    * 是否开启自动扫描：true-开启，false-未开启
    */
    @SerializedName("IsCheckRisk")
    @Expose
    private Boolean IsCheckRisk;

    /**
    * 风险文件列表信息
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("List")
    @Expose
    private MalwareRisk [] List;

    /**
    * 是否弹出提示 true 弹出, false不弹
    */
    @SerializedName("IsPop")
    @Expose
    private Boolean IsPop;

    /**
    * 异常进程列表信息
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("ProcessList")
    @Expose
    private MalwareRisk [] ProcessList;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 是否开启自动扫描：true-开启，false-未开启 
     * @return IsCheckRisk 是否开启自动扫描：true-开启，false-未开启
     */
    public Boolean getIsCheckRisk() {
        return this.IsCheckRisk;
    }

    /**
     * Set 是否开启自动扫描：true-开启，false-未开启
     * @param IsCheckRisk 是否开启自动扫描：true-开启，false-未开启
     */
    public void setIsCheckRisk(Boolean IsCheckRisk) {
        this.IsCheckRisk = IsCheckRisk;
    }

    /**
     * Get 风险文件列表信息
注意：此字段可能返回 null，表示取不到有效值。 
     * @return List 风险文件列表信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public MalwareRisk [] getList() {
        return this.List;
    }

    /**
     * Set 风险文件列表信息
注意：此字段可能返回 null，表示取不到有效值。
     * @param List 风险文件列表信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setList(MalwareRisk [] List) {
        this.List = List;
    }

    /**
     * Get 是否弹出提示 true 弹出, false不弹 
     * @return IsPop 是否弹出提示 true 弹出, false不弹
     */
    public Boolean getIsPop() {
        return this.IsPop;
    }

    /**
     * Set 是否弹出提示 true 弹出, false不弹
     * @param IsPop 是否弹出提示 true 弹出, false不弹
     */
    public void setIsPop(Boolean IsPop) {
        this.IsPop = IsPop;
    }

    /**
     * Get 异常进程列表信息
注意：此字段可能返回 null，表示取不到有效值。 
     * @return ProcessList 异常进程列表信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public MalwareRisk [] getProcessList() {
        return this.ProcessList;
    }

    /**
     * Set 异常进程列表信息
注意：此字段可能返回 null，表示取不到有效值。
     * @param ProcessList 异常进程列表信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setProcessList(MalwareRisk [] ProcessList) {
        this.ProcessList = ProcessList;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeMalwareRiskWarningResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeMalwareRiskWarningResponse(DescribeMalwareRiskWarningResponse source) {
        if (source.IsCheckRisk != null) {
            this.IsCheckRisk = new Boolean(source.IsCheckRisk);
        }
        if (source.List != null) {
            this.List = new MalwareRisk[source.List.length];
            for (int i = 0; i < source.List.length; i++) {
                this.List[i] = new MalwareRisk(source.List[i]);
            }
        }
        if (source.IsPop != null) {
            this.IsPop = new Boolean(source.IsPop);
        }
        if (source.ProcessList != null) {
            this.ProcessList = new MalwareRisk[source.ProcessList.length];
            for (int i = 0; i < source.ProcessList.length; i++) {
                this.ProcessList[i] = new MalwareRisk(source.ProcessList[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "IsCheckRisk", this.IsCheckRisk);
        this.setParamArrayObj(map, prefix + "List.", this.List);
        this.setParamSimple(map, prefix + "IsPop", this.IsPop);
        this.setParamArrayObj(map, prefix + "ProcessList.", this.ProcessList);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

