/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common.http;

import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import java.io.IOException;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;

public class HttpConnection {
    private OkHttpClient client = new OkHttpClient();

    public HttpConnection(Integer connTimeout, Integer readTimeout, Integer writeTimeout) {
        this.client.setConnectTimeout(connTimeout.intValue(), TimeUnit.SECONDS);
        this.client.setReadTimeout(readTimeout.intValue(), TimeUnit.SECONDS);
        this.client.setWriteTimeout(writeTimeout.intValue(), TimeUnit.SECONDS);
    }

    public void addInterceptors(Interceptor interceptor) {
        this.client.interceptors().add(interceptor);
    }

    public void setProxy(Proxy proxy) {
        this.client.setProxy(proxy);
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.client.setAuthenticator(authenticator);
    }

    public Response doRequest(Request request) throws TencentCloudSDKException {
        Response response = null;
        try {
            response = this.client.newCall(request).execute();
        }
        catch (IOException e) {
            throw new TencentCloudSDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return response;
    }

    public Response getRequest(String url) throws TencentCloudSDKException {
        Request request = null;
        try {
            request = new Request.Builder().url(url).get().build();
        }
        catch (IllegalArgumentException e) {
            throw new TencentCloudSDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }

    public Response getRequest(String url, Headers headers) throws TencentCloudSDKException {
        Request request = null;
        try {
            request = new Request.Builder().url(url).headers(headers).get().build();
        }
        catch (IllegalArgumentException e) {
            throw new TencentCloudSDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }

    public Response postRequest(String url, String body) throws TencentCloudSDKException {
        MediaType contentType = MediaType.parse("application/x-www-form-urlencoded");
        Request request = null;
        try {
            request = new Request.Builder().url(url).post(RequestBody.create(contentType, body)).build();
        }
        catch (IllegalArgumentException e) {
            throw new TencentCloudSDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }

    public Response postRequest(String url, String body, Headers headers) throws TencentCloudSDKException {
        MediaType contentType = MediaType.parse(headers.get("Content-Type"));
        Request request = null;
        try {
            request = new Request.Builder().url(url).post(RequestBody.create(contentType, body)).headers(headers).build();
        }
        catch (IllegalArgumentException e) {
            throw new TencentCloudSDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }

    public Response postRequest(String url, byte[] body, Headers headers) throws TencentCloudSDKException {
        MediaType contentType = MediaType.parse(headers.get("Content-Type"));
        Request request = null;
        try {
            request = new Request.Builder().url(url).post(RequestBody.create(contentType, body)).headers(headers).build();
        }
        catch (IllegalArgumentException e) {
            throw new TencentCloudSDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }
}

