/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.decoder;

import com.tencent.tinker.bsdiff.BSDiff;
import com.tencent.tinker.build.decoder.BaseDecoder;
import com.tencent.tinker.build.info.InfoWriter;
import com.tencent.tinker.build.patch.Configuration;
import com.tencent.tinker.build.util.FileOperation;
import com.tencent.tinker.build.util.Logger;
import com.tencent.tinker.build.util.MD5;
import com.tencent.tinker.build.util.TinkerPatchException;
import com.tencent.tinker.build.util.Utils;
import java.io.File;
import java.io.IOException;

public class BsDiffDecoder
extends BaseDecoder {
    private final InfoWriter logWriter;
    private final InfoWriter metaWriter;

    public BsDiffDecoder(Configuration config, String metaPath, String logPath) throws IOException {
        super(config);
        this.metaWriter = metaPath != null ? new InfoWriter(config, config.mTempResultDir + File.separator + metaPath) : null;
        this.logWriter = logPath != null ? new InfoWriter(config, config.mOutFolder + File.separator + logPath) : null;
    }

    @Override
    public void clean() {
        this.logWriter.close();
        this.metaWriter.close();
    }

    @Override
    public boolean patch(File oldFile, File newFile) throws IOException, TinkerPatchException {
        if (newFile == null || !newFile.exists()) {
            return false;
        }
        String newMd5 = MD5.getMD5(newFile);
        File bsDiffFile = this.getOutputPath(newFile).toFile();
        if (oldFile == null || !oldFile.exists()) {
            FileOperation.copyFileUsingStream(newFile, bsDiffFile);
            this.writeLogFiles(newFile, null, null, newMd5);
            return true;
        }
        if (oldFile.length() == 0L && newFile.length() == 0L) {
            return false;
        }
        if (oldFile.length() == 0L || newFile.length() == 0L) {
            FileOperation.copyFileUsingStream(newFile, bsDiffFile);
            this.writeLogFiles(newFile, null, null, newMd5);
            return true;
        }
        String oldMd5 = MD5.getMD5(oldFile);
        if (oldMd5.equals(newMd5)) {
            return false;
        }
        if (!bsDiffFile.getParentFile().exists()) {
            bsDiffFile.getParentFile().mkdirs();
        }
        BSDiff.bsdiff((File)oldFile, (File)newFile, (File)bsDiffFile);
        if (Utils.checkBsDiffFileSize(bsDiffFile, newFile)) {
            this.writeLogFiles(newFile, oldFile, bsDiffFile, newMd5);
        } else {
            FileOperation.copyFileUsingStream(newFile, bsDiffFile);
            this.writeLogFiles(newFile, null, null, newMd5);
        }
        return true;
    }

    @Override
    public void onAllPatchesStart() throws IOException, TinkerPatchException {
    }

    @Override
    public void onAllPatchesEnd() throws IOException, TinkerPatchException {
    }

    protected void writeLogFiles(File newFile, File oldFile, File bsDiff, String newMd5) throws IOException {
        if (this.metaWriter == null && this.logWriter == null) {
            return;
        }
        String parentRelative = this.getParentRelativePathStringToNewFile(newFile);
        String relative = this.getRelativePathStringToNewFile(newFile);
        if (this.metaWriter != null) {
            String meta;
            String fileName = newFile.getName();
            if (bsDiff == null || oldFile == null) {
                meta = fileName + "," + parentRelative + "," + newMd5 + "," + 0 + "," + 0;
            } else {
                String oldCrc = FileOperation.getZipEntryCrc(this.config.mOldApkFile, relative);
                if (oldCrc == null || oldCrc.equals("0")) {
                    throw new TinkerPatchException(String.format("can't find zipEntry %s from old apk file %s", relative, this.config.mOldApkFile.getPath()));
                }
                meta = fileName + "," + parentRelative + "," + newMd5 + "," + oldCrc + "," + MD5.getMD5(bsDiff);
            }
            Logger.d("BsDiffDecoder:write meta file data: %s", meta);
            this.metaWriter.writeLineToInfoFile(meta);
        }
        if (this.logWriter != null) {
            String log = relative + ", oldSize=" + FileOperation.getFileSizes(oldFile) + ", newSize=" + FileOperation.getFileSizes(newFile) + ", diffSize=" + FileOperation.getFileSizes(bsDiff);
            this.logWriter.writeLineToInfoFile(log);
        }
    }
}

