/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.decoder;

import com.tencent.tinker.build.apkparser.AndroidParser;
import com.tencent.tinker.build.decoder.BaseDecoder;
import com.tencent.tinker.build.info.InfoWriter;
import com.tencent.tinker.build.patch.Configuration;
import com.tencent.tinker.build.util.DiffFactory;
import com.tencent.tinker.build.util.FileOperation;
import com.tencent.tinker.build.util.Logger;
import com.tencent.tinker.build.util.MD5;
import com.tencent.tinker.build.util.TinkerPatchException;
import com.tencent.tinker.build.util.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import tinker.net.dongliu.apk.parser.ApkParser;
import tinker.net.dongliu.apk.parser.struct.ResourceValue;
import tinker.net.dongliu.apk.parser.struct.resource.ResourceEntry;
import tinker.net.dongliu.apk.parser.struct.resource.ResourcePackage;
import tinker.net.dongliu.apk.parser.struct.resource.Type;

public class ResDiffDecoder
extends BaseDecoder {
    private static final String TEST_RESOURCE_NAME = "only_use_to_test_tinker_resource.txt";
    private static final String TEST_RESOURCE_ASSETS_PATH = "assets/only_use_to_test_tinker_resource.txt";
    private static final String TEMP_RES_ZIP = "temp_res.zip";
    private final InfoWriter logWriter;
    private final InfoWriter metaWriter;
    private ArrayList<String> addedSet;
    private ArrayList<String> modifiedSet;
    private ArrayList<String> storedSet;
    private ArrayList<String> largeModifiedSet;
    private HashMap<String, LargeModeInfo> largeModifiedMap;
    private ArrayList<String> deletedSet;
    private ApkParser newApkParser;
    private Set<String> newApkAnimResNames;

    public ResDiffDecoder(Configuration config, String metaPath, String logPath) throws IOException {
        super(config);
        this.metaWriter = metaPath != null ? new InfoWriter(config, config.mTempResultDir + File.separator + metaPath) : null;
        this.logWriter = logPath != null ? new InfoWriter(config, config.mOutFolder + File.separator + logPath) : null;
        this.addedSet = new ArrayList();
        this.modifiedSet = new ArrayList();
        this.largeModifiedSet = new ArrayList();
        this.largeModifiedMap = new HashMap();
        this.deletedSet = new ArrayList();
        this.storedSet = new ArrayList();
        this.newApkParser = new ApkParser(config.mNewApkFile);
        this.newApkAnimResNames = new HashSet<String>();
    }

    @Override
    public void clean() {
        this.metaWriter.close();
        this.logWriter.close();
        try {
            this.newApkParser.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean checkLargeModFile(File file) {
        long length = file.length();
        return length > (long)(this.config.mLargeModSize * 1024);
    }

    @Override
    public void onAllPatchesStart() throws IOException, TinkerPatchException {
        List newApkAnimResTypes;
        Map newApkResTypesNameMap;
        ResourcePackage newApkResPackage;
        this.newApkParser.parseResourceTable();
        Map newApkResPkgNameMap = this.newApkParser.getResourceTable().getPackageNameMap();
        if (newApkResPkgNameMap != null && (newApkResPackage = (ResourcePackage)newApkResPkgNameMap.get(this.newApkParser.getApkMeta().getPackageName())) != null && (newApkResTypesNameMap = newApkResPackage.getTypesNameMap()) != null && (newApkAnimResTypes = (List)newApkResTypesNameMap.get("anim")) != null) {
            for (Type animType : newApkAnimResTypes) {
                for (ResourceEntry value : animType.getResourceEntryNameHashMap().values()) {
                    ResourceValue resValue;
                    if (value == null || (resValue = value.getValue()) == null) continue;
                    this.newApkAnimResNames.add(resValue.toStringValue());
                }
            }
        }
    }

    @Override
    public boolean patch(File oldFile, File newFile) throws IOException, TinkerPatchException {
        String name = this.getRelativePathStringToNewFile(newFile);
        if (newFile == null || !newFile.exists()) {
            String relativeStringByOldDir = this.getRelativePathStringToOldFile(oldFile);
            if (Utils.checkFileInPattern(this.config.mResIgnoreChangePattern, relativeStringByOldDir)) {
                Logger.e("found delete resource: " + relativeStringByOldDir + " ,but it match ignore change pattern, just ignore!");
                return false;
            }
            this.deletedSet.add(relativeStringByOldDir);
            this.writeResLog(newFile, oldFile, 3);
            return true;
        }
        File outputFile = this.getOutputPath(newFile).toFile();
        if (oldFile == null || !oldFile.exists()) {
            if (Utils.checkFileInPattern(this.config.mResIgnoreChangePattern, name)) {
                Logger.e("found add resource: " + name + " ,but it match ignore change pattern, just ignore!");
                return false;
            }
            FileOperation.copyFileUsingStream(newFile, outputFile);
            this.addedSet.add(name);
            this.writeResLog(newFile, oldFile, 1);
            return true;
        }
        if (oldFile.length() == 0L && newFile.length() == 0L) {
            return false;
        }
        String newMd5 = MD5.getMD5(newFile);
        String oldMd5 = MD5.getMD5(oldFile);
        if (oldMd5 != null && oldMd5.equals(newMd5)) {
            return false;
        }
        if (Utils.checkFileInPattern(this.config.mResIgnoreChangePattern, name)) {
            Logger.d("found modify resource: " + name + ", but it match ignore change pattern, just ignore!");
            return false;
        }
        if (name.equals("AndroidManifest.xml")) {
            Logger.d("found modify resource: " + name + ", but it is AndroidManifest.xml, just ignore!");
            return false;
        }
        if (name.equals("resources.arsc") && AndroidParser.resourceTableLogicalChange(this.config)) {
            Logger.d("found modify resource: " + name + ", but it is logically the same as original new resources.arsc, just ignore!");
            return false;
        }
        this.dealWithModifyFile(name, newMd5, oldFile, newFile, outputFile);
        return true;
    }

    private boolean dealWithModifyFile(String name, String newMd5, File oldFile, File newFile, File outputFile) throws IOException {
        if (this.checkLargeModFile(newFile)) {
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            DiffFactory.diffFile(this.config, oldFile, newFile, outputFile);
            if (Utils.checkBsDiffFileSize(outputFile, newFile)) {
                LargeModeInfo largeModeInfo = new LargeModeInfo();
                largeModeInfo.path = newFile;
                largeModeInfo.crc = FileOperation.getFileCrc32(newFile);
                largeModeInfo.md5 = newMd5;
                this.largeModifiedSet.add(name);
                this.largeModifiedMap.put(name, largeModeInfo);
                this.writeResLog(newFile, oldFile, 4);
                return true;
            }
        }
        this.modifiedSet.add(name);
        FileOperation.copyFileUsingStream(newFile, outputFile);
        this.writeResLog(newFile, oldFile, 2);
        return false;
    }

    private void writeResLog(File newFile, File oldFile, int mode) throws IOException {
        if (this.logWriter != null) {
            String log = "";
            switch (mode) {
                case 1: {
                    String relative = this.getRelativePathStringToNewFile(newFile);
                    Logger.d("Found add resource: " + relative);
                    log = "add resource: " + relative + ", oldSize=" + FileOperation.getFileSizes(oldFile) + ", newSize=" + FileOperation.getFileSizes(newFile);
                    break;
                }
                case 2: {
                    String relative = this.getRelativePathStringToNewFile(newFile);
                    Logger.d("Found modify resource: " + relative);
                    log = "modify resource: " + relative + ", oldSize=" + FileOperation.getFileSizes(oldFile) + ", newSize=" + FileOperation.getFileSizes(newFile);
                    break;
                }
                case 3: {
                    String relative = this.getRelativePathStringToOldFile(oldFile);
                    Logger.d("Found deleted resource: " + relative);
                    log = "deleted resource: " + relative + ", oldSize=" + FileOperation.getFileSizes(oldFile) + ", newSize=" + FileOperation.getFileSizes(newFile);
                    break;
                }
                case 4: {
                    String relative = this.getRelativePathStringToNewFile(newFile);
                    Logger.d("Found large modify resource: " + relative + " size:" + newFile.length());
                    log = "large modify resource: " + relative + ", oldSize=" + FileOperation.getFileSizes(oldFile) + ", newSize=" + FileOperation.getFileSizes(newFile);
                    break;
                }
            }
            this.logWriter.writeLineToInfoFile(log);
        }
    }

    private void addAssetsFileForTestResource() throws IOException {
        File dest = new File(this.config.mTempResultDir + "/" + TEST_RESOURCE_ASSETS_PATH);
        FileOperation.copyResourceUsingStream(TEST_RESOURCE_NAME, dest);
        this.addedSet.add(TEST_RESOURCE_ASSETS_PATH);
        Logger.d("Add Test resource file: assets/only_use_to_test_tinker_resource.txt");
        String log = "add test resource: assets/only_use_to_test_tinker_resource.txt, oldSize=0, newSize=" + FileOperation.getFileSizes(dest);
        this.logWriter.writeLineToInfoFile(log);
    }

    @Override
    public void onAllPatchesEnd() throws IOException, TinkerPatchException {
        if (this.addedSet.isEmpty() && this.modifiedSet.isEmpty() && this.largeModifiedSet.isEmpty()) {
            return;
        }
        if (!this.config.mResRawPattern.contains("resources.arsc")) {
            throw new TinkerPatchException("resource must contain resources.arsc pattern");
        }
        if (!this.config.mResRawPattern.contains("AndroidManifest.xml")) {
            throw new TinkerPatchException("resource must contain AndroidManifest.xml pattern");
        }
        if (this.config.mUsingGradle) {
            boolean resourceArscChanged;
            boolean ignoreWarning = this.config.mIgnoreWarning;
            boolean bl = resourceArscChanged = this.modifiedSet.contains("resources.arsc") || this.largeModifiedSet.contains("resources.arsc");
            if (resourceArscChanged && !this.config.mUseApplyResource) {
                if (ignoreWarning) {
                    Logger.e("Warning:ignoreWarning is true, but resources.arsc is changed, you should use applyResourceMapping mode to build the new apk, otherwise, it may be crash at some times");
                } else {
                    Logger.e("Warning:ignoreWarning is false, but resources.arsc is changed, you should use applyResourceMapping mode to build the new apk, otherwise, it may be crash at some times");
                    throw new TinkerPatchException(String.format("ignoreWarning is false, but resources.arsc is changed, you should use applyResourceMapping mode to build the new apk, otherwise, it may be crash at some times", new Object[0]));
                }
            }
        }
        this.deletedSet.addAll(this.getDeletedResource(this.config.mTempUnzipOldDir, this.config.mTempUnzipNewDir));
        this.addedSet.remove("AndroidManifest.xml");
        this.deletedSet.remove("AndroidManifest.xml");
        this.modifiedSet.remove("AndroidManifest.xml");
        this.largeModifiedSet.remove("AndroidManifest.xml");
        this.removeIgnoreChangeFile(this.modifiedSet);
        this.removeIgnoreChangeFile(this.deletedSet);
        this.removeIgnoreChangeFile(this.addedSet);
        this.removeIgnoreChangeFile(this.largeModifiedSet);
        this.checkIfSpecificResWasAnimRes(this.addedSet);
        this.checkIfSpecificResWasAnimRes(this.modifiedSet);
        this.checkIfSpecificResWasAnimRes(this.largeModifiedSet);
        this.addAssetsFileForTestResource();
        File tempResZip = new File(this.config.mOutFolder + File.separator + TEMP_RES_ZIP);
        File tempResFiles = this.config.mTempResultDir;
        FileOperation.zipInputDir(tempResFiles, tempResZip, null);
        File extractToZip = new File(this.config.mOutFolder + File.separator + "resources_out.zip");
        String resZipMd5 = Utils.genResOutputFile(extractToZip, tempResZip, this.config, this.addedSet, this.modifiedSet, this.deletedSet, this.largeModifiedSet, this.largeModifiedMap);
        Logger.e("Final normal zip resource: %s, size=%d, md5=%s", extractToZip.getName(), extractToZip.length(), resZipMd5);
        this.logWriter.writeLineToInfoFile(String.format("Final normal zip resource: %s, size=%d, md5=%s", extractToZip.getName(), extractToZip.length(), resZipMd5));
        FileOperation.deleteFile(tempResZip);
        String arscBaseCrc = FileOperation.getZipEntryCrc(this.config.mOldApkFile, "resources.arsc");
        String arscMd5 = FileOperation.getZipEntryMd5(extractToZip, "resources.arsc");
        if (arscBaseCrc == null || arscMd5 == null) {
            throw new TinkerPatchException("can't find resources.arsc's base crc or md5");
        }
        String resourceMeta = Utils.getResourceMeta(arscBaseCrc, arscMd5);
        this.writeMetaFile(resourceMeta);
        String patternMeta = "pattern:";
        HashSet<String> patterns = new HashSet<String>(this.config.mResRawPattern);
        patterns.remove("AndroidManifest.xml");
        this.writeMetaFile(patternMeta + patterns.size());
        for (String item : patterns) {
            this.writeMetaFile(item);
        }
        this.getCompressMethodFromApk();
        this.writeMetaFile(this.largeModifiedSet, 4);
        this.writeMetaFile(this.modifiedSet, 2);
        this.writeMetaFile(this.addedSet, 1);
        this.writeMetaFile(this.deletedSet, 3);
        this.writeMetaFile(this.storedSet, 5);
    }

    private void checkIfSpecificResWasAnimRes(Collection<String> specificFileNames) {
        HashSet<String> changedAnimResNames = new HashSet<String>();
        for (String resFileName : specificFileNames) {
            if (!this.newApkAnimResNames.contains(resFileName)) continue;
            if (Utils.isStringMatchesPatterns(resFileName, this.config.mResIgnoreChangeWarningPattern)) {
                Logger.d("\nAnimation resource: " + resFileName + " was changed, but it's filtered by ignoreChangeWarning pattern, just ignore.\n");
                continue;
            }
            changedAnimResNames.add(resFileName);
        }
        if (!changedAnimResNames.isEmpty()) {
            if (this.config.mIgnoreWarning) {
                Logger.e("Warning:ignoreWarning is true, but we found animation resource is changed. Please check if any one was used in 'overridePendingTransition' which may leads to crash. If all of them were not used in that method, just add them into 'res { ignoreChangeWarning }' option.\nrelated res: " + changedAnimResNames + "\n");
            } else {
                Logger.e("Warning:ignoreWarning is false, but we found animation resource is changed. Please check if any one was used in 'overridePendingTransition' which may leads to crash. If all of them were not used in that method, just add them into 'res { ignoreChangeWarning }' option.\nrelated res: " + changedAnimResNames + "\n");
                throw new TinkerPatchException("ignoreWarning is false, but we found animation resource is changed. Please check if any one was used in 'overridePendingTransition' which may leads to crash. If all of them were not used in that method, just add them into 'res { ignoreChangeWarning }' option.\nrelated res: " + changedAnimResNames);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCompressMethodFromApk() {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.config.mNewApkFile);
            ArrayList<String> sets = new ArrayList<String>();
            sets.addAll(this.modifiedSet);
            sets.addAll(this.addedSet);
            for (String name : sets) {
                ZipEntry zipEntry = zipFile.getEntry(name);
                if (zipEntry == null || zipEntry.getMethod() != 0) continue;
                this.storedSet.add(name);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void removeIgnoreChangeFile(ArrayList<String> array) {
        ArrayList<String> removeList = new ArrayList<String>();
        for (String name : array) {
            if (!Utils.checkFileInPattern(this.config.mResIgnoreChangePattern, name)) continue;
            Logger.e("ignore change resource file: " + name);
            removeList.add(name);
        }
        array.removeAll(removeList);
    }

    private void writeMetaFile(String line) {
        this.metaWriter.writeLineToInfoFile(line);
    }

    private void writeMetaFile(ArrayList<String> set, int mode) {
        if (!set.isEmpty()) {
            String title = "";
            switch (mode) {
                case 1: {
                    title = "add:" + set.size();
                    break;
                }
                case 2: {
                    title = "modify:" + set.size();
                    break;
                }
                case 4: {
                    title = "large modify:" + set.size();
                    break;
                }
                case 3: {
                    title = "delete:" + set.size();
                    break;
                }
                case 5: {
                    title = "store:" + set.size();
                    break;
                }
            }
            this.metaWriter.writeLineToInfoFile(title);
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                String name;
                String line = name = iterator.next();
                if (mode == 4) {
                    LargeModeInfo info = this.largeModifiedMap.get(name);
                    line = name + "," + info.md5 + "," + info.crc;
                }
                this.metaWriter.writeLineToInfoFile(line);
            }
        }
    }

    public ArrayList<String> getDeletedResource(File oldApkDir, File newApkDir) throws IOException {
        DeletedResVisitor deletedResVisitor = new DeletedResVisitor(this.config, newApkDir.toPath(), oldApkDir.toPath());
        Files.walkFileTree(oldApkDir.toPath(), deletedResVisitor);
        return deletedResVisitor.deletedFiles;
    }

    class DeletedResVisitor
    extends SimpleFileVisitor<Path> {
        Configuration config;
        Path newApkPath;
        Path oldApkPath;
        ArrayList<String> deletedFiles;

        DeletedResVisitor(Configuration config, Path newPath, Path oldPath) {
            this.config = config;
            this.newApkPath = newPath;
            this.oldApkPath = oldPath;
            this.deletedFiles = new ArrayList();
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path relativePath = this.oldApkPath.relativize(file);
            Path newPath = this.newApkPath.resolve(relativePath);
            String patternKey = relativePath.toString().replace("\\", "/");
            if (Utils.checkFileInPattern(this.config.mResFilePattern, patternKey)) {
                if (!newPath.toFile().exists()) {
                    this.deletedFiles.add(patternKey);
                    ResDiffDecoder.this.writeResLog(newPath.toFile(), file.toFile(), 3);
                }
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.CONTINUE;
        }
    }

    public class LargeModeInfo {
        public File path = null;
        public long crc;
        public String md5 = null;
    }
}

