/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.decoder;

import com.tencent.tinker.build.apkparser.AndroidParser;
import com.tencent.tinker.build.decoder.BaseDecoder;
import com.tencent.tinker.build.patch.Configuration;
import com.tencent.tinker.build.util.Logger;
import com.tencent.tinker.build.util.TinkerPatchException;
import com.tencent.tinker.build.util.Utils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;
import tinker.net.dongliu.apk.parser.bean.ApkMeta;
import tinker.net.dongliu.apk.parser.bean.GlEsVersion;
import tinker.net.dongliu.apk.parser.bean.Permission;
import tinker.net.dongliu.apk.parser.bean.UseFeature;

public class ManifestDecoder
extends BaseDecoder {
    private static final String XML_NODENAME_APPLICATION = "application";
    private static final String XML_NODENAME_USES_SDK = "uses-sdk";
    private static final String XML_NODEATTR_MIN_SDK_VERSION = "minSdkVersion";
    private static final String XML_NODEATTR_TARGET_SDK_VERSION = "targetSdkVersion";
    private static final String XML_NODEATTR_PACKAGE = "package";
    private static final String XML_NODENAME_ACTIVITY = "activity";
    private static final String XML_NODENAME_SERVICE = "service";
    private static final String XML_NODENAME_RECEIVER = "receiver";
    private static final String XML_NODENAME_PROVIDER = "provider";
    private static final String XML_NODEATTR_NAME = "name";
    private static final String XML_NODEATTR_EXPORTED = "exported";
    private static final String XML_NODEATTR_PROCESS = "process";
    private static final String XML_NODENAME_INTENTFILTER = "intent-filter";
    private static final EqualsChecker<GlEsVersion> GLES_VERSION_EQUALS = new EqualsChecker<GlEsVersion>(){

        @Override
        public boolean isEquals(GlEsVersion lhs, GlEsVersion rhs) {
            if (lhs.getMajor() != rhs.getMajor()) {
                return false;
            }
            if (lhs.getMinor() != rhs.getMinor()) {
                return false;
            }
            return lhs.isRequired() == rhs.isRequired();
        }
    };
    private static final ObjectDescriber<GlEsVersion> GLES_VERSION_DESCRIBER = new ObjectDescriber<GlEsVersion>(){

        @Override
        public String describe(GlEsVersion obj) {
            StringBuilder sb = new StringBuilder();
            sb.append("{").append("majar:").append(obj.getMajor()).append("minor:").append(obj.getMinor()).append(",required:").append(obj.isRequired()).append("}");
            return sb.toString();
        }
    };
    private static final ObjectDescriber<UseFeature> USE_FEATURE_DESCRIBER = new ObjectDescriber<UseFeature>(){

        @Override
        public String describe(UseFeature obj) {
            StringBuilder sb = new StringBuilder();
            sb.append("{").append("name:").append(obj.getName()).append(",required:").append(obj.isRequired()).append("}");
            return sb.toString();
        }
    };
    private static final ObjectDescriber<Permission> PERMISSION_DESCRIBER = new ObjectDescriber<Permission>(){

        @Override
        public String describe(Permission obj) {
            StringBuilder sb = new StringBuilder();
            sb.append("{").append("name:").append(obj.getName()).append(",label:").append(obj.getLabel()).append(",icon:").append(obj.getIcon()).append(",description:").append(obj.getDescription()).append(",group:").append(obj.getGroup()).append(",protectionLevel:").append(obj.getProtectionLevel()).append("}");
            return sb.toString();
        }
    };

    public ManifestDecoder(Configuration config) throws IOException {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean patch(File oldFile, File newFile) throws IOException, TinkerPatchException {
        try {
            boolean hasIncComponent;
            String newXml;
            String oldXml;
            boolean isManifestChanged;
            AndroidParser oldAndroidManifest = AndroidParser.getAndroidManifest(oldFile);
            AndroidParser newAndroidManifest = AndroidParser.getAndroidManifest(newFile);
            int minSdkVersion = Integer.parseInt(oldAndroidManifest.apkMeta.getMinSdkVersion());
            if (minSdkVersion < 14 && this.config.mDexRaw) {
                StringBuilder sb = new StringBuilder();
                sb.append("your old apk's minSdkVersion ").append(minSdkVersion).append(" is below 14, you should set the dexMode to 'jar', ").append("otherwise, it will crash at some time");
                this.announceWarningOrException(sb.toString());
            }
            boolean bl = isManifestChanged = !(oldXml = oldAndroidManifest.xml.trim()).equals(newXml = newAndroidManifest.xml.trim());
            if (!isManifestChanged) {
                Logger.d("\nManifest has no changes, skip rest decode works.");
                return false;
            }
            this.ensureApkMetaUnchanged(oldAndroidManifest.apkMeta, newAndroidManifest.apkMeta);
            Set<String> incActivities = this.getIncrementActivities(oldAndroidManifest.activities, newAndroidManifest.activities);
            Set<String> incServices = this.getIncrementServices(oldAndroidManifest.services, newAndroidManifest.services);
            Set<String> incReceivers = this.getIncrementReceivers(oldAndroidManifest.receivers, newAndroidManifest.receivers);
            Set<String> incProviders = this.getIncrementProviders(oldAndroidManifest.providers, newAndroidManifest.providers);
            boolean bl2 = hasIncComponent = !incActivities.isEmpty() || !incServices.isEmpty() || !incProviders.isEmpty() || !incReceivers.isEmpty();
            if (!this.config.mSupportHotplugComponent && hasIncComponent) {
                this.announceWarningOrException("manifest was changed, while hot plug component support mode is disabled. Such changes will not take effect, related components: \n activity: " + incActivities + "\n service: " + incServices + "\n receiver: " + incReceivers + "\n provider: " + incProviders + "\n");
            }
            if (hasIncComponent) {
                File incXmlOutput;
                Document newXmlDoc = DocumentHelper.parseText((String)newAndroidManifest.xml);
                Document incXmlDoc = DocumentHelper.createDocument();
                Element newRootNode = newXmlDoc.getRootElement();
                String packageName = newRootNode.attributeValue(XML_NODEATTR_PACKAGE);
                if (Utils.isNullOrNil(packageName)) {
                    throw new TinkerPatchException("Unable to find package name from manifest: " + newFile.getAbsolutePath());
                }
                Element newAppNode = newRootNode.element(XML_NODENAME_APPLICATION);
                Element incAppNode = incXmlDoc.addElement(newAppNode.getQName());
                this.copyAttributes(newAppNode, incAppNode);
                if (!incActivities.isEmpty()) {
                    List newActivityNodes = newAppNode.elements(XML_NODENAME_ACTIVITY);
                    List<Element> incActivityNodes = this.getIncrementActivityNodes(packageName, newActivityNodes, incActivities);
                    for (Element node : incActivityNodes) {
                        incAppNode.add(node.detach());
                    }
                }
                if (!incServices.isEmpty()) {
                    List newServiceNodes = newAppNode.elements(XML_NODENAME_SERVICE);
                    List<Element> incServiceNodes = this.getIncrementServiceNodes(packageName, newServiceNodes, incServices);
                    for (Element node : incServiceNodes) {
                        incAppNode.add(node.detach());
                    }
                }
                if (!incReceivers.isEmpty()) {
                    List newReceiverNodes = newAppNode.elements(XML_NODENAME_RECEIVER);
                    List<Element> incReceiverNodes = this.getIncrementReceiverNodes(packageName, newReceiverNodes, incReceivers);
                    for (Element node : incReceiverNodes) {
                        incAppNode.add(node.detach());
                    }
                }
                if (!incProviders.isEmpty()) {
                    List newProviderNodes = newAppNode.elements(XML_NODENAME_PROVIDER);
                    List<Element> incProviderNodes = this.getIncrementProviderNodes(packageName, newProviderNodes, incProviders);
                    for (Element node : incProviderNodes) {
                        incAppNode.add(node.detach());
                    }
                }
                if (!(incXmlOutput = new File(this.config.mTempResultDir, "assets/inc_component_meta.txt")).exists()) {
                    incXmlOutput.getParentFile().mkdirs();
                }
                BufferedOutputStream os = null;
                try {
                    os = new BufferedOutputStream(new FileOutputStream(incXmlOutput));
                    XMLWriter docWriter = new XMLWriter((OutputStream)os);
                    docWriter.write(incXmlDoc);
                    docWriter.close();
                }
                catch (Throwable throwable) {
                    Utils.closeQuietly(os);
                    throw throwable;
                }
                Utils.closeQuietly(os);
            }
            if (isManifestChanged && !hasIncComponent) {
                Logger.d("\nManifest was changed, while there's no any new components added. Make sure if such changes were all you expected.\n");
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new TinkerPatchException("Parse android manifest error!");
        }
        catch (DocumentException e) {
            e.printStackTrace();
            throw new TinkerPatchException("Parse android manifest by dom4j error!");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TinkerPatchException("Failed to generate increment manifest.", e);
        }
        return false;
    }

    private void ensureApkMetaUnchanged(ApkMeta oldMeta, ApkMeta newMeta) {
        if (oldMeta == null && newMeta == null) {
            return;
        }
        if (oldMeta != null && newMeta != null) {
            if (!ManifestDecoder.nullSafeEquals(oldMeta.getPackageName(), newMeta.getPackageName(), null)) {
                this.announceWarningOrException("Package name changed, old: " + oldMeta.getPackageName() + ", new: " + newMeta.getPackageName());
            }
            if (!ManifestDecoder.nullSafeEquals(oldMeta.getLabel(), newMeta.getLabel(), null)) {
                this.announceWarningOrException("App label changed, old: " + oldMeta.getLabel() + ", new: " + newMeta.getLabel());
            }
            if (!ManifestDecoder.nullSafeEquals(oldMeta.getIcon(), newMeta.getIcon(), null)) {
                this.announceWarningOrException("App icon res ref changed, old: " + oldMeta.getIcon() + ", new: " + newMeta.getIcon());
            }
            if (!ManifestDecoder.nullSafeEquals(oldMeta.getVersionName(), newMeta.getVersionName(), null)) {
                Logger.e("Note: Version name changed, old: " + oldMeta.getVersionName() + ", new: " + newMeta.getVersionName());
            }
            Long oldVersionCode = oldMeta.getVersionCode();
            Long newVersionCode = newMeta.getVersionCode();
            if (oldVersionCode != null && newVersionCode != null) {
                if (newVersionCode < oldVersionCode) {
                    this.announceWarningOrException("Version code downgrade, old: " + oldVersionCode + ", new: " + newVersionCode);
                }
            } else if (oldVersionCode != null || newVersionCode != null) {
                this.announceWarningOrException("Version code of old or new apk is missing, old: " + oldVersionCode + ", new: " + newVersionCode);
            }
            if (!ManifestDecoder.nullSafeEquals(oldMeta.getInstallLocation(), newMeta.getInstallLocation(), null)) {
                this.announceWarningOrException("Install location changed, old: " + oldMeta.getInstallLocation() + ", new: " + newMeta.getInstallLocation());
            }
            if (!ManifestDecoder.nullSafeEquals(oldMeta.getMinSdkVersion(), newMeta.getMinSdkVersion(), null)) {
                this.announceWarningOrException("MinSdkVersion changed, old: " + oldMeta.getMinSdkVersion() + ", new: " + newMeta.getMinSdkVersion());
            }
            if (!ManifestDecoder.nullSafeEquals(oldMeta.getTargetSdkVersion(), newMeta.getTargetSdkVersion(), null)) {
                this.announceWarningOrException("TargetSdkVersion changed, old: " + oldMeta.getTargetSdkVersion() + ", new: " + newMeta.getTargetSdkVersion());
            }
            if (!ManifestDecoder.nullSafeEquals(oldMeta.getMaxSdkVersion(), newMeta.getMaxSdkVersion(), null)) {
                this.announceWarningOrException("MaxSdkVersion changed, old: " + oldMeta.getMaxSdkVersion() + ", new: " + newMeta.getMaxSdkVersion());
            }
            if (!ManifestDecoder.nullSafeEquals(oldMeta.getGlEsVersion(), newMeta.getGlEsVersion(), GLES_VERSION_EQUALS)) {
                this.announceWarningOrException("GLEsVersion changed, old: " + GLES_VERSION_DESCRIBER.describe(oldMeta.getGlEsVersion()) + ", new: " + GLES_VERSION_DESCRIBER.describe(newMeta.getGlEsVersion()));
            }
            if (!ManifestDecoder.nullSafeEquals(oldMeta.isAnyDensity(), newMeta.isAnyDensity(), null)) {
                this.announceWarningOrException("Value of isAnyDensity changed, old: " + oldMeta.isAnyDensity() + ", new: " + newMeta.isAnyDensity());
            }
            if (!ManifestDecoder.nullSafeEquals(oldMeta.isSmallScreens(), newMeta.isSmallScreens(), null)) {
                this.announceWarningOrException("Value of isSmallScreens changed, old: " + oldMeta.isSmallScreens() + ", new: " + newMeta.isSmallScreens());
            }
            if (!ManifestDecoder.nullSafeEquals(oldMeta.isNormalScreens(), newMeta.isNormalScreens(), null)) {
                this.announceWarningOrException("Value of isNormalScreens changed, old: " + oldMeta.isNormalScreens() + ", new: " + newMeta.isNormalScreens());
            }
            if (!ManifestDecoder.nullSafeEquals(oldMeta.isLargeScreens(), newMeta.isLargeScreens(), null)) {
                this.announceWarningOrException("Value of isLargeScreens changed, old: " + oldMeta.isLargeScreens() + ", new: " + newMeta.isLargeScreens());
            }
            if (!ManifestDecoder.nullSafeEqualsIgnoreOrder(oldMeta.getUsesPermissions(), newMeta.getUsesPermissions(), null)) {
                this.announceWarningOrException("Uses permissions changed, related uses-permissions: " + ManifestDecoder.describeChanges(oldMeta.getUsesPermissions(), newMeta.getUsesPermissions()));
            }
            if (!ManifestDecoder.nullSafeEqualsIgnoreOrder(oldMeta.getUsesFeatures(), newMeta.getUsesFeatures(), USE_FEATURE_DESCRIBER)) {
                this.announceWarningOrException("Uses features changed, related uses-features: " + ManifestDecoder.describeChanges(oldMeta.getUsesFeatures(), newMeta.getUsesFeatures(), USE_FEATURE_DESCRIBER));
            }
            if (!ManifestDecoder.nullSafeEqualsIgnoreOrder(oldMeta.getPermissions(), newMeta.getPermissions(), PERMISSION_DESCRIBER)) {
                this.announceWarningOrException("Uses features changed, related permissions: " + ManifestDecoder.describeChanges(oldMeta.getPermissions(), newMeta.getPermissions(), PERMISSION_DESCRIBER));
            }
        } else {
            this.announceWarningOrException("One of apk meta is null, are we processing invalid manifest ?");
        }
    }

    private static <T> boolean nullSafeEquals(T lhs, T rhs, EqualsChecker<T> equalsChecker) {
        if (lhs == null && rhs == null) {
            return true;
        }
        if (lhs != null && rhs != null) {
            return equalsChecker != null ? equalsChecker.isEquals(lhs, rhs) : lhs.equals(rhs);
        }
        return false;
    }

    private static <T> boolean nullSafeEqualsIgnoreOrder(List<T> lhs, List<T> rhs, ObjectDescriber<T> describer) {
        if (lhs == null && rhs == null) {
            return true;
        }
        if (lhs != null && rhs != null) {
            HashSet<String> lhsDescs = new HashSet<String>();
            int lhsNotNullElemCount = 0;
            int rhsNotNullElemCount = 0;
            for (int i = 0; i < lhs.size(); ++i) {
                T lhsElem = lhs.get(i);
                if (lhsElem == null) continue;
                lhsDescs.add(describer != null ? describer.describe(lhsElem) : lhsElem.toString());
                ++lhsNotNullElemCount;
            }
            boolean hasAddedElemDesc = false;
            for (int i = 0; i < rhs.size(); ++i) {
                String rhsElemDesc;
                T rhsElem = rhs.get(i);
                if (rhsElem == null) continue;
                String string = rhsElemDesc = describer != null ? describer.describe(rhsElem) : rhsElem.toString();
                if (!lhsDescs.remove(rhsElemDesc)) {
                    hasAddedElemDesc = true;
                    break;
                }
                ++rhsNotNullElemCount;
            }
            if (hasAddedElemDesc) {
                return false;
            }
            if (lhsDescs.size() > 0) {
                return false;
            }
            return lhsNotNullElemCount == rhsNotNullElemCount;
        }
        return false;
    }

    private static <T> String describeChanges(Collection<T> oldObjs, Collection<T> newObjs) {
        return ManifestDecoder.describeChanges(oldObjs, newObjs, null);
    }

    private static <T> String describeChanges(Collection<T> oldObjs, Collection<T> newObjs, ObjectDescriber<T> describer) {
        HashSet<String> oldDescs = new HashSet<String>();
        ArrayList<String> addedDescs = new ArrayList<String>();
        for (T oldObj : oldObjs) {
            oldDescs.add(describer != null ? describer.describe(oldObj) : oldObj.toString());
        }
        for (T newObj : newObjs) {
            String newDesc = describer != null ? describer.describe(newObj) : newObj.toString();
            if (oldDescs.remove(newDesc)) continue;
            addedDescs.add(newDesc);
        }
        ArrayList removedDescs = new ArrayList(oldDescs);
        StringBuilder sb = new StringBuilder();
        sb.append("{added:").append(addedDescs).append(",removed:").append(removedDescs).append("}");
        return sb.toString();
    }

    private Set<String> getIncrementActivities(Collection<String> oldActivities, Collection<String> newActivities) {
        HashSet<String> incNames = new HashSet<String>(newActivities);
        incNames.removeAll(oldActivities);
        return incNames;
    }

    private Set<String> getIncrementServices(Collection<String> oldServices, Collection<String> newServices) {
        HashSet<String> incNames = new HashSet<String>(newServices);
        incNames.removeAll(oldServices);
        if (!incNames.isEmpty()) {
            this.announceWarningOrException("found added services: " + ((Object)incNames).toString() + "\n currently tinker does not support increase new services, such these changes would not take effect.");
        }
        return incNames;
    }

    private Set<String> getIncrementReceivers(Collection<String> oldReceivers, Collection<String> newReceivers) {
        HashSet<String> incNames = new HashSet<String>(newReceivers);
        incNames.removeAll(oldReceivers);
        if (!incNames.isEmpty()) {
            this.announceWarningOrException("found added receivers: " + ((Object)incNames).toString() + "\n currently tinker does not support increase new receivers, such these changes would not take effect.");
        }
        return incNames;
    }

    private Set<String> getIncrementProviders(Collection<String> oldProviders, Collection<String> newProviders) {
        HashSet<String> incNames = new HashSet<String>(newProviders);
        incNames.removeAll(oldProviders);
        if (!incNames.isEmpty()) {
            this.announceWarningOrException("found added providers: " + ((Object)incNames).toString() + "\n currently tinker does not support increase new providers, such these changes would not take effect.");
        }
        return incNames;
    }

    private List<Element> getIncrementActivityNodes(String packageName, List<Element> newActivityNodes, Collection<String> incActivities) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element newActivityNode : newActivityNodes) {
            String processVal;
            String activityClazzName = newActivityNode.attributeValue(XML_NODEATTR_NAME);
            if (activityClazzName.charAt(0) == '.') {
                activityClazzName = packageName + activityClazzName;
            }
            if (!incActivities.contains(activityClazzName)) continue;
            String exportedVal = newActivityNode.attributeValue(XML_NODEATTR_EXPORTED, Utils.isNullOrNil(newActivityNode.elements(XML_NODENAME_INTENTFILTER)) ? "false" : "true");
            if ("true".equalsIgnoreCase(exportedVal)) {
                this.announceWarningOrException(String.format("found a new exported activity %s, tinker does not support increase exported activity.", activityClazzName));
            }
            if ((processVal = newActivityNode.attributeValue(XML_NODEATTR_PROCESS)) != null && processVal.charAt(0) == ':') {
                this.announceWarningOrException(String.format("found a new activity %s which would be run in standalone process, tinker does not support increase such kind of activities.", activityClazzName));
            }
            Logger.d("Found increment activity: " + activityClazzName);
            result.add(newActivityNode);
        }
        return result;
    }

    private List<Element> getIncrementServiceNodes(String packageName, List<Element> newServiceNodes, Collection<String> incServices) {
        this.announceWarningOrException("currently tinker does not support increase new services.");
        return Collections.emptyList();
    }

    private List<Element> getIncrementReceiverNodes(String packageName, List<Element> newReceiverNodes, Collection<String> incReceivers) {
        this.announceWarningOrException("currently tinker does not support increase new receivers.");
        return Collections.emptyList();
    }

    private List<Element> getIncrementProviderNodes(String packageName, List<Element> newProviderNodes, Collection<String> incProviders) {
        this.announceWarningOrException("currently tinker does not support increase new providers.");
        return Collections.emptyList();
    }

    private void copyAttributes(Element srcNode, Element destNode) {
        for (Object attrObj : srcNode.attributes()) {
            Attribute attr = (Attribute)attrObj;
            destNode.addAttribute(attr.getQName(), attr.getValue());
        }
    }

    private void announceWarningOrException(String message) {
        if (!this.config.mIgnoreWarning) {
            String msg = "Warning:ignoreWarning is false, " + message;
            Logger.e(msg);
            throw new TinkerPatchException(msg);
        }
        String msg = "Warning:ignoreWarning is true, but " + message;
        Logger.e(msg);
    }

    @Override
    public void onAllPatchesStart() throws IOException, TinkerPatchException {
    }

    @Override
    public void onAllPatchesEnd() throws IOException, TinkerPatchException {
    }

    private static interface ObjectDescriber<T> {
        public String describe(T var1);
    }

    private static interface EqualsChecker<T> {
        public boolean isEquals(T var1, T var2);
    }
}

