/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.aapt;

import com.tencent.tinker.commons.util.IOHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class JavaXmlUtil {
    private static DocumentBuilder getDocumentBuilder() {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource();
                }
            });
        }
        catch (Exception e) {
            throw new JavaXmlUtilException(e);
        }
        return documentBuilder;
    }

    public static Document getEmptyDocument() {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = JavaXmlUtil.getDocumentBuilder();
            document = documentBuilder.newDocument();
            document.normalize();
        }
        catch (Exception e) {
            throw new JavaXmlUtilException(e);
        }
        return document;
    }

    public static Document parse(String filename) {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = JavaXmlUtil.getDocumentBuilder();
            document = documentBuilder.parse(new File(filename));
            document.normalize();
        }
        catch (Exception e) {
            throw new JavaXmlUtilException(e);
        }
        return document;
    }

    public static Document parse(InputStream inputStream) {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = JavaXmlUtil.getDocumentBuilder();
            document = documentBuilder.parse(inputStream);
            document.normalize();
        }
        catch (Exception e) {
            throw new JavaXmlUtilException(e);
        }
        return document;
    }

    public static void saveDocument(Document document, String outputFullFilename) {
        FileOutputStream outputStream = null;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource domSource = new DOMSource(document);
            transformer.setOutputProperty("encoding", "UTF-8");
            outputStream = new FileOutputStream(outputFullFilename);
            StreamResult result = new StreamResult(outputStream);
            transformer.transform(domSource, result);
        }
        catch (Exception e) {
            try {
                throw new JavaXmlUtilException(e);
            }
            catch (Throwable throwable) {
                IOHelper.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOHelper.closeQuietly((Object)outputStream);
    }

    public static class JavaXmlUtilException
    extends RuntimeException {
        private static final long serialVersionUID = 4669527982017700891L;

        public JavaXmlUtilException(Throwable cause) {
            super(cause);
        }
    }
}

