/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.patch;

import com.tencent.tinker.build.builder.PatchBuilder;
import com.tencent.tinker.build.decoder.ApkDecoder;
import com.tencent.tinker.build.info.PatchInfo;
import com.tencent.tinker.build.patch.Configuration;
import com.tencent.tinker.build.patch.InputParam;
import com.tencent.tinker.build.util.Logger;
import com.tencent.tinker.build.util.TinkerPatchException;
import java.io.IOException;

public class Runner {
    public static final int ERRNO_ERRORS = 1;
    public static final int ERRNO_USAGE = 2;
    protected static long mBeginTime;
    protected Configuration config;

    public static void gradleRun(InputParam inputParam) {
        mBeginTime = System.currentTimeMillis();
        Runner m = new Runner();
        m.run(inputParam);
    }

    private void run(InputParam inputParam) {
        this.loadConfigFromGradle(inputParam);
        try {
            Logger.initLogger(this.config);
            this.tinkerPatch();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.goToError();
        }
        finally {
            Logger.closeLogger();
        }
    }

    protected void tinkerPatch() {
        Logger.d("-----------------------Tinker patch begin-----------------------");
        Logger.d(this.config.toString());
        try {
            ApkDecoder decoder = new ApkDecoder(this.config);
            decoder.onAllPatchesStart();
            decoder.patch(this.config.mOldApkFile, this.config.mNewApkFile);
            decoder.onAllPatchesEnd();
            PatchInfo info = new PatchInfo(this.config);
            info.gen();
            PatchBuilder builder = new PatchBuilder(this.config);
            builder.buildPatch();
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.goToError();
        }
        Logger.d("Tinker patch done, total time cost: %fs", this.diffTimeFromBegin());
        Logger.d("Tinker patch done, you can go to file to find the output %s", this.config.mOutFolder);
        Logger.d("-----------------------Tinker patch end-------------------------");
    }

    private void loadConfigFromGradle(InputParam inputParam) {
        try {
            this.config = new Configuration(inputParam);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TinkerPatchException e) {
            e.printStackTrace();
        }
    }

    public void goToError() {
        System.exit(2);
    }

    public double diffTimeFromBegin() {
        long end = System.currentTimeMillis();
        return (double)(end - mBeginTime) / 1000.0;
    }
}

