/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.decoder;

import com.tencent.tinker.build.patch.Configuration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

public abstract class BaseDecoder {
    protected final Configuration config;
    protected final File outDir;
    protected final File resultDir;

    public BaseDecoder(Configuration config) throws IOException {
        this.config = config;
        this.outDir = new File(config.mOutFolder);
        this.resultDir = config.mTempResultDir;
    }

    public Configuration getConfig() {
        return this.config;
    }

    protected void clean() {
    }

    public Path getRelativePath(File file) {
        return this.config.mTempUnzipNewDir.toPath().relativize(file.toPath());
    }

    public Path getOutputPath(File file) {
        return this.config.mTempResultDir.toPath().resolve(this.getRelativePath(file));
    }

    public String getRelativePathStringToOldFile(File oldFile) {
        return this.config.mTempUnzipOldDir.toPath().relativize(oldFile.toPath()).toString().replace("\\", "/");
    }

    public String getRelativePathStringToNewFile(File newFile) {
        return this.config.mTempUnzipNewDir.toPath().relativize(newFile.toPath()).toString().replace("\\", "/");
    }

    public String getParentRelativePathStringToNewFile(File newFile) {
        return this.config.mTempUnzipNewDir.toPath().relativize(newFile.getParentFile().toPath()).toString().replace("\\", "/");
    }

    public abstract boolean patch(File var1, File var2) throws Exception;

    public abstract void onAllPatchesStart() throws Exception;

    public abstract void onAllPatchesEnd() throws Exception;
}

