/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.lang.reflect.Constructor;

public class ShareTinkerLog {
    private static final String TAG = "Tinker.ShareTinkerLog";
    public static final int FN_LOG_PRINT_STACKTRACE = 4001;
    public static final int FN_LOG_PRINT_PENDING_LOGS = 4002;
    private static final Handler[] tinkerLogInlineFenceRef = new Handler[]{null};
    private static final TinkerLogImp debugLog = new TinkerLogImp(){

        @Override
        public void v(String tag, String format, Object ... params) {
            String log = params == null || params.length == 0 ? format : String.format(format, params);
            Log.v((String)tag, (String)log);
        }

        @Override
        public void i(String tag, String format, Object ... params) {
            String log = params == null || params.length == 0 ? format : String.format(format, params);
            Log.i((String)tag, (String)log);
        }

        @Override
        public void d(String tag, String format, Object ... params) {
            String log = params == null || params.length == 0 ? format : String.format(format, params);
            Log.d((String)tag, (String)log);
        }

        @Override
        public void w(String tag, String format, Object ... params) {
            String log = params == null || params.length == 0 ? format : String.format(format, params);
            Log.w((String)tag, (String)log);
        }

        @Override
        public void e(String tag, String format, Object ... params) {
            String log = params == null || params.length == 0 ? format : String.format(format, params);
            Log.e((String)tag, (String)log);
        }

        @Override
        public void printErrStackTrace(String tag, Throwable tr, String format, Object ... params) {
            String log;
            String string = log = params == null || params.length == 0 ? format : String.format(format, params);
            if (log == null) {
                log = "";
            }
            log = log + "  " + Log.getStackTraceString((Throwable)tr);
            Log.e((String)tag, (String)log);
        }
    };
    private static final TinkerLogImp[] tinkerLogImpRef = new TinkerLogImp[]{debugLog};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Handler getInlineFence() {
        Handler[] handlerArray = tinkerLogInlineFenceRef;
        synchronized (tinkerLogInlineFenceRef) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return tinkerLogInlineFenceRef[0];
        }
    }

    public static TinkerLogImp getDefaultImpl() {
        return debugLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTinkerLogImp(TinkerLogImp imp) {
        TinkerLogImp[] tinkerLogImpArray = tinkerLogImpRef;
        synchronized (tinkerLogImpRef) {
            ShareTinkerLog.tinkerLogImpRef[0] = imp;
            if (imp != null && imp != debugLog) {
                ShareTinkerLog.printPendingLogs();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TinkerLogImp getImpl() {
        TinkerLogImp[] tinkerLogImpArray = tinkerLogImpRef;
        synchronized (tinkerLogImpRef) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return tinkerLogImpRef[0];
        }
    }

    public static void v(String tag, String fmt, Object ... values) {
        ShareTinkerLog.printLog(2, tag, fmt, values);
    }

    public static void d(String tag, String fmt, Object ... values) {
        ShareTinkerLog.printLog(3, tag, fmt, values);
    }

    public static void i(String tag, String fmt, Object ... values) {
        ShareTinkerLog.printLog(4, tag, fmt, values);
    }

    public static void w(String tag, String fmt, Object ... values) {
        ShareTinkerLog.printLog(5, tag, fmt, values);
    }

    public static void e(String tag, String fmt, Object ... values) {
        ShareTinkerLog.printLog(6, tag, fmt, values);
    }

    public static void printErrStackTrace(String tag, Throwable thr, String format, Object ... values) {
        ShareTinkerLog.printLog(tag, thr, format, values);
    }

    public static void printPendingLogs() {
        Handler inlineFence = ShareTinkerLog.getInlineFence();
        if (inlineFence != null) {
            Message msg = Message.obtain((Handler)inlineFence, (int)4002);
            inlineFence.handleMessage(msg);
            msg.recycle();
        }
    }

    private static void printLog(int priority, String tag, String fmt, Object ... values) {
        long timestamp = System.currentTimeMillis();
        Object[] args = new Object[]{priority, timestamp, tag, fmt, values};
        Handler inlineFence = ShareTinkerLog.getInlineFence();
        if (inlineFence != null) {
            Message msg = Message.obtain((Handler)inlineFence, (int)priority, (Object)args);
            inlineFence.handleMessage(msg);
            msg.recycle();
        } else {
            debugLog.e(tag, "!! NO_LOG_IMPL !! Original Log: " + fmt, values);
        }
    }

    private static void printLog(String tag, Throwable thr, String fmt, Object ... values) {
        long timestamp = System.currentTimeMillis();
        Object[] args = new Object[]{4001, timestamp, tag, thr, fmt, values};
        Handler inlineFence = ShareTinkerLog.getInlineFence();
        if (inlineFence != null) {
            Message msg = Message.obtain((Handler)inlineFence, (int)4001, (Object)args);
            inlineFence.handleMessage(msg);
            msg.recycle();
        } else {
            debugLog.printErrStackTrace(tag, thr, "!! NO_LOG_IMPL !! Original Log: " + fmt, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Handler[] handlerArray = tinkerLogInlineFenceRef;
        synchronized (tinkerLogInlineFenceRef) {
            try {
                Class<?> clazz = Class.forName("com.tencent.tinker.loader.shareutil.TinkerLogInlineFence");
                Constructor<?> ctor = clazz.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                ShareTinkerLog.tinkerLogInlineFenceRef[0] = (Handler)ctor.newInstance(new Object[0]);
            }
            catch (Throwable thr) {
                Log.e((String)TAG, (String)"[-] Fail to create inline fence instance.", (Throwable)thr);
                ShareTinkerLog.tinkerLogInlineFenceRef[0] = null;
            }
            return;
        }
    }

    public static interface TinkerLogImp {
        public void v(String var1, String var2, Object ... var3);

        public void d(String var1, String var2, Object ... var3);

        public void i(String var1, String var2, Object ... var3);

        public void w(String var1, String var2, Object ... var3);

        public void e(String var1, String var2, Object ... var3);

        public void printErrStackTrace(String var1, Throwable var2, String var3, Object ... var4);
    }
}

