/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.hotplug.interceptor;

import android.app.Activity;
import android.app.Application;
import android.app.Instrumentation;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.PersistableBundle;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.hotplug.IncrementComponentManager;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerLog;
import java.lang.reflect.Field;

public class TinkerHackInstrumentation
extends Instrumentation {
    private static final String TAG = "Tinker.Instrumentation";
    private final Instrumentation mOriginal;
    private final Object mActivityThread;
    private final Field mInstrumentationField;

    public static TinkerHackInstrumentation create(Context context) {
        try {
            Object activityThread = ShareReflectUtil.getActivityThread(context, null);
            Field mInstrumentationField = ShareReflectUtil.findField(activityThread, "mInstrumentation");
            Instrumentation original = (Instrumentation)mInstrumentationField.get(activityThread);
            if (original instanceof TinkerHackInstrumentation) {
                return (TinkerHackInstrumentation)original;
            }
            return new TinkerHackInstrumentation(original, activityThread, mInstrumentationField);
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException("see next stacktrace", thr);
        }
    }

    public void install() throws IllegalAccessException {
        if (this.mInstrumentationField.get(this.mActivityThread) instanceof TinkerHackInstrumentation) {
            ShareTinkerLog.w(TAG, "already installed, skip rest logic.", new Object[0]);
        } else {
            this.mInstrumentationField.set(this.mActivityThread, (Object)this);
        }
    }

    public void uninstall() throws IllegalAccessException {
        this.mInstrumentationField.set(this.mActivityThread, this.mOriginal);
    }

    private TinkerHackInstrumentation(Instrumentation original, Object activityThread, Field instrumentationField) throws TinkerRuntimeException {
        this.mOriginal = original;
        this.mActivityThread = activityThread;
        this.mInstrumentationField = instrumentationField;
        try {
            this.copyAllFields(original);
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException(thr.getMessage(), thr);
        }
    }

    public Activity newActivity(Class<?> clazz, Context context, IBinder token, Application application, Intent intent, ActivityInfo info, CharSequence title, Activity parent, String id, Object lastNonConfigurationInstance) throws InstantiationException, IllegalAccessException {
        this.processIntent(context.getClassLoader(), intent);
        return super.newActivity(clazz, context, token, application, intent, info, title, parent, id, lastNonConfigurationInstance);
    }

    public Activity newActivity(ClassLoader cl, String className, Intent intent) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this.processIntent(cl, intent)) {
            return super.newActivity(cl, intent.getComponent().getClassName(), intent);
        }
        return super.newActivity(cl, className, intent);
    }

    public void callActivityOnCreate(Activity activity, Bundle icicle) {
        ActivityInfo targetAInfo;
        if (activity != null && (targetAInfo = IncrementComponentManager.queryActivityInfo(activity.getClass().getName())) != null) {
            this.fixActivityParams(activity, targetAInfo);
        }
        super.callActivityOnCreate(activity, icicle);
    }

    public void callActivityOnCreate(Activity activity, Bundle icicle, PersistableBundle persistentState) {
        ActivityInfo targetAInfo;
        if (activity != null && (targetAInfo = IncrementComponentManager.queryActivityInfo(activity.getClass().getName())) != null) {
            this.fixActivityParams(activity, targetAInfo);
        }
        super.callActivityOnCreate(activity, icicle, persistentState);
    }

    public void callActivityOnNewIntent(Activity activity, Intent intent) {
        if (activity != null) {
            this.processIntent(activity.getClass().getClassLoader(), intent);
        }
        super.callActivityOnNewIntent(activity, intent);
    }

    private boolean processIntent(ClassLoader cl, Intent intent) {
        if (intent == null) {
            return false;
        }
        ShareIntentUtil.fixIntentClassLoader(intent, cl);
        ComponentName oldComponent = (ComponentName)intent.getParcelableExtra("tinker_iek_old_component");
        if (oldComponent == null) {
            ShareTinkerLog.w(TAG, "oldComponent was null, start " + intent.getComponent() + " next.", new Object[0]);
            return false;
        }
        String oldComponentName = oldComponent.getClassName();
        ActivityInfo targetAInfo = IncrementComponentManager.queryActivityInfo(oldComponentName);
        if (targetAInfo == null) {
            ShareTinkerLog.e(TAG, "Failed to query target activity's info, perhaps the target is not hotpluged component. Target: " + oldComponentName, new Object[0]);
            return false;
        }
        intent.setComponent(oldComponent);
        intent.removeExtra("tinker_iek_old_component");
        return true;
    }

    private void fixActivityParams(Activity target, ActivityInfo targetAInfo) {
        target.setRequestedOrientation(targetAInfo.screenOrientation);
        target.setTheme(targetAInfo.theme);
        try {
            Field aInfoField = ShareReflectUtil.findField(target, "mActivityInfo");
            aInfoField.set(target, targetAInfo);
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException("see next stacktrace.", thr);
        }
    }

    private void copyAllFields(Instrumentation src) throws IllegalAccessException {
        Field[] fields = Instrumentation.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            fields[i].setAccessible(true);
            Object value = fields[i].get(src);
            fields[i].set((Object)this, value);
        }
    }
}

