/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.hotplug;

import com.tencent.tinker.loader.hotplug.ActivityStubs;
import java.util.HashMap;
import java.util.Map;

public class ActivityStubManager {
    private static final String TAG = "Tinker.ActivityStubManager";
    private static Map<String, String> sTargetToStubClassNameMap = new HashMap<String, String>();
    private static final int[] STANDARD_STUB_COUNT_SLOTS = new int[]{10, 3};
    private static final int[] SINGLETOP_STUB_COUNT_SLOTS = new int[]{10, 3};
    private static final int[] SINGLETASK_STUB_COUNT_SLOTS = new int[]{10, 3};
    private static final int[] SINGLEINSTANCE_STUB_COUNT_SLOTS = new int[]{10, 3};
    private static final int[] NEXT_STANDARD_STUB_IDX_SLOTS = new int[]{0, 0};
    private static final int[] NEXT_SINGLETOP_STUB_IDX_SLOTS = new int[]{0, 0};
    private static final int[] NEXT_SINGLETASK_STUB_IDX_SLOTS = new int[]{0, 0};
    private static final int[] NEXT_SINGLEINSTANCE_STUB_IDX_SLOTS = new int[]{0, 0};
    private static final int NOTRANSPARENT_SLOT_INDEX = 0;
    private static final int TRANSPARENT_SLOT_INDEX = 1;

    public static String assignStub(String targetClassName, int launchMode, boolean isTransparent) {
        int slotIdx;
        int[] countSlots;
        int[] nextStubIdxSlots;
        String stubNameFormat;
        String stubClassName = sTargetToStubClassNameMap.get(targetClassName);
        if (stubClassName != null) {
            return stubClassName;
        }
        switch (launchMode) {
            case 1: {
                stubNameFormat = ActivityStubs.SINGLETOP_STUB_CLASSNAME_FORMAT;
                nextStubIdxSlots = NEXT_SINGLETOP_STUB_IDX_SLOTS;
                countSlots = SINGLETOP_STUB_COUNT_SLOTS;
                break;
            }
            case 2: {
                stubNameFormat = ActivityStubs.SINGLETASK_STUB_CLASSNAME_FORMAT;
                nextStubIdxSlots = NEXT_SINGLETASK_STUB_IDX_SLOTS;
                countSlots = SINGLETASK_STUB_COUNT_SLOTS;
                break;
            }
            case 3: {
                stubNameFormat = ActivityStubs.SINGLEINSTANCE_STUB_CLASSNAME_FORMAT;
                nextStubIdxSlots = NEXT_SINGLEINSTANCE_STUB_IDX_SLOTS;
                countSlots = SINGLEINSTANCE_STUB_COUNT_SLOTS;
                break;
            }
            default: {
                stubNameFormat = ActivityStubs.STARDARD_STUB_CLASSNAME_FORMAT;
                nextStubIdxSlots = NEXT_STANDARD_STUB_IDX_SLOTS;
                countSlots = STANDARD_STUB_COUNT_SLOTS;
            }
        }
        if (isTransparent) {
            stubNameFormat = stubNameFormat + "_T";
            slotIdx = 1;
        } else {
            slotIdx = 0;
        }
        int n = slotIdx;
        int n2 = nextStubIdxSlots[n];
        nextStubIdxSlots[n] = n2 + 1;
        int stubIndex = n2;
        if (stubIndex >= countSlots[slotIdx]) {
            nextStubIdxSlots[slotIdx] = 0;
            stubIndex = 0;
        }
        stubClassName = String.format(stubNameFormat, stubIndex);
        sTargetToStubClassNameMap.put(targetClassName, stubClassName);
        return stubClassName;
    }

    private ActivityStubManager() {
        throw new UnsupportedOperationException();
    }
}

