/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.annotation.SuppressLint;
import com.tencent.tinker.anno.Keep;
import com.tencent.tinker.loader.SystemClassLoaderAdder;
import com.tencent.tinker.loader.TinkerRuntimeException;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;

@Keep
@SuppressLint(value={"NewApi"})
public final class TinkerClassLoader
extends PathClassLoader {
    private final ClassLoader mOriginAppClassLoader;

    TinkerClassLoader(String dexPath, File optimizedDir, String libraryPath, ClassLoader originAppClassLoader) {
        super("", libraryPath, ClassLoader.getSystemClassLoader());
        this.mOriginAppClassLoader = originAppClassLoader;
        TinkerClassLoader.injectDexPath((ClassLoader)((Object)this), dexPath, optimizedDir);
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = super.findClass(name);
        }
        catch (ClassNotFoundException ignored) {
            cl = null;
        }
        if (cl != null) {
            return cl;
        }
        return this.mOriginAppClassLoader.loadClass(name);
    }

    public URL getResource(String name) {
        URL resource = Object.class.getClassLoader().getResource(name);
        if (resource != null) {
            return resource;
        }
        resource = this.findResource(name);
        if (resource != null) {
            return resource;
        }
        return this.mOriginAppClassLoader.getResource(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] resources = new Enumeration[]{Object.class.getClassLoader().getResources(name), this.findResources(name), this.mOriginAppClassLoader.getResources(name)};
        return new CompoundEnumeration<URL>(resources);
    }

    private static void injectDexPath(ClassLoader cl, String dexPath, File optimizedDir) {
        try {
            ArrayList<File> dexFiles = new ArrayList<File>(16);
            for (String oneDexPath : dexPath.split(":")) {
                if (oneDexPath.isEmpty()) continue;
                dexFiles.add(new File(oneDexPath));
            }
            if (!dexFiles.isEmpty()) {
                SystemClassLoaderAdder.injectDexesInternal(cl, dexFiles, optimizedDir);
            }
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException("Fail to create TinkerClassLoader.", thr);
        }
    }

    @Keep
    class CompoundEnumeration<E>
    implements Enumeration<E> {
        private Enumeration<E>[] enums;
        private int index = 0;

        public CompoundEnumeration(Enumeration<E>[] enums) {
            this.enums = enums;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.index < this.enums.length) {
                if (this.enums[this.index] != null && this.enums[this.index].hasMoreElements()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public E nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.enums[this.index].nextElement();
        }
    }
}

