/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import com.tencent.tinker.loader.TinkerClassLoader;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import dalvik.system.DelegateLastClassLoader;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;

final class NewClassLoaderInjector {
    public static ClassLoader inject(Application app, ClassLoader oldClassLoader, File dexOptDir, boolean useDLC, List<File> patchedDexes) throws Throwable {
        String[] patchedDexPaths = new String[patchedDexes.size()];
        for (int i = 0; i < patchedDexPaths.length; ++i) {
            patchedDexPaths[i] = patchedDexes.get(i).getAbsolutePath();
        }
        ClassLoader newClassLoader = NewClassLoaderInjector.createNewClassLoader(oldClassLoader, dexOptDir, useDLC, true, patchedDexPaths);
        NewClassLoaderInjector.doInject(app, newClassLoader);
        return newClassLoader;
    }

    public static ClassLoader triggerDex2Oat(Context context, File dexOptDir, boolean useDLC, String ... dexPaths) throws Throwable {
        return NewClassLoaderInjector.createNewClassLoader(context.getClassLoader(), dexOptDir, useDLC, false, dexPaths);
    }

    @SuppressLint(value={"NewApi"})
    private static ClassLoader createNewClassLoader(ClassLoader oldClassLoader, File dexOptDir, boolean useDLC, boolean forActualLoading, String ... patchDexPaths) throws Throwable {
        boolean hasPatchDexPaths;
        Field pathListField = NewClassLoaderInjector.findField(Class.forName("dalvik.system.BaseDexClassLoader", false, oldClassLoader), "pathList");
        Object oldPathList = pathListField.get(oldClassLoader);
        StringBuilder dexPathBuilder = new StringBuilder();
        boolean bl = hasPatchDexPaths = patchDexPaths != null && patchDexPaths.length > 0;
        if (hasPatchDexPaths) {
            for (int i = 0; i < patchDexPaths.length; ++i) {
                if (i > 0) {
                    dexPathBuilder.append(File.pathSeparator);
                }
                dexPathBuilder.append(patchDexPaths[i]);
            }
        }
        String combinedDexPath = dexPathBuilder.toString();
        Field nativeLibraryDirectoriesField = NewClassLoaderInjector.findField(oldPathList.getClass(), "nativeLibraryDirectories");
        List<File> oldNativeLibraryDirectories = null;
        oldNativeLibraryDirectories = nativeLibraryDirectoriesField.getType().isArray() ? Arrays.asList((File[])nativeLibraryDirectoriesField.get(oldPathList)) : (List<File>)nativeLibraryDirectoriesField.get(oldPathList);
        StringBuilder libraryPathBuilder = new StringBuilder();
        boolean isFirstItem = true;
        for (File libDir : oldNativeLibraryDirectories) {
            if (libDir == null) continue;
            if (isFirstItem) {
                isFirstItem = false;
            } else {
                libraryPathBuilder.append(File.pathSeparator);
            }
            libraryPathBuilder.append(libDir.getAbsolutePath());
        }
        String combinedLibraryPath = libraryPathBuilder.toString();
        TinkerClassLoader result = null;
        if (useDLC && ShareTinkerInternals.isNewerOrEqualThanVersion(27, true)) {
            if (ShareTinkerInternals.isNewerOrEqualThanVersion(31, true)) {
                result = new DelegateLastClassLoader(combinedDexPath, combinedLibraryPath, oldClassLoader);
            } else {
                result = new DelegateLastClassLoader(combinedDexPath, combinedLibraryPath, ClassLoader.getSystemClassLoader());
                Field parentField = ClassLoader.class.getDeclaredField("parent");
                parentField.setAccessible(true);
                parentField.set((Object)result, oldClassLoader);
            }
        } else {
            result = new TinkerClassLoader(combinedDexPath, dexOptDir, combinedLibraryPath, oldClassLoader);
        }
        if (forActualLoading && !ShareTinkerInternals.isNewerOrEqualThanVersion(26, true)) {
            NewClassLoaderInjector.findField(oldPathList.getClass(), "definingContext").set(oldPathList, (Object)result);
        }
        return result;
    }

    private static void doInject(Application app, ClassLoader classLoader) throws Throwable {
        Thread.currentThread().setContextClassLoader(classLoader);
        Context baseContext = (Context)NewClassLoaderInjector.findField(app.getClass(), "mBase").get(app);
        try {
            NewClassLoaderInjector.findField(baseContext.getClass(), "mClassLoader").set(baseContext, classLoader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Object basePackageInfo = NewClassLoaderInjector.findField(baseContext.getClass(), "mPackageInfo").get(baseContext);
        NewClassLoaderInjector.findField(basePackageInfo.getClass(), "mClassLoader").set(basePackageInfo, classLoader);
        if (Build.VERSION.SDK_INT < 27) {
            Resources res = app.getResources();
            try {
                NewClassLoaderInjector.findField(res.getClass(), "mClassLoader").set(res, classLoader);
                Object drawableInflater = NewClassLoaderInjector.findField(res.getClass(), "mDrawableInflater").get(res);
                if (drawableInflater != null) {
                    NewClassLoaderInjector.findField(drawableInflater.getClass(), "mClassLoader").set(drawableInflater, classLoader);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static Field findField(Class<?> clazz, String name) throws Throwable {
        Class<?> currClazz = clazz;
        while (true) {
            try {
                Field result = currClazz.getDeclaredField(name);
                result.setAccessible(true);
                return result;
            }
            catch (Throwable ignored) {
                if (currClazz == Object.class) {
                    throw new NoSuchFieldException("Cannot find field " + name + " in class " + clazz.getName() + " and its super classes.");
                }
                currClazz = currClazz.getSuperclass();
                continue;
            }
            break;
        }
    }

    private NewClassLoaderInjector() {
        throw new UnsupportedOperationException();
    }
}

