/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.service;

import android.os.Process;
import com.tencent.tinker.lib.service.AbstractResultService;
import com.tencent.tinker.lib.service.PatchResult;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.tinker.TinkerLoadResult;
import com.tencent.tinker.lib.util.TinkerServiceInternals;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerLog;
import java.io.File;

public class DefaultTinkerResultService
extends AbstractResultService {
    private static final String TAG = "Tinker.DefaultTinkerResultService";

    @Override
    public void onPatchResult(PatchResult result) {
        if (result == null) {
            ShareTinkerLog.e((String)TAG, (String)"DefaultTinkerResultService received null result!!!!", (Object[])new Object[0]);
            return;
        }
        ShareTinkerLog.i((String)TAG, (String)"DefaultTinkerResultService received a result:%s ", (Object[])new Object[]{result.toString()});
        TinkerServiceInternals.killTinkerPatchServiceProcess(this.getApplicationContext());
        if (result.isSuccess) {
            this.deleteRawPatchFile(new File(result.rawPatchFilePath));
            if (this.checkIfNeedKill(result)) {
                Process.killProcess((int)Process.myPid());
            } else {
                ShareTinkerLog.i((String)TAG, (String)"I have already install the newly patch version!", (Object[])new Object[0]);
            }
        }
    }

    public void deleteRawPatchFile(File rawFile) {
        if (!SharePatchFileUtil.isLegalFile((File)rawFile)) {
            return;
        }
        ShareTinkerLog.w((String)TAG, (String)"deleteRawPatchFile rawFile path: %s", (Object[])new Object[]{rawFile.getPath()});
        String fileName = rawFile.getName();
        if (!fileName.startsWith("patch-") || !fileName.endsWith(".apk")) {
            SharePatchFileUtil.safeDeleteFile((File)rawFile);
            return;
        }
        File parentFile = rawFile.getParentFile();
        if (!parentFile.getName().startsWith("patch-")) {
            SharePatchFileUtil.safeDeleteFile((File)rawFile);
        } else {
            File grandFile = parentFile.getParentFile();
            if (!grandFile.getName().equals("tinker") && !grandFile.getName().equals("wc_tinker_dir")) {
                SharePatchFileUtil.safeDeleteFile((File)rawFile);
            }
        }
    }

    public boolean checkIfNeedKill(PatchResult result) {
        TinkerLoadResult tinkerLoadResult;
        Tinker tinker = Tinker.with(this.getApplicationContext());
        if (tinker.isTinkerLoaded() && (tinkerLoadResult = tinker.getTinkerLoadResultIfPresent()) != null) {
            String currentVersion = tinkerLoadResult.currentVersion;
            if (result.patchVersion != null && result.patchVersion.equals(currentVersion)) {
                return false;
            }
        }
        return true;
    }
}

