/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelmsg;

import android.os.Bundle;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.modelmsg.WXFileObject;
import com.tencent.mm.opensdk.modelmsg.WXMediaMessage;
import com.tencent.mm.opensdk.utils.Log;

public class SendMessageToWX {
    private SendMessageToWX() {
    }

    public static class Resp
    extends BaseResp {
        public Resp() {
        }

        public Resp(Bundle bundle) {
            Resp resp = this;
            resp.fromBundle(bundle);
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public void fromBundle(Bundle bundle) {
            super.fromBundle(bundle);
        }

        @Override
        public void toBundle(Bundle bundle) {
            super.toBundle(bundle);
        }

        @Override
        public boolean checkArgs() {
            return true;
        }
    }

    public static class Req
    extends BaseReq {
        public static final int WXSceneSession = 0;
        public static final int WXSceneTimeline = 1;
        public static final int WXSceneFavorite = 2;
        public static final int WXSceneSpecifiedContact = 3;
        private static final String TAG = "MicroMsg.SDK.SendMessageToWX.Req";
        private static final int FAV_CONTENT_LENGTH_LIMIT = 0x1900000;
        public WXMediaMessage message;
        public int scene;
        public String userOpenId;

        public Req() {
        }

        public Req(Bundle bundle) {
            Req req = this;
            req.fromBundle(bundle);
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public void fromBundle(Bundle bundle) {
            super.fromBundle(bundle);
            this.message = WXMediaMessage.Builder.fromBundle(bundle);
            this.scene = bundle.getInt("_wxapi_sendmessagetowx_req_scene");
            this.userOpenId = bundle.getString("_wxapi_sendmessagetowx_req_use_open_id");
        }

        @Override
        public void toBundle(Bundle bundle) {
            Req req = this;
            super.toBundle(bundle);
            bundle.putAll(WXMediaMessage.Builder.toBundle(req.message));
            bundle.putInt("_wxapi_sendmessagetowx_req_scene", this.scene);
            bundle.putInt("_wxapi_sendmessagetowx_req_media_type", this.message.getType());
            bundle.putString("_wxapi_sendmessagetowx_req_use_open_id", this.userOpenId);
        }

        @Override
        public boolean checkArgs() {
            WXMediaMessage wXMediaMessage = this.message;
            if (wXMediaMessage == null) {
                Log.e(TAG, "checkArgs fail ,message is null");
                return false;
            }
            if (wXMediaMessage.mediaObject.type() == 6 && this.scene == 2) {
                ((WXFileObject)this.message.mediaObject).setContentLengthLimit(0x1900000);
            }
            if (this.scene == 3 && this.userOpenId == null) {
                Log.e(TAG, "Send specifiedContact userOpenId can not be null.");
                return false;
            }
            if (this.scene == 3 && this.openId == null) {
                Log.e(TAG, "Send specifiedContact openid can not be null.");
                return false;
            }
            return this.message.checkArgs();
        }
    }
}

