/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace.item;

import com.tencent.matrix.javalib.util.Util;
import com.tencent.matrix.trace.retrace.MappingCollector;
import com.tencent.matrix.trace.retrace.MethodInfo;
import org.objectweb.asm.Type;

public class TraceMethod {
    private static final String TAG = "Matrix.TraceMethod";
    public int id;
    public int accessFlag;
    public String className;
    public String methodName;
    public String desc;

    public static TraceMethod create(int id, int accessFlag, String className, String methodName, String desc) {
        TraceMethod traceMethod = new TraceMethod();
        traceMethod.id = id;
        traceMethod.accessFlag = accessFlag;
        traceMethod.className = className.replace("/", ".");
        traceMethod.methodName = methodName;
        traceMethod.desc = desc.replace("/", ".");
        return traceMethod;
    }

    public String getMethodName() {
        if (this.desc == null || this.isNativeMethod()) {
            return this.className + "." + this.methodName;
        }
        return this.className + "." + this.methodName + "." + this.desc;
    }

    public void revert(MappingCollector processor) {
        if (null == processor) {
            return;
        }
        MethodInfo methodInfo = processor.originalMethodInfo(this.className, this.methodName, this.desc);
        this.methodName = methodInfo.originalName;
        this.desc = methodInfo.desc;
        this.className = processor.originalClassName(this.className, this.className);
    }

    public void proguard(MappingCollector processor) {
        if (null == processor) {
            return;
        }
        MethodInfo methodInfo = processor.obfuscatedMethodInfo(this.className, this.methodName, this.desc);
        this.methodName = methodInfo.originalName;
        this.desc = methodInfo.desc;
        this.className = processor.proguardClassName(this.className, this.className);
    }

    public String getReturn() {
        if (Util.isNullOrNil((String)this.desc)) {
            return null;
        }
        return Type.getReturnType((String)this.desc).toString();
    }

    public String toString() {
        if (this.desc == null || this.isNativeMethod()) {
            return this.id + "," + this.accessFlag + "," + this.className + " " + this.methodName;
        }
        return this.id + "," + this.accessFlag + "," + this.className + " " + this.methodName + " " + this.desc;
    }

    public String toIgnoreString() {
        if (this.desc == null || this.isNativeMethod()) {
            return this.className + " " + this.methodName;
        }
        return this.className + " " + this.methodName + " " + this.desc;
    }

    public boolean isNativeMethod() {
        return (this.accessFlag & 0x100) != 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TraceMethod) {
            TraceMethod tm = (TraceMethod)obj;
            return tm.getMethodName().equals(this.getMethodName());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

