/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

class TraceClassWriter
extends ClassWriter {
    private ClassLoader mClassLoader;

    TraceClassWriter(int flags, ClassLoader classLoader) {
        super(flags);
        this.mClassLoader = classLoader;
    }

    TraceClassWriter(ClassReader classReader, int flags, ClassLoader classLoader) {
        super(classReader, flags);
        this.mClassLoader = classLoader;
    }

    protected String getCommonSuperClass(String type1, String type2) {
        try {
            return super.getCommonSuperClass(type1, type2);
        }
        catch (Exception e) {
            try {
                return this.getCommonSuperClassV1(type1, type2);
            }
            catch (Exception e1) {
                try {
                    return this.getCommonSuperClassV2(type1, type2);
                }
                catch (Exception e2) {
                    return this.getCommonSuperClassV3(type1, type2);
                }
            }
        }
    }

    private String getCommonSuperClassV1(String type1, String type2) {
        Class<?> clazz2;
        Class<?> clazz1;
        ClassLoader curClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        try {
            clazz1 = Class.forName(type1.replace('/', '.'), false, this.mClassLoader);
            clazz2 = Class.forName(type2.replace('/', '.'), false, this.mClassLoader);
        }
        catch (Exception e) {
            return "java/lang/Object";
        }
        catch (LinkageError error) {
            return "java/lang/Object";
        }
        if (clazz1.isAssignableFrom(clazz2)) {
            return type1;
        }
        if (clazz2.isAssignableFrom(clazz1)) {
            return type2;
        }
        if (clazz1.isInterface() || clazz2.isInterface()) {
            return "java/lang/Object";
        }
        while (!(clazz1 = clazz1.getSuperclass()).isAssignableFrom(clazz2)) {
        }
        return clazz1.getName().replace('.', '/');
    }

    private String getCommonSuperClassV2(String type1, String type2) {
        Class<?> clazz2;
        Class<?> clazz1;
        ClassLoader curClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        try {
            clazz1 = Class.forName(type1.replace('/', '.'), false, curClassLoader);
            clazz2 = Class.forName(type2.replace('/', '.'), false, this.mClassLoader);
        }
        catch (Exception e) {
            return "java/lang/Object";
        }
        catch (LinkageError error) {
            return "java/lang/Object";
        }
        if (clazz1.isAssignableFrom(clazz2)) {
            return type1;
        }
        if (clazz2.isAssignableFrom(clazz1)) {
            return type2;
        }
        if (clazz1.isInterface() || clazz2.isInterface()) {
            return "java/lang/Object";
        }
        while (!(clazz1 = clazz1.getSuperclass()).isAssignableFrom(clazz2)) {
        }
        return clazz1.getName().replace('.', '/');
    }

    private String getCommonSuperClassV3(String type1, String type2) {
        Class<?> clazz2;
        Class<?> clazz1;
        ClassLoader curClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        try {
            clazz1 = Class.forName(type1.replace('/', '.'), false, this.mClassLoader);
            clazz2 = Class.forName(type2.replace('/', '.'), false, curClassLoader);
        }
        catch (Exception e) {
            return "java/lang/Object";
        }
        catch (LinkageError error) {
            return "java/lang/Object";
        }
        if (clazz1.isAssignableFrom(clazz2)) {
            return type1;
        }
        if (clazz2.isAssignableFrom(clazz1)) {
            return type2;
        }
        if (clazz1.isInterface() || clazz2.isInterface()) {
            return "java/lang/Object";
        }
        while (!(clazz1 = clazz1.getSuperclass()).isAssignableFrom(clazz2)) {
        }
        return clazz1.getName().replace('.', '/');
    }
}

