/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.plugin.transform;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.google.common.base.Joiner;
import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.javalib.util.ReflectUtil;
import com.tencent.matrix.javalib.util.Util;
import com.tencent.matrix.plugin.trace.MatrixTrace;
import com.tencent.matrix.trace.Configuration;
import com.tencent.matrix.trace.extension.MatrixTraceExtension;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0001#B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J$\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aH\u0002J\u0018\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001bH\u0002J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/tencent/matrix/plugin/transform/MatrixTraceLegacyTransform;", "Lcom/android/build/api/transform/Transform;", "project", "Lorg/gradle/api/Project;", "config", "Lcom/tencent/matrix/trace/Configuration;", "origTransform", "(Lorg/gradle/api/Project;Lcom/tencent/matrix/trace/Configuration;Lcom/android/build/api/transform/Transform;)V", "doTransform", "", "invocation", "Lcom/android/build/api/transform/TransformInvocation;", "getInputTypes", "", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getName", "", "getScopes", "", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "isIncremental", "", "replaceChangedFile", "dirInput", "Lcom/android/build/api/transform/DirectoryInput;", "changedFiles", "", "Ljava/io/File;", "Lcom/android/build/api/transform/Status;", "replaceFile", "input", "Lcom/android/build/api/transform/QualifiedContent;", "newFile", "transform", "transformInvocation", "Companion", "matrix-gradle-plugin"})
public final class MatrixTraceLegacyTransform
extends Transform {
    private final Project project;
    private final Configuration config;
    private final Transform origTransform;
    @NotNull
    public static final String TAG = "Matrix.TraceLegacyTransform";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getName() {
        return TAG;
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        Set set = TransformManager.CONTENT_CLASS;
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"TransformManager.CONTENT_CLASS");
        return set;
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getScopes() {
        Set set = TransformManager.SCOPE_FULL_PROJECT;
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"TransformManager.SCOPE_FULL_PROJECT");
        return set;
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(@NotNull TransformInvocation transformInvocation) {
        Intrinsics.checkNotNullParameter((Object)transformInvocation, (String)"transformInvocation");
        super.transform(transformInvocation);
        long start = System.currentTimeMillis();
        try {
            this.doTransform(transformInvocation);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        long cost = System.currentTimeMillis() - start;
        long begin = System.currentTimeMillis();
        this.origTransform.transform(transformInvocation);
        long origTransformCost = System.currentTimeMillis() - begin;
        Log.i((String)("Matrix." + this.getName()), (String)"[transform] cost time: %dms %s:%sms MatrixTraceTransform:%sms", (Object[])new Object[]{System.currentTimeMillis() - start, this.origTransform.getClass().getSimpleName(), origTransformCost, cost});
    }

    private final void doTransform(TransformInvocation invocation) {
        Function2 function2;
        long start = System.currentTimeMillis();
        boolean isIncremental = invocation.isIncremental() && this.isIncremental();
        ConcurrentHashMap changedFiles = new ConcurrentHashMap();
        ArrayList<File> inputFiles = new ArrayList<File>();
        ConcurrentHashMap fileToInput = new ConcurrentHashMap();
        Iterator iterator = invocation.getInputs().iterator();
        while (iterator.hasNext()) {
            TransformInput input;
            TransformInput transformInput = input = (TransformInput)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)transformInput, (String)"input");
            function2 = transformInput.getDirectoryInputs().iterator();
            while (function2.hasNext()) {
                DirectoryInput directoryInput;
                DirectoryInput directoryInput2 = directoryInput = (DirectoryInput)function2.next();
                Intrinsics.checkNotNullExpressionValue((Object)directoryInput2, (String)"directoryInput");
                changedFiles.putAll(directoryInput2.getChangedFiles());
                inputFiles.add(directoryInput.getFile());
                Map map = fileToInput;
                File file = directoryInput.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"directoryInput.file");
                map.put(file, directoryInput);
            }
            for (JarInput jarInput : input.getJarInputs()) {
                Map map = changedFiles;
                JarInput jarInput2 = jarInput;
                Intrinsics.checkNotNullExpressionValue((Object)jarInput2, (String)"jarInput");
                File file = jarInput2.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"jarInput.file");
                Status status = jarInput.getStatus();
                Intrinsics.checkNotNullExpressionValue((Object)status, (String)"jarInput.status");
                map.put(file, status);
                inputFiles.add(jarInput.getFile());
                Map map2 = fileToInput;
                File file2 = jarInput.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"jarInput.file");
                map2.put(file2, jarInput);
            }
        }
        if (inputFiles.size() == 0) {
            Log.i((String)TAG, (String)"Matrix trace do not find any input files", (Object[])new Object[0]);
            return;
        }
        Function2 legacyReplaceChangedFile2 = (Function2)new Function2<File, Map<File, ? extends Status>, Object>(this, fileToInput){
            final /* synthetic */ MatrixTraceLegacyTransform this$0;
            final /* synthetic */ ConcurrentHashMap $fileToInput;

            @NotNull
            public final Object invoke(@NotNull File inputDir, @NotNull Map<File, ? extends Status> map) {
                Intrinsics.checkNotNullParameter((Object)inputDir, (String)"inputDir");
                Intrinsics.checkNotNullParameter(map, (String)"map");
                V v = this.$fileToInput.get(inputDir);
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.android.build.api.transform.DirectoryInput");
                }
                MatrixTraceLegacyTransform.access$replaceChangedFile(this.this$0, (DirectoryInput)v, map);
                return inputDir;
            }
            {
                this.this$0 = matrixTraceLegacyTransform;
                this.$fileToInput = concurrentHashMap;
                super(2);
            }
        };
        Function2 legacyReplaceFile2 = (Function2)new Function2<File, File, Object>(this, fileToInput){
            final /* synthetic */ MatrixTraceLegacyTransform this$0;
            final /* synthetic */ ConcurrentHashMap $fileToInput;

            @NotNull
            public final Object invoke(@NotNull File input, @NotNull File output) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                V v = this.$fileToInput.get(input);
                if (v == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.android.build.api.transform.QualifiedContent");
                }
                MatrixTraceLegacyTransform.access$replaceFile(this.this$0, (QualifiedContent)v, output);
                return input;
            }
            {
                this.this$0 = matrixTraceLegacyTransform;
                this.$fileToInput = concurrentHashMap;
                super(2);
            }
        };
        String string = this.config.ignoreMethodMapFilePath;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"config.ignoreMethodMapFilePath");
        String string2 = this.config.methodMapFilePath;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"config.methodMapFilePath");
        String string3 = this.config.baseMethodMapPath;
        String string4 = this.config.blockListFilePath;
        String string5 = this.config.mappingDir;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"config.mappingDir");
        boolean jarInput = true;
        function2 = legacyReplaceFile2;
        Function2 function22 = legacyReplaceChangedFile2;
        Map map = new ConcurrentHashMap();
        File file = new File(this.config.traceClassOut);
        boolean bl = this.config.skipCheckClass;
        boolean bl2 = isIncremental;
        new MatrixTrace(string, string2, string3, string4, string5, this.project).doTransform((Collection<? extends File>)inputFiles, changedFiles, map, bl2, bl, file, (Function2<? super File, ? super Map<File, ? extends Status>, ? extends Object>)function22, (Function2<? super File, ? super File, ? extends Object>)function2, jarInput);
        long cost = System.currentTimeMillis() - start;
        Log.i((String)TAG, (String)" Insert matrix trace instrumentations cost time: %sms.", (Object[])new Object[]{cost});
    }

    private final void replaceFile(QualifiedContent input, File newFile) {
        Field fileField = ReflectUtil.getDeclaredFieldRecursive(input.getClass(), (String)"file");
        fileField.set(input, newFile);
    }

    private final void replaceChangedFile(DirectoryInput dirInput, Map<File, ? extends Status> changedFiles) {
        Field changedFilesField = ReflectUtil.getDeclaredFieldRecursive(dirInput.getClass(), (String)"changedFiles");
        changedFilesField.set(dirInput, changedFiles);
    }

    public MatrixTraceLegacyTransform(@NotNull Project project, @NotNull Configuration config, @NotNull Transform origTransform) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)origTransform, (String)"origTransform");
        this.project = project;
        this.config = config;
        this.origTransform = origTransform;
    }

    public static final /* synthetic */ void access$replaceChangedFile(MatrixTraceLegacyTransform $this, DirectoryInput dirInput, Map changedFiles) {
        $this.replaceChangedFile(dirInput, changedFiles);
    }

    public static final /* synthetic */ void access$replaceFile(MatrixTraceLegacyTransform $this, QualifiedContent input, File newFile) {
        $this.replaceFile(input, newFile);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/tencent/matrix/plugin/transform/MatrixTraceLegacyTransform$Companion;", "", "()V", "TAG", "", "getTransformTaskName", "", "customDexTransformName", "buildTypeSuffix", "(Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "inject", "", "extension", "Lcom/tencent/matrix/trace/extension/MatrixTraceExtension;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "matrix-gradle-plugin"})
    public static final class Companion {
        public final void inject(@NotNull MatrixTraceExtension extension, @NotNull Project project, @NotNull BaseVariant variant) {
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            Joiner joiner = Joiner.on((char)File.separatorChar);
            File file = project.getBuildDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
            String mappingOut = joiner.join((Object)file.getAbsolutePath(), (Object)"outputs", new Object[]{"mapping", variant.getDirName()});
            Joiner joiner2 = Joiner.on((char)File.separatorChar);
            File file2 = project.getBuildDir();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.buildDir");
            String traceClassOut = joiner2.join((Object)file2.getAbsolutePath(), (Object)"outputs", new Object[]{"traceClassOut", variant.getDirName()});
            Configuration config = new Configuration.Builder().setPackageName(variant.getApplicationId()).setBaseMethodMap(extension.getBaseMethodMapFile()).setBlockListFile(extension.getBlackListFile()).setMethodMapFilePath(mappingOut + "/methodMapping.txt").setIgnoreMethodMapFilePath(mappingOut + "/ignoreMethodMapping.txt").setMappingPath(mappingOut).setTraceClassOut(traceClassOut).setSkipCheckClass(extension.isSkipCheckClass()).build();
            String string = extension.getCustomDexTransformName();
            String string2 = variant.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"variant.name");
            String[] hardTask = this.getTransformTaskName(string, string2);
            block0: for (Task task : project.getTasks()) {
                for (String str : hardTask) {
                    Field field;
                    Task task2 = task;
                    Intrinsics.checkNotNullExpressionValue((Object)task2, (String)"task");
                    if (!StringsKt.equals((String)task2.getName(), (String)str, (boolean)true) || !(task instanceof TransformTask)) continue;
                    Log.i((String)MatrixTraceLegacyTransform.TAG, (String)("successfully inject task:" + ((TransformTask)task).getName()), (Object[])new Object[0]);
                    Field field2 = field = TransformTask.class.getDeclaredField("transform");
                    Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"field");
                    field2.setAccessible(true);
                    Configuration configuration = config;
                    Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"config");
                    Transform transform = ((TransformTask)task).getTransform();
                    Intrinsics.checkNotNullExpressionValue((Object)transform, (String)"task.transform");
                    field.set(task, (Object)new MatrixTraceLegacyTransform(project, configuration, transform));
                    continue block0;
                }
            }
        }

        private final String[] getTransformTaskName(String customDexTransformName, String buildTypeSuffix) {
            String[] stringArray;
            if (!Util.isNullOrNil((String)customDexTransformName)) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = customDexTransformName + "For" + buildTypeSuffix;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "transformClassesWithDexBuilderFor" + buildTypeSuffix;
                stringArray = stringArray3;
                stringArray3[1] = "transformClassesWithDexFor" + buildTypeSuffix;
            }
            return stringArray;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

