/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps;

import android.graphics.SurfaceTexture;
import android.graphics.Typeface;
import android.os.Bundle;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.tencent.map.tools.Callback;
import com.tencent.map.tools.net.AdapterType;
import com.tencent.tencentmap.mapsdk.maps.TencentMap;
import com.tencent.tencentmap.mapsdk.maps.model.MapViewType;
import com.tencent.tencentmap.mapsdk.maps.model.OverSeaSource;
import com.tencent.tencentmap.mapsdk.maps.model.TrafficStyle;
import java.lang.reflect.Field;
import java.util.Arrays;

public final class TencentMapOptions {
    public static final int LOGO_POSITION_BOTTOM_LEFT = 0;
    public static final int LOGO_POSITION_BOTTOM_RIGHT = 1;
    public static final int LOGO_POSITION_TOP_RIGHT = 2;
    public static final int LOGO_POSITION_TOP_LEFT = 3;
    public static final int LOGO_POSITION_BOTTOM_CENTER = 4;
    public static final int LOGO_POSITION_TOP_CENTER = 5;
    public static final int SCALEVIEW_POSITION_BOTTOM_LEFT = 0;
    public static final int SCALEVIEW_POSITION_BOTTOM_RIGHT = 1;
    public static final int SCALEVIEW_POSITION_TOP_RIGHT = 2;
    public static final int SCALEVIEW_POSITION_TOP_LEFT = 3;
    public static final int SCALEVIEW_POSITION_BOTTOM_CENTER = 4;
    public static final int SCALEVIEW_POSITION_TOP_CENTER = 5;
    public static final int ZOOM_POSITION_BOTTOM_LEFT = 0;
    public static final int ZOOM_POSITION_BOTTOM_RIGHT = 1;
    public static final int ZOOM_POSITION_TOP_RIGHT = 2;
    public static final int ZOOM_POSITION_TOP_LEFT = 3;
    private String customAssetsPath;
    private String customLocalPath;
    private String mCustomCacheRootPath;
    private boolean isHandDrawMapEnable = false;
    private Object mExtSurface;
    private int mExtSurfaceWidth;
    private int mExtSurfaceHeight;
    private String mSubId;
    private String mSubKey;
    private String mMapKey;
    private boolean isEnableMultipleInfoWindow = false;
    private String[] mDebugTags;
    private String mSatelliteVersion = "0";
    private MapViewType mMapViewType;
    private IMapKernel mMapKernel;
    private Typeface mUserTypeface;
    private int mProtocolFrom;
    private Object mProtocolDataDesc;
    private AdapterType mNetAdapterType = AdapterType.DEFAULT;
    private Bundle mNetParams;
    private String mCustomUserId;
    private Callback<TencentMap> mMapCallback;
    private boolean mOfflineMapEnable;
    private OverSeaSource mOverSeaSource = OverSeaSource.DEFAULT;
    private TrafficStyle mTrafficStyle;

    public final String getCustomAssetsPath() {
        return this.customAssetsPath;
    }

    public final TencentMapOptions setCustomAssetsPath(String customAssetsPath) {
        this.customAssetsPath = customAssetsPath;
        return this;
    }

    public final String getCustomLocalPath() {
        return this.customLocalPath;
    }

    public final TencentMapOptions setCustomLocalPath(String customLocalPath) {
        this.customLocalPath = customLocalPath;
        return this;
    }

    public final String getCustomCacheRootPath() {
        return this.mCustomCacheRootPath;
    }

    public final TencentMapOptions setCustomCacheRootPath(String customCacheRootPath) {
        this.mCustomCacheRootPath = customCacheRootPath;
        return this;
    }

    public final TencentMapOptions setHandDrawMapEnable(boolean enable) {
        this.isHandDrawMapEnable = enable;
        return this;
    }

    public final boolean isHandDrawMapEnable() {
        return this.isHandDrawMapEnable;
    }

    public final Object getExtSurface() {
        return this.mExtSurface;
    }

    public final TencentMapOptions setExtSurface(Object surface) {
        if (!(surface instanceof Surface || surface instanceof SurfaceTexture || surface instanceof SurfaceHolder)) {
            throw new IllegalArgumentException("Parameter Surface should be Surface,SurfaceTexture or SurfaceHolder");
        }
        this.mExtSurface = surface;
        return this;
    }

    public final TencentMapOptions setTypeface(Typeface typeface) {
        this.setTypeface(typeface, false);
        return this;
    }

    private void setTypeface(Typeface typeface, boolean global) {
        if (typeface == null) {
            return;
        }
        if (global) {
            try {
                Field defTypeface = Typeface.class.getDeclaredField("DEFAULT");
                defTypeface.setAccessible(true);
                defTypeface.set(Typeface.DEFAULT, typeface);
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                return;
            }
        }
        this.mUserTypeface = typeface;
    }

    public final Typeface getTypeface() {
        if (this.mUserTypeface == null) {
            return Typeface.DEFAULT;
        }
        return this.mUserTypeface;
    }

    public final String[] getDebugTags() {
        return this.mDebugTags;
    }

    public final TencentMapOptions setExtSurfaceDimension(int width, int height) {
        this.mExtSurfaceWidth = width;
        this.mExtSurfaceHeight = height;
        return this;
    }

    public final int getExtSurfaceWidth() {
        return this.mExtSurfaceWidth;
    }

    public final int getExtSurfaceHeight() {
        return this.mExtSurfaceHeight;
    }

    public final TencentMapOptions setSubInfo(String subKey, String subId) {
        this.mSubKey = subKey != null ? subKey.trim() : "";
        this.mSubId = subId != null ? subId.trim() : "";
        return this;
    }

    public final String getSubId() {
        return this.mSubId;
    }

    public final String getSubKey() {
        return this.mSubKey;
    }

    public final TencentMapOptions setMapKey(String mapKey) {
        this.mMapKey = mapKey;
        return this;
    }

    public final String getMapKey() {
        return this.mMapKey;
    }

    public final TencentMapOptions openDebugLogByTags(String ... tags) {
        this.mDebugTags = tags;
        return this;
    }

    public final TencentMapOptions setMultipleInfoWindowEnable(boolean isEnable) {
        this.isEnableMultipleInfoWindow = isEnable;
        return this;
    }

    public final boolean isMultipleInfoWindowEnable() {
        return this.isEnableMultipleInfoWindow;
    }

    public final TencentMapOptions setSatelliteVersion(String version) {
        this.mSatelliteVersion = version;
        return this;
    }

    public final String getSatelliteVersion() {
        return this.mSatelliteVersion;
    }

    public final TencentMapOptions setMapViewType(MapViewType mapViewType) {
        this.mMapViewType = mapViewType;
        return this;
    }

    public final MapViewType getMapViewType() {
        return this.mMapViewType;
    }

    public final TencentMapOptions setMapKernel(IMapKernel kernel) {
        this.mMapKernel = kernel;
        return this;
    }

    public final IMapKernel getMapKernel() {
        return this.mMapKernel;
    }

    public final TencentMapOptions setServiceProtocol(int protocolFrom, Object protocolDataDesc) {
        this.mProtocolFrom = protocolFrom;
        this.mProtocolDataDesc = protocolDataDesc;
        return this;
    }

    public final int getProtocolFrom() {
        return this.mProtocolFrom;
    }

    public final Object getProtocolDataDesc() {
        return this.mProtocolDataDesc;
    }

    public final TencentMapOptions setNetAdapter(AdapterType adapterType, Bundle params) {
        this.mNetAdapterType = adapterType;
        this.mNetParams = params;
        return this;
    }

    public final AdapterType getNetAdapterType() {
        return this.mNetAdapterType;
    }

    public final Bundle getNetParams() {
        return this.mNetParams;
    }

    public final TencentMapOptions setCustomUserID(String cuid) {
        this.mCustomUserId = cuid;
        return this;
    }

    public final String getCustomUserId() {
        return this.mCustomUserId;
    }

    public final TencentMapOptions setGetMapAsync(Callback<TencentMap> callback) {
        this.mMapCallback = callback;
        return this;
    }

    public final Callback<TencentMap> getMapAsyncCallback() {
        return this.mMapCallback;
    }

    public final TencentMapOptions setOfflineMapEnable(boolean enable) {
        this.mOfflineMapEnable = enable;
        return this;
    }

    public final boolean isOfflineMapEnable() {
        return this.mOfflineMapEnable;
    }

    public final TencentMapOptions setOverSeaSource(OverSeaSource overSeaSource) {
        this.mOverSeaSource = overSeaSource;
        return this;
    }

    public final OverSeaSource getOverSeaSource() {
        return this.mOverSeaSource;
    }

    public final TrafficStyle getTrafficStyle() {
        return this.mTrafficStyle;
    }

    public final TencentMapOptions setTrafficStyle(TrafficStyle trafficStyle) {
        this.mTrafficStyle = trafficStyle;
        return this;
    }

    public final boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof TencentMapOptions)) {
            return false;
        }
        TencentMapOptions options = (TencentMapOptions)o2;
        if (this.isHandDrawMapEnable != options.isHandDrawMapEnable) {
            return false;
        }
        if (this.mExtSurfaceWidth != options.mExtSurfaceWidth) {
            return false;
        }
        if (this.mExtSurfaceHeight != options.mExtSurfaceHeight) {
            return false;
        }
        if (this.isEnableMultipleInfoWindow != options.isEnableMultipleInfoWindow) {
            return false;
        }
        if (this.mProtocolFrom != options.mProtocolFrom) {
            return false;
        }
        if (this.mOfflineMapEnable != options.mOfflineMapEnable) {
            return false;
        }
        if (this.customAssetsPath != null ? !this.customAssetsPath.equals(options.customAssetsPath) : options.customAssetsPath != null) {
            return false;
        }
        if (this.customLocalPath != null ? !this.customLocalPath.equals(options.customLocalPath) : options.customLocalPath != null) {
            return false;
        }
        if (this.mExtSurface != null ? !this.mExtSurface.equals(options.mExtSurface) : options.mExtSurface != null) {
            return false;
        }
        if (this.mSubId != null ? !this.mSubId.equals(options.mSubId) : options.mSubId != null) {
            return false;
        }
        if (this.mSubKey != null ? !this.mSubKey.equals(options.mSubKey) : options.mSubKey != null) {
            return false;
        }
        if (this.mMapKey != null ? !this.mMapKey.equals(options.mMapKey) : options.mMapKey != null) {
            return false;
        }
        if (!Arrays.equals(this.mDebugTags, options.mDebugTags)) {
            return false;
        }
        if (this.mSatelliteVersion != null ? !this.mSatelliteVersion.equals(options.mSatelliteVersion) : options.mSatelliteVersion != null) {
            return false;
        }
        if (this.mMapViewType != options.mMapViewType) {
            return false;
        }
        if (this.mMapKernel != null ? !this.mMapKernel.equals(options.mMapKernel) : options.mMapKernel != null) {
            return false;
        }
        if (this.mUserTypeface != null ? !this.mUserTypeface.equals((Object)options.mUserTypeface) : options.mUserTypeface != null) {
            return false;
        }
        if (this.mProtocolDataDesc != null ? !this.mProtocolDataDesc.equals(options.mProtocolDataDesc) : options.mProtocolDataDesc != null) {
            return false;
        }
        if (this.mNetAdapterType != options.mNetAdapterType) {
            return false;
        }
        if (this.mNetParams != null ? !this.mNetParams.equals(options.mNetParams) : options.mNetParams != null) {
            return false;
        }
        if (this.mCustomUserId != null ? !this.mCustomUserId.equals(options.mCustomUserId) : options.mCustomUserId != null) {
            return false;
        }
        if (this.mMapCallback != null ? !this.mMapCallback.equals(options.mMapCallback) : options.mMapCallback != null) {
            return false;
        }
        if (this.mTrafficStyle != null ? !this.mTrafficStyle.equals(options.mTrafficStyle) : options.mTrafficStyle != null) {
            return false;
        }
        return this.mOverSeaSource == options.mOverSeaSource;
    }

    public final int hashCode() {
        int result = this.customAssetsPath != null ? this.customAssetsPath.hashCode() : 0;
        result = 31 * result + (this.customLocalPath != null ? this.customLocalPath.hashCode() : 0);
        result = 31 * result + (this.isHandDrawMapEnable ? 1 : 0);
        result = 31 * result + (this.mExtSurface != null ? this.mExtSurface.hashCode() : 0);
        result = 31 * result + this.mExtSurfaceWidth;
        result = 31 * result + this.mExtSurfaceHeight;
        result = 31 * result + (this.mSubId != null ? this.mSubId.hashCode() : 0);
        result = 31 * result + (this.mSubKey != null ? this.mSubKey.hashCode() : 0);
        result = 31 * result + (this.mMapKey != null ? this.mMapKey.hashCode() : 0);
        result = 31 * result + (this.isEnableMultipleInfoWindow ? 1 : 0);
        result = 31 * result + Arrays.hashCode(this.mDebugTags);
        result = 31 * result + (this.mSatelliteVersion != null ? this.mSatelliteVersion.hashCode() : 0);
        result = 31 * result + (this.mMapViewType != null ? this.mMapViewType.hashCode() : 0);
        result = 31 * result + (this.mMapKernel != null ? this.mMapKernel.hashCode() : 0);
        result = 31 * result + (this.mUserTypeface != null ? this.mUserTypeface.hashCode() : 0);
        result = 31 * result + this.mProtocolFrom;
        result = 31 * result + (this.mProtocolDataDesc != null ? this.mProtocolDataDesc.hashCode() : 0);
        result = 31 * result + (this.mNetAdapterType != null ? this.mNetAdapterType.hashCode() : 0);
        result = 31 * result + (this.mNetParams != null ? this.mNetParams.hashCode() : 0);
        result = 31 * result + (this.mCustomUserId != null ? this.mCustomUserId.hashCode() : 0);
        result = 31 * result + (this.mMapCallback != null ? this.mMapCallback.hashCode() : 0);
        result = 31 * result + (this.mOfflineMapEnable ? 1 : 0);
        result = 31 * result + (this.mOverSeaSource != null ? this.mOverSeaSource.hashCode() : 0);
        return 31 * result + (this.mTrafficStyle != null ? this.mTrafficStyle.hashCode() : 0);
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer("TencentMapOptions{");
        sb.append("customAssetsPath='").append(this.customAssetsPath).append('\'');
        sb.append(", customLocalPath='").append(this.customLocalPath).append('\'');
        sb.append(", isHandDrawMapEnable=").append(this.isHandDrawMapEnable);
        sb.append(", mExtSurface=").append(this.mExtSurface);
        sb.append(", mExtSurfaceWidth=").append(this.mExtSurfaceWidth);
        sb.append(", mExtSurfaceHeight=").append(this.mExtSurfaceHeight);
        sb.append(", mSubId='").append(this.mSubId).append('\'');
        sb.append(", mSubKey='").append(this.mSubKey).append('\'');
        sb.append(", mMapKey='").append(this.mMapKey).append('\'');
        sb.append(", isEnableMultipleInfoWindow=").append(this.isEnableMultipleInfoWindow);
        sb.append(", mDebugTags=").append(this.mDebugTags == null ? "null" : Arrays.asList(this.mDebugTags).toString());
        sb.append(", mSatelliteVersion='").append(this.mSatelliteVersion).append('\'');
        sb.append(", mMapViewType=").append((Object)this.mMapViewType);
        sb.append(", mMapKernel=").append(this.mMapKernel);
        sb.append(", mUserTypeface=").append(this.mUserTypeface);
        sb.append(", mProtocolFrom=").append(this.mProtocolFrom);
        sb.append(", mProtocolDataDesc=").append(this.mProtocolDataDesc);
        sb.append(", mNetAdapterType=").append((Object)this.mNetAdapterType);
        sb.append(", mNetParams=").append(this.mNetParams);
        sb.append(", mCustomUserId='").append(this.mCustomUserId).append('\'');
        sb.append(", mMapCallback=").append(this.mMapCallback);
        sb.append(", mOfflineMapEnable=").append(this.mOfflineMapEnable);
        sb.append(", mOverSeaSource=").append((Object)this.mOverSeaSource);
        sb.append(", mTrafficStyle=").append(this.mTrafficStyle);
        sb.append('}');
        return sb.toString();
    }

    public static interface IMapKernel {
        public String name();
    }
}

