/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.tools.net.adapter;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.tencent.map.tools.Callback;
import com.tencent.map.tools.net.NetResponse;
import com.tencent.map.tools.net.NetUtil;
import com.tencent.map.tools.net.adapter.AbsNetImpl;
import com.tencent.map.tools.net.exception.FileUploadResetException;
import com.tencent.map.tools.net.http.HttpCanceler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class URLNetImpl
extends AbsNetImpl {
    private static final String TAG = "URLNetImpl";
    private static final boolean DEBUG = false;
    private HttpURLConnection mCurrentConnect;

    @Override
    protected void onCreateNet(Context context, Bundle params) {
        this.disableConnectionReuseIfNecessary();
    }

    @Override
    protected NetResponse onGetRequest(String url, String userAgent, int retryMethod, int timeOut, HashMap<String, String> mapHeaders, HttpCanceler canceler) {
        NetResponse netResponse = null;
        URL urlReq = null;
        try {
            urlReq = new URL(url);
        }
        catch (MalformedURLException e2) {
            netResponse = new NetResponse(e2);
        }
        final a retryConnectStrategy = new a(retryMethod);
        while (retryConnectStrategy.a()) {
            HttpURLConnection connection = null;
            int statusCode = 0;
            try {
                if (urlReq == null) continue;
                connection = (HttpURLConnection)urlReq.openConnection();
                connection.setRequestMethod("GET");
                if (timeOut > 0) {
                    connection.setConnectTimeout(timeOut);
                }
                if (mapHeaders != null && !mapHeaders.isEmpty()) {
                    for (Map.Entry<String, String> entry : mapHeaders.entrySet()) {
                        String key = entry.getKey();
                        String value = entry.getValue();
                        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) continue;
                        connection.addRequestProperty(key, value);
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)userAgent)) {
                    connection.addRequestProperty("User-Agent", userAgent);
                }
                if (canceler != null) {
                    canceler.setHttpAccessRequest(this, new Callback<Boolean>(){

                        @Override
                        public final /* synthetic */ void callback(Object object) {
                            1 var2_2 = this;
                            retryConnectStrategy.a = false;
                            var2_2.URLNetImpl.this.mCurrentConnect = null;
                        }
                    });
                    this.mCurrentConnect = connection;
                }
                connection.connect();
                statusCode = connection.getResponseCode();
                netResponse = new NetResponse();
                new NetResponse().statusCode = statusCode;
                netResponse.charset = URLNetImpl.parseCharset(connection.getContentType());
                if (statusCode == 200) {
                    netResponse.errorCode = 0;
                    InputStream dataStream = connection.getInputStream();
                    netResponse.data = NetUtil.toBytes(dataStream);
                    retryConnectStrategy.a = false;
                    continue;
                }
                netResponse.errorData = NetUtil.toBytes(connection.getErrorStream());
                retryConnectStrategy.b();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                retryConnectStrategy.b();
            }
            catch (IOException e3) {
                netResponse = new NetResponse(e3);
                new NetResponse(e3).statusCode = statusCode;
                retryConnectStrategy.b();
            }
            finally {
                if (connection == null) continue;
                connection.disconnect();
            }
        }
        return netResponse;
    }

    @Override
    protected NetResponse onPostRequest(String url, String userAgent, byte[] postData, int retryMethod, HashMap<String, String> mapHeaders, HttpCanceler canceler, int timeout) {
        NetResponse netResponse = null;
        URL urlReq = null;
        try {
            urlReq = new URL(url);
        }
        catch (MalformedURLException e2) {
            netResponse = new NetResponse(e2);
        }
        final a retryConnectStrategy = new a(retryMethod);
        while (retryConnectStrategy.a()) {
            HttpURLConnection connection = null;
            OutputStream outputStream = null;
            int statusCode = 0;
            try {
                if (urlReq == null) continue;
                connection = (HttpURLConnection)urlReq.openConnection();
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                if (timeout > 0) {
                    connection.setConnectTimeout(timeout);
                }
                if (mapHeaders != null && !mapHeaders.isEmpty()) {
                    for (Map.Entry<String, String> entry : mapHeaders.entrySet()) {
                        String key = entry.getKey();
                        String value = entry.getValue();
                        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) continue;
                        connection.addRequestProperty(key, value);
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)userAgent)) {
                    connection.addRequestProperty("User-Agent", userAgent);
                }
                if (canceler != null) {
                    canceler.setHttpAccessRequest(this, new Callback<Boolean>(){

                        @Override
                        public final /* synthetic */ void callback(Object object) {
                            2 var2_2 = this;
                            retryConnectStrategy.a = false;
                            var2_2.URLNetImpl.this.mCurrentConnect = null;
                        }
                    });
                    this.mCurrentConnect = connection;
                }
                outputStream = connection.getOutputStream();
                NetUtil.writeBytesWithoutClose(postData, outputStream);
                connection.connect();
                statusCode = connection.getResponseCode();
                netResponse = new NetResponse();
                new NetResponse().statusCode = statusCode;
                netResponse.charset = URLNetImpl.parseCharset(connection.getContentType());
                if (statusCode == 200) {
                    netResponse.errorCode = 0;
                    InputStream dataStream = connection.getInputStream();
                    netResponse.data = NetUtil.toBytes(dataStream);
                    retryConnectStrategy.a = false;
                    continue;
                }
                netResponse.errorData = NetUtil.toBytes(connection.getErrorStream());
                retryConnectStrategy.b();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                retryConnectStrategy.b();
            }
            catch (IOException e3) {
                netResponse = new NetResponse(e3);
                new NetResponse(e3).statusCode = statusCode;
                retryConnectStrategy.b();
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
                NetUtil.safeClose(outputStream);
            }
        }
        return netResponse;
    }

    @Override
    protected NetResponse onPostNoBuffer(String url, String userAgent, byte[] postData) {
        NetResponse netResponse = null;
        URL urlReq = null;
        try {
            urlReq = new URL(url);
        }
        catch (MalformedURLException e2) {
            netResponse = new NetResponse(e2);
        }
        HttpURLConnection connection = null;
        OutputStream outputStream = null;
        int statusCode = 0;
        try {
            if (urlReq != null) {
                connection = (HttpURLConnection)urlReq.openConnection();
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                if (!TextUtils.isEmpty((CharSequence)userAgent)) {
                    connection.addRequestProperty("User-Agent", userAgent);
                }
                outputStream = connection.getOutputStream();
                NetUtil.writeBytesWithoutClose(postData, outputStream);
                connection.connect();
                statusCode = connection.getResponseCode();
                netResponse = new NetResponse();
                new NetResponse().statusCode = statusCode;
                netResponse.charset = URLNetImpl.parseCharset(connection.getContentType());
                if (statusCode == 200) {
                    netResponse.errorCode = 0;
                    InputStream dataStream = connection.getInputStream();
                    netResponse.data = NetUtil.toBytes(dataStream);
                } else {
                    netResponse.errorData = NetUtil.toBytes(connection.getErrorStream());
                }
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
        }
        catch (IOException e3) {
            netResponse = new NetResponse(e3);
            new NetResponse(e3).statusCode = statusCode;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
            NetUtil.safeClose(outputStream);
        }
        return netResponse;
    }

    @Override
    protected void onRangePost(String url, byte[] postData, String token, String nonce, String timeStamp, String start, HttpCanceler canceler) throws Exception {
        URL urlReq = null;
        try {
            urlReq = new URL(url);
        }
        catch (MalformedURLException malformedURLException) {}
        HttpURLConnection connection = null;
        OutputStream outputStream = null;
        try {
            if (urlReq != null) {
                String returnCode;
                int retCode;
                connection = (HttpURLConnection)urlReq.openConnection();
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.addRequestProperty("User-Agent", "QQ Map Mobile");
                connection.addRequestProperty("Sign", token);
                connection.addRequestProperty("nonce", nonce);
                connection.addRequestProperty("timestamp", timeStamp);
                connection.addRequestProperty("Range", "bytes=" + start + "-");
                if (canceler != null) {
                    canceler.setHttpAccessRequest(this, new Callback<Boolean>(){

                        @Override
                        public final /* synthetic */ void callback(Object object) {
                            URLNetImpl.this.mCurrentConnect = null;
                        }
                    });
                    this.mCurrentConnect = connection;
                }
                outputStream = connection.getOutputStream();
                NetUtil.writeBytesWithoutClose(postData, outputStream);
                connection.connect();
                int statusCode = connection.getResponseCode();
                URLNetImpl.parseCharset(connection.getContentType());
                if (statusCode == 200 && (retCode = Integer.parseInt(returnCode = connection.getHeaderField("User-ReturnCode"))) != 0) {
                    if (retCode == -2) {
                        throw new FileUploadResetException();
                    }
                    throw new Exception("FileUploader user error:".concat(String.valueOf(returnCode)));
                }
            }
            return;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
            NetUtil.safeClose(outputStream);
        }
    }

    private void disableConnectionReuseIfNecessary() {
        if (Integer.parseInt(Build.VERSION.SDK) < 8) {
            System.setProperty("http.keepAlive", "false");
        }
    }

    @Override
    public boolean cancel() {
        if (this.mCurrentConnect != null) {
            this.mCurrentConnect.disconnect();
            return true;
        }
        return false;
    }

    final class a {
        private int c;
        boolean a = true;

        a(int retry) {
            this.c = retry;
            if (this.c > 3) {
                this.c = 3;
            }
            if (this.c <= 0) {
                this.c = 1;
            }
        }

        final boolean a() {
            return this.a && this.c > 0;
        }

        final void b() {
            --this.c;
        }
    }
}

