/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.tools.net;

import com.tencent.map.tools.net.exception.NetErrorException;

public class NetResponse {
    public int errorCode = -1;
    public int statusCode;
    public byte[] data;
    public String charset = "GBK";
    public Exception exception;
    public byte[] errorData;

    public NetResponse() {
    }

    public NetResponse(Exception exception) {
        this.exception = exception;
        if (exception instanceof NetErrorException) {
            this.errorCode = ((NetErrorException)exception).errorCode;
            this.statusCode = ((NetErrorException)exception).statusCode;
        }
    }

    public boolean available() {
        return this.errorCode == 0 && this.statusCode == 200 || this.data != null && this.data.length > 0;
    }

    public void clone(NetResponse netResponse) {
        if (netResponse != null) {
            this.errorCode = netResponse.errorCode;
            this.statusCode = netResponse.statusCode;
            this.data = netResponse.data;
            this.charset = netResponse.charset;
            this.exception = netResponse.exception;
            this.errorData = netResponse.errorData;
        }
    }

    public String toString() {
        try {
            if (this.data != null) {
                return new String(this.data, this.charset);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    public String toHumanString() {
        if (this.data != null) {
            return "[DATA] " + new String(this.data);
        }
        if (this.errorData != null) {
            if (this.exception != null) {
                this.exception.printStackTrace();
            }
            return "[ERROR] " + new String(this.errorData);
        }
        return "";
    }
}

