/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.lbssearch.object.param;

import android.text.TextUtils;
import com.tencent.lbssearch.object.RequestParams;
import com.tencent.lbssearch.object.param.ParamObject;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;

public class StreetViewParam
implements ParamObject {
    private static final String ID = "id";
    private static final String LOCATION = "location";
    private static final String POI = "poi";
    private static final String RADIUS = "radius";
    private String id;
    private LatLng latLng;
    private String poi;
    private int radius;

    public StreetViewParam location(LatLng latLng) {
        this.latLng = latLng;
        return this;
    }

    public StreetViewParam id(String id) {
        this.id = id;
        return this;
    }

    public StreetViewParam poi(String poi) {
        this.poi = poi;
        return this;
    }

    public StreetViewParam radius(int radius) {
        this.radius = radius;
        return this;
    }

    @Override
    public boolean checkParams() {
        return !TextUtils.isEmpty((CharSequence)this.id) || this.latLng != null || !TextUtils.isEmpty((CharSequence)this.poi);
    }

    @Override
    public RequestParams buildParameters() {
        RequestParams params = new RequestParams();
        if (this.latLng != null) {
            params.add(LOCATION, this.latLng.latitude + "," + this.latLng.longitude);
        }
        if (!TextUtils.isEmpty((CharSequence)this.poi)) {
            params.add(POI, this.poi);
        }
        if (!TextUtils.isEmpty((CharSequence)this.id)) {
            params.add(ID, this.id);
        }
        if (this.radius > 0) {
            params.add(RADIUS, String.valueOf(this.radius));
        }
        return params;
    }
}

