/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.lbssearch;

import android.content.Context;
import android.text.TextUtils;
import com.tencent.lbssearch.HttpProvider;
import com.tencent.lbssearch.httpresponse.BaseObject;
import com.tencent.lbssearch.httpresponse.UrlConstant;
import com.tencent.lbssearch.object.RequestParams;
import com.tencent.lbssearch.object.param.Address2GeoParam;
import com.tencent.lbssearch.object.param.DistrictChildrenParam;
import com.tencent.lbssearch.object.param.DistrictSearchParam;
import com.tencent.lbssearch.object.param.Geo2AddressParam;
import com.tencent.lbssearch.object.param.ParamObject;
import com.tencent.lbssearch.object.param.RoutePlanningParam;
import com.tencent.lbssearch.object.param.SearchParam;
import com.tencent.lbssearch.object.param.StreetViewParam;
import com.tencent.lbssearch.object.param.SuggestionParam;
import com.tencent.lbssearch.object.param.TranslateParam;
import com.tencent.lbssearch.object.result.Address2GeoResultObject;
import com.tencent.lbssearch.object.result.DistrictResultObject;
import com.tencent.lbssearch.object.result.Geo2AddressResultObject;
import com.tencent.lbssearch.object.result.SearchResultObject;
import com.tencent.lbssearch.object.result.StreetViewResultObject;
import com.tencent.lbssearch.object.result.SuggestionResultObject;
import com.tencent.lbssearch.object.result.TranslateResultObject;
import com.tencent.map.tools.Util;
import com.tencent.map.tools.net.http.HttpResponseListener;

public class TencentSearch
implements UrlConstant {
    private Context mContext;

    public TencentSearch(Context context) {
        this.mContext = context;
    }

    public void search(SearchParam object, HttpResponseListener listener) {
        this.doHttpGet("https://apis.map.qq.com/ws/place/v1/search", object, SearchResultObject.class, listener);
    }

    public void suggestion(SuggestionParam object, HttpResponseListener listener) {
        this.doHttpGet("https://apis.map.qq.com/ws/place/v1/suggestion", object, SuggestionResultObject.class, listener);
    }

    public void geo2address(Geo2AddressParam object, HttpResponseListener listener) {
        this.doHttpGet("https://apis.map.qq.com/ws/geocoder/v1", object, Geo2AddressResultObject.class, listener);
    }

    public void address2geo(Address2GeoParam object, HttpResponseListener listener) {
        this.doHttpGet("https://apis.map.qq.com/ws/geocoder/v1", object, Address2GeoResultObject.class, listener);
    }

    public void getDistrictList(HttpResponseListener listener) {
        this.doHttpGet("https://apis.map.qq.com/ws/district/v1/list", new DistrictChildrenParam(), DistrictResultObject.class, listener);
    }

    public void getDistrictChildren(DistrictChildrenParam object, HttpResponseListener listener) {
        this.doHttpGet("https://apis.map.qq.com/ws/district/v1/getchildren", object, DistrictResultObject.class, listener);
    }

    public void getDistrictSearch(DistrictSearchParam object, HttpResponseListener listener) {
        this.doHttpGet("https://apis.map.qq.com/ws/district/v1/search", object, DistrictResultObject.class, listener);
    }

    public void translate(TranslateParam object, HttpResponseListener listener) {
        this.doHttpGet("https://apis.map.qq.com/ws/coord/v1/translate", object, TranslateResultObject.class, listener);
    }

    public void getpano(StreetViewParam object, HttpResponseListener listener) {
        this.doHttpGet("https://apis.map.qq.com/ws/streetview/v1/getpano", object, StreetViewResultObject.class, listener);
    }

    public void getRoutePlan(RoutePlanningParam param, HttpResponseListener listener) {
        RoutePlanningParam routePlanningParam = param;
        this.doHttpGet(param.getUrl(), routePlanningParam, routePlanningParam.getResultClass(), listener);
    }

    private <T extends BaseObject> void doHttpGet(String url, ParamObject object, Class<T> t2, HttpResponseListener<T> listener) {
        if (object == null || !object.checkParams()) {
            return;
        }
        String authKey = Util.getMetaKey(this.mContext, "TencentMapSDK");
        if (TextUtils.isEmpty((CharSequence)authKey)) {
            if (listener != null) {
                listener.onFailure(-1, "\u8bf7\u7533\u8bf7\u5e76\u586b\u5199\u5f00\u53d1\u8005\u5bc6\u94a5", null);
            }
            return;
        }
        RequestParams params = object.buildParameters();
        if (params != null) {
            params.add("key", authKey);
            params.add("output", "json");
        } else {
            params = new RequestParams();
        }
        params.add("__suid", Util.getIMei(this.mContext));
        params.add("__pf", "android");
        params.add("__chan", "search");
        params.add("__pid", Util.getAppName(this.mContext));
        params.add("__psv", Util.getAppVersion(this.mContext));
        params.add("__ver", "1.0.0");
        HttpProvider.get(this.mContext, url, params, t2, listener);
    }
}

