/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model;

import android.os.Parcel;
import android.support.annotation.NonNull;
import com.tencent.tencentmap.mapsdk.maps.model.BitmapDescriptor;
import com.tencent.tencentmap.mapsdk.maps.model.IndoorInfo;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import com.tencent.tencentmap.mapsdk.maps.model.OverlayLevel;

public class MarkerOptions {
    private LatLng mlatlng;
    private String strtitle = "";
    private String strSnippet;
    private BitmapDescriptor bitmapDesctor;
    private float fanchorU = 0.5f;
    private float fanchorV = 0.5f;
    private boolean boDragable;
    private boolean boVisible = true;
    private float fAngle = 0.0f;
    private float fAlpha = 1.0f;
    private float zIndex = 0.0f;
    private Object mTag;
    private String contentDescription;
    private IndoorInfo mIndoorInfo;
    private boolean boInfoWindowEnable = true;
    private boolean bFlat = false;
    private boolean mClockwise = true;
    private float mInfowindowAnchorU = 0.5f;
    private float mInfowindowAnchorV = 1.0f;
    private int mInfowindowOffsetX = 0;
    private int mInfowindowOffsetY = 0;
    private boolean mIsFastLoad = true;
    private boolean mIsViewInfowindow = false;
    private int iLevel = OverlayLevel.OverlayLevelAboveLabels;

    public MarkerOptions(@NonNull LatLng position) {
        this.mlatlng = position;
    }

    @Deprecated
    public MarkerOptions() {
    }

    public MarkerOptions position(LatLng latlng) {
        this.mlatlng = latlng;
        return this;
    }

    public MarkerOptions infoWindowEnable(boolean enabled) {
        this.boInfoWindowEnable = enabled;
        return this;
    }

    public MarkerOptions icon(BitmapDescriptor icon) {
        this.bitmapDesctor = icon;
        return this;
    }

    public MarkerOptions anchor(float anchorU, float anchorV) {
        this.fanchorU = anchorU;
        this.fanchorV = anchorV;
        return this;
    }

    public MarkerOptions title(String s2) {
        this.strtitle = s2;
        return this;
    }

    public MarkerOptions rotation(float rotation) {
        this.fAngle = rotation;
        return this;
    }

    public MarkerOptions snippet(String snippet) {
        this.strSnippet = snippet;
        return this;
    }

    public MarkerOptions draggable(boolean flag) {
        this.boDragable = flag;
        return this;
    }

    public MarkerOptions alpha(float alpha) {
        this.fAlpha = alpha;
        return this;
    }

    public MarkerOptions visible(boolean flag) {
        this.boVisible = flag;
        return this;
    }

    public MarkerOptions flat(boolean flat) {
        this.bFlat = flat;
        return this;
    }

    public MarkerOptions zIndex(float zIndex) {
        this.zIndex = zIndex;
        return this;
    }

    public MarkerOptions indoorInfo(IndoorInfo indoorInfo) {
        this.mIndoorInfo = indoorInfo;
        return this;
    }

    public MarkerOptions tag(Object tag) {
        this.mTag = tag;
        return this;
    }

    public boolean isAvoidAnnocation() {
        return false;
    }

    public LatLng getPosition() {
        return this.mlatlng;
    }

    public String getTitle() {
        return this.strtitle;
    }

    public String getSnippet() {
        return this.strSnippet;
    }

    public BitmapDescriptor getIcon() {
        return this.bitmapDesctor;
    }

    public float getAnchorU() {
        return this.fanchorU;
    }

    public float getAnchorV() {
        return this.fanchorV;
    }

    public boolean isDraggable() {
        return this.boDragable;
    }

    public boolean isVisible() {
        return this.boVisible;
    }

    public boolean isInfoWindowEnable() {
        return this.boInfoWindowEnable;
    }

    public float getAlpha() {
        return this.fAlpha;
    }

    public float getZIndex() {
        return this.zIndex;
    }

    public IndoorInfo getIndoorInfo() {
        return this.mIndoorInfo;
    }

    public boolean isFlat() {
        return this.bFlat;
    }

    public float getRotation() {
        return this.fAngle;
    }

    public MarkerOptions clockwise(boolean clockwise) {
        this.mClockwise = clockwise;
        return this;
    }

    public boolean isClockwise() {
        return this.mClockwise;
    }

    public MarkerOptions infoWindowAnchor(float u2, float v2) {
        this.mInfowindowAnchorU = u2;
        this.mInfowindowAnchorV = v2;
        return this;
    }

    public float getInfoWindowAnchorU() {
        return this.mInfowindowAnchorU;
    }

    public float getInfoWindowAnchorV() {
        return this.mInfowindowAnchorV;
    }

    public MarkerOptions infoWindowOffset(int offsetX, int offsetY) {
        this.mInfowindowOffsetX = offsetX;
        this.mInfowindowOffsetY = offsetY;
        return this;
    }

    public int getInfoWindowOffsetX() {
        return this.mInfowindowOffsetX;
    }

    public int getInfowindowOffsetY() {
        return this.mInfowindowOffsetY;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (out == null) {
            return;
        }
        if (this.mlatlng != null) {
            out.writeString(this.mlatlng.toString());
        }
    }

    public Object getTag() {
        return this.mTag;
    }

    public boolean isFastLoad() {
        return this.mIsFastLoad;
    }

    public MarkerOptions fastLoad(boolean fastLoad) {
        this.mIsFastLoad = fastLoad;
        return this;
    }

    public MarkerOptions contentDescription(String contentDescription) {
        this.contentDescription = contentDescription;
        return this;
    }

    public String getContentDescription() {
        return this.contentDescription;
    }

    public MarkerOptions level(int level) {
        if (level < OverlayLevel.OverlayLevelAboveRoads || level > OverlayLevel.OverlayLevelAboveLabels) {
            return this;
        }
        this.iLevel = level;
        return this;
    }

    public int getLevel() {
        return this.iLevel;
    }

    public MarkerOptions viewInfoWindow(boolean enabled) {
        this.mIsViewInfowindow = enabled;
        return this;
    }

    public boolean isViewInfowindow() {
        return this.mIsViewInfowindow;
    }
}

