/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model;

import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.tencent.map.tools.json.JsonComposer;
import com.tencent.map.tools.json.annotation.Json;
import org.json.JSONObject;

public class LatLng
extends JsonComposer
implements Parcelable {
    public static final Parcelable.Creator<LatLng> CREATOR = new Parcelable.Creator<LatLng>(){

        public final /* synthetic */ Object createFromParcel(@NonNull Parcel parcel) {
            Parcel parcel2 = parcel;
            return new LatLng(parcel2);
        }
    };
    @Json(name="lat")
    public double latitude;
    @Json(name="lng")
    public double longitude;
    public double altitude = 0.0;

    public LatLng() {
        this.latitude = 0.0;
        this.longitude = 0.0;
    }

    public LatLng(double latitude, double longitude) {
        this.setLatitude(latitude);
        this.setLongitude(longitude);
    }

    public LatLng(double latitude, double longitude, double altitude) {
        this.setLatitude(latitude);
        this.setLongitude(longitude);
        this.setAltitude(altitude);
    }

    public LatLng(Location location) {
        this(location.getLatitude(), location.getLongitude(), location.getAltitude());
    }

    public LatLng(LatLng latLng) {
        this.latitude = latLng.latitude;
        this.longitude = latLng.longitude;
        this.altitude = latLng.altitude;
    }

    public LatLng(Parcel in) {
        this.setLatitude(in.readDouble());
        this.setLongitude(in.readDouble());
        this.setAltitude(in.readDouble());
    }

    public void setLatitude(@FloatRange(from=-90.0, to=90.0) double latitude) {
        if (Double.isNaN(latitude)) {
            throw new IllegalArgumentException("latitude must not be NaN");
        }
        if (Math.abs(latitude) > 90.0) {
            throw new IllegalArgumentException("latitude must be between -90 and 90");
        }
        this.latitude = latitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLongitude(@FloatRange(from=-1.7976931348623157E308, to=1.7976931348623157E308) double longitude) {
        if (Double.isNaN(longitude)) {
            throw new IllegalArgumentException("longitude must not be NaN");
        }
        if (Double.isInfinite(longitude)) {
            throw new IllegalArgumentException("longitude must not be infinite");
        }
        this.longitude = longitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    public double getAltitude() {
        return this.altitude;
    }

    @NonNull
    public LatLng wrap() {
        return new LatLng(this.latitude, LatLng.wrap(this.longitude, -180.0, 180.0));
    }

    static double wrap(double value, double min, double max) {
        double delta = max - min;
        double secondMod = ((value - min) % delta + delta) % delta;
        if (value >= max && secondMod == 0.0) {
            return max;
        }
        return secondMod + min;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LatLng latLng = (LatLng)object;
        return Double.compare(latLng.altitude, this.altitude) == 0 && Double.compare(latLng.latitude, this.latitude) == 0 && Double.compare(latLng.longitude, this.longitude) == 0;
    }

    public int hashCode() {
        long temp;
        long l2 = Double.doubleToLongBits(this.latitude);
        int result = (int)(l2 ^ l2 >>> 32);
        long l3 = temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(l3 ^ l3 >>> 32);
        long l4 = temp = Double.doubleToLongBits(this.altitude);
        return 31 * result + (int)(l4 ^ l4 >>> 32);
    }

    @NonNull
    public String toString() {
        return "LatLng [latitude=" + this.latitude + ", longitude=" + this.longitude + ", altitude=" + this.altitude + "]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeDouble(this.latitude);
        out.writeDouble(this.longitude);
        out.writeDouble(this.altitude);
    }

    @Override
    public void parse(JSONObject jsonObject) {
        super.parse(jsonObject);
    }
}

