/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.video;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Binder;
import android.os.IBinder;
import com.tencent.rtmp.video.BaseBridge;
import com.tencent.rtmp.video.VirtualDisplayManagerProxy;

public class ScreenCaptureService
extends Service {
    private static final String TAG = "ScreenCaptureService";
    private static final int NOTIFICATION_ID = 13957237;
    private static final String CHANNEL_ID = "notification_id";

    public IBinder onBind(Intent intent) {
        BaseBridge.printLog(TAG, "Service on bind");
        return new Binder();
    }

    public boolean onUnbind(Intent intent) {
        BaseBridge.printLog(TAG, "Service on unbind");
        return super.onUnbind(intent);
    }

    public void onDestroy() {
        this.stopForeground(true);
        super.onDestroy();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        int n = intent.getIntExtra("code", -1);
        Intent intent2 = (Intent)intent.getParcelableExtra("data");
        BaseBridge.printLog(TAG, "On Start server command, code:" + n + ", data:" + intent2);
        if (intent2 == null) {
            this.stopSelf();
            return 2;
        }
        try {
            if (BaseBridge.getSystemOSVersion() >= 29) {
                this.startForeground(13957237, this.createNotification(), 32);
            } else if (BaseBridge.getSystemOSVersion() >= 26) {
                this.startForeground(13957237, this.createNotification());
            }
        }
        catch (Throwable throwable) {
            BaseBridge.printLog(TAG, "start foreground failed.".concat(String.valueOf(throwable)));
        }
        MediaProjection mediaProjection = null;
        if (BaseBridge.getSystemOSVersion() >= 21) {
            MediaProjectionManager mediaProjectionManager = (MediaProjectionManager)BaseBridge.getAppContext().getSystemService("media_projection");
            try {
                mediaProjection = mediaProjectionManager.getMediaProjection(n, intent2);
            }
            catch (Throwable throwable) {
                BaseBridge.printLog(TAG, "onStartCommand mediaProjectionManager getMediaProjection fail.".concat(String.valueOf(throwable)));
            }
            VirtualDisplayManagerProxy.getInstance().signalSessionRequestFinish(mediaProjection);
        }
        return 2;
    }

    private Notification createNotification() {
        NotificationManager notificationManager;
        if (BaseBridge.getSystemOSVersion() >= 26) {
            notificationManager = (NotificationManager)this.getSystemService("notification");
            NotificationChannel notificationChannel = new NotificationChannel(CHANNEL_ID, (CharSequence)"notification_name", 2);
            notificationManager.createNotificationChannel(notificationChannel);
        }
        notificationManager = new Notification.Builder((Context)this).setDefaults(1);
        if (BaseBridge.getSystemOSVersion() >= 26) {
            notificationManager.setChannelId(CHANNEL_ID);
        }
        return notificationManager.build();
    }
}

