/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.jmx;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.jmx.AbstractMBean;
import org.hyperic.sigar.jmx.SigarInvokerJMX;

public class ReflectedMBean
extends AbstractMBean {
    private Map methods;
    private Map attrs = new HashMap();
    private String type;
    private String name;
    private SigarInvokerJMX invoker;

    protected String getType() {
        return this.type;
    }

    void setType(String type) {
        this.type = type;
    }

    void putAttribute(String name, Object val) {
        this.attrs.put(name, val);
    }

    void putAttributes(Map attrs) {
        this.attrs.putAll(attrs);
    }

    void putAttributes(Object obj) {
        Method[] methods = obj.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String name;
            Method method = methods[i];
            if (method.getParameterTypes().length != 0 || !(name = method.getName()).startsWith("get")) continue;
            name = name.substring(3);
            try {
                this.putAttribute(name, method.invoke(obj, new Object[0]));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getMBeanClassName() {
        String type = this.getType();
        String list = "List";
        if (type.endsWith("List")) {
            type = type.substring(0, type.length() - "List".length());
        }
        return "org.hyperic.sigar." + type;
    }

    private Class getMBeanClass() {
        try {
            return Class.forName(this.getMBeanClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected ReflectedMBean(SigarProxy sigar, String type) {
        super(sigar);
        this.type = type;
        this.name = "sigar:Type=" + this.getType();
    }

    protected ReflectedMBean(SigarProxy sigar, String type, String arg) {
        this(sigar, type);
        this.name = this.name + ",Name=" + this.encode(arg);
    }

    private String encode(String arg) {
        return arg.replaceAll(":", "%3A");
    }

    public String getObjectName() {
        return this.name;
    }

    protected SigarInvokerJMX getInvoker() {
        if (this.invoker == null) {
            this.invoker = SigarInvokerJMX.getInstance(this.sigar, this.getObjectName());
            this.invoker.setType(this.getType());
        }
        return this.invoker;
    }

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object val = this.attrs.get(name);
        if (val != null) {
            return val;
        }
        try {
            return this.getInvoker().invoke(name);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ReflectionException(e);
        }
    }

    private Map getMethods() {
        if (this.methods != null) {
            return this.methods;
        }
        this.methods = new LinkedHashMap();
        Method[] methods = this.getMBeanClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (!name.startsWith("get")) continue;
            name = name.substring(3);
            this.methods.put(name, methods[i]);
        }
        return this.methods;
    }

    protected MBeanAttributeInfo[] getAttributeInfo() {
        String name;
        Map.Entry entry;
        Map methods = this.getMethods();
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[methods.size() + this.attrs.size()];
        int i = 0;
        Iterator it = methods.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            name = (String)entry.getKey();
            Method method = (Method)entry.getValue();
            attrs[i++] = new MBeanAttributeInfo(name, method.getReturnType().getName(), name + " MBean", true, false, false);
        }
        it = this.attrs.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            name = (String)entry.getKey();
            Object obj = entry.getValue();
            attrs[i++] = new MBeanAttributeInfo(name, obj.getClass().getName(), name + " MBean", true, false, false);
        }
        return attrs;
    }

    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = new MBeanInfo(this.getClass().getName(), this.getMBeanClassName(), this.getAttributeInfo(), null, null, null);
        return info;
    }
}

