/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.jmx;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;

public abstract class AbstractMBean
implements DynamicMBean {
    public static final String MBEAN_DOMAIN = "sigar";
    public static final String MBEAN_ATTR_TYPE = "Type";
    protected final SigarProxy sigar;

    protected AbstractMBean(SigarProxy sigar) {
        this.sigar = sigar;
    }

    public abstract String getObjectName();

    protected RuntimeException unexpectedError(String type, SigarException e) {
        String msg = "Unexected error in Sigar.get" + type + ": " + e.getMessage();
        return new IllegalArgumentException(msg);
    }

    public AttributeList getAttributes(String[] attrs) {
        AttributeList result = new AttributeList();
        for (int i = 0; i < attrs.length; ++i) {
            try {
                result.add(new Attribute(attrs[i], this.getAttribute(attrs[i])));
                continue;
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                continue;
            }
            catch (MBeanException mBeanException) {
                continue;
            }
            catch (ReflectionException reflectionException) {
                // empty catch block
            }
        }
        return result;
    }

    public AttributeList setAttributes(AttributeList attrs) {
        AttributeList result = new AttributeList();
        for (int i = 0; i < attrs.size(); ++i) {
            try {
                Attribute next = (Attribute)attrs.get(i);
                this.setAttribute(next);
                result.add(next);
                continue;
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                // empty catch block
            }
        }
        return result;
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException {
        throw new AttributeNotFoundException(attr.getName());
    }

    public Object invoke(String name, Object[] params, String[] signature) throws ReflectionException {
        throw new ReflectionException(new NoSuchMethodException(name), name);
    }
}

