/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Date;
import org.hyperic.sigar.DirStat;
import org.hyperic.sigar.FileInfo;
import org.hyperic.sigar.FileWatcher;
import org.hyperic.sigar.FileWatcherThread;
import org.hyperic.sigar.ProcFileMirror;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class Watch {
    private static void printHeader(Sigar sigar, FileInfo info) throws SigarException {
        String file = info.getName();
        FileInfo link = sigar.getLinkInfo(file);
        if (link.getType() == 6) {
            try {
                System.out.println(file + " -> " + new File(file).getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println(link.getTypeChar() + info.getPermissionsString() + "\t" + info.getUid() + "\t" + info.getGid() + "\t" + info.getSize() + "\t" + new Date(info.getMtime()) + "\t" + file);
        if (info.getType() == 2) {
            info.enableDirStat(true);
            DirStat stats = sigar.getDirStat(file);
            System.out.println("   Files......." + stats.getFiles());
            System.out.println("   Subdirs....." + stats.getSubdirs());
            System.out.println("   Symlinks...." + stats.getSymlinks());
            System.out.println("   Chrdevs....." + stats.getChrdevs());
            System.out.println("   Blkdevs....." + stats.getBlkdevs());
            System.out.println("   Sockets....." + stats.getSockets());
            System.out.println("   Total......." + stats.getTotal());
            System.out.println("   Disk Usage.." + stats.getDiskUsage());
        }
    }

    private static void add(Sigar sigar, FileWatcher watcher, String file, boolean recurse) throws SigarException {
        FileInfo info = watcher.add(file);
        Watch.printHeader(sigar, info);
        if (!recurse) {
            return;
        }
        if (info.getType() == 2) {
            File[] dirs = new File(info.getName()).listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() && file.canRead();
                }
            });
            for (int i = 0; i < dirs.length; ++i) {
                Watch.add(sigar, watcher, dirs[i].getAbsolutePath(), recurse);
            }
        }
    }

    public static void main(String[] args) throws SigarException {
        boolean recurse = false;
        Sigar sigar = new Sigar();
        FileWatcherThread watcherThread = FileWatcherThread.getInstance();
        watcherThread.setInterval(1000L);
        FileWatcher watcher = new FileWatcher(sigar){

            public void onChange(FileInfo info) {
                System.out.println(info.getName() + " Changed:\n" + info.diff());
            }

            public void onNotFound(FileInfo info) {
                System.out.println(info.getName() + " no longer exists");
                this.remove(info.getName());
            }

            public void onException(FileInfo info, SigarException e) {
                System.out.println("Error checking " + info.getName() + ":");
                e.printStackTrace();
            }
        };
        ProcFileMirror mirror = new ProcFileMirror(sigar, "./proc");
        watcher.setInterval(watcherThread.getInterval());
        mirror.setInterval(watcherThread.getInterval());
        mirror.setExpire(60L);
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("/proc/")) {
                mirror.add(arg);
                arg = mirror.getProcFile(arg);
                Watch.add(sigar, watcher, arg, false);
                continue;
            }
            if (arg.equals("-r")) {
                recurse = true;
                continue;
            }
            Watch.add(sigar, watcher, arg, recurse);
        }
        watcherThread.add(mirror);
        watcherThread.add(watcher);
        watcherThread.doStart();
        System.out.println("Press any key to stop");
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        watcherThread.doStop();
    }
}

