/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;

public class ShowArgs
extends SigarCommandBase {
    public ShowArgs(Shell shell) {
        super(shell);
    }

    public ShowArgs() {
    }

    protected boolean validateArgs(String[] args) {
        return true;
    }

    public String getUsageShort() {
        return "Show process command line arguments";
    }

    public boolean isPidCompleter() {
        return true;
    }

    public void output(String[] args) throws SigarException {
        long[] pids = this.shell.findPids(args);
        for (int i = 0; i < pids.length; ++i) {
            try {
                this.println("pid=" + pids[i]);
                this.output(pids[i]);
            }
            catch (SigarException e) {
                this.println(e.getMessage());
            }
            this.println("\n------------------------\n");
        }
    }

    public void output(long pid) throws SigarException {
        String[] argv = this.proxy.getProcArgs(pid);
        try {
            String exe = this.proxy.getProcExe(pid).getName();
            this.println("exe=" + exe);
        }
        catch (SigarNotImplementedException exe) {
        }
        catch (SigarException e) {
            this.println("exe=???");
        }
        try {
            String cwd = this.proxy.getProcExe(pid).getCwd();
            this.println("cwd=" + cwd);
        }
        catch (SigarNotImplementedException cwd) {
        }
        catch (SigarException e) {
            this.println("cwd=???");
        }
        for (int i = 0; i < argv.length; ++i) {
            this.println("   " + i + "=>" + argv[i] + "<=");
        }
    }

    public static void main(String[] args) throws Exception {
        new ShowArgs().processCommand(args);
    }
}

