/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class NetInfo
implements Serializable {
    private static final long serialVersionUID = 12688L;
    String defaultGateway = null;
    String defaultGatewayInterface = null;
    String hostName = null;
    String domainName = null;
    String primaryDns = null;
    String secondaryDns = null;

    public native void gather(Sigar var1) throws SigarException;

    static NetInfo fetch(Sigar sigar) throws SigarException {
        NetInfo netInfo = new NetInfo();
        netInfo.gather(sigar);
        return netInfo;
    }

    public String getDefaultGateway() {
        return this.defaultGateway;
    }

    public String getDefaultGatewayInterface() {
        return this.defaultGatewayInterface;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getPrimaryDns() {
        return this.primaryDns;
    }

    public String getSecondaryDns() {
        return this.secondaryDns;
    }

    void copyTo(NetInfo copy) {
        copy.defaultGateway = this.defaultGateway;
        copy.defaultGatewayInterface = this.defaultGatewayInterface;
        copy.hostName = this.hostName;
        copy.domainName = this.domainName;
        copy.primaryDns = this.primaryDns;
        copy.secondaryDns = this.secondaryDns;
    }

    public Map toMap() {
        String strsecondaryDns;
        String strprimaryDns;
        String strdomainName;
        String strhostName;
        String strdefaultGatewayInterface;
        HashMap<String, String> map = new HashMap<String, String>();
        String strdefaultGateway = String.valueOf(this.defaultGateway);
        if (!"-1".equals(strdefaultGateway)) {
            map.put("DefaultGateway", strdefaultGateway);
        }
        if (!"-1".equals(strdefaultGatewayInterface = String.valueOf(this.defaultGatewayInterface))) {
            map.put("DefaultGatewayInterface", strdefaultGatewayInterface);
        }
        if (!"-1".equals(strhostName = String.valueOf(this.hostName))) {
            map.put("HostName", strhostName);
        }
        if (!"-1".equals(strdomainName = String.valueOf(this.domainName))) {
            map.put("DomainName", strdomainName);
        }
        if (!"-1".equals(strprimaryDns = String.valueOf(this.primaryDns))) {
            map.put("PrimaryDns", strprimaryDns);
        }
        if (!"-1".equals(strsecondaryDns = String.valueOf(this.secondaryDns))) {
            map.put("SecondaryDns", strsecondaryDns);
        }
        return map;
    }

    public String toString() {
        return this.toMap().toString();
    }
}

