/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.gradle;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;

public class Logger {
    public static final int DEBUG_LEVEL = 0;
    public static final int INFO_LEVEL = 1;
    public static final int WARN_LEVEL = 2;
    public static final int ERROR_LEVEL = 3;
    private static LogPrinter printer = null;
    private static int logLevel = 1;

    public static synchronized LogPrinter getPrinter() {
        if (printer == null) {
            printer = new DefaultLogPrinter();
        }
        return printer;
    }

    public static void setLogLevel(int level) {
        logLevel = level;
    }

    public static synchronized void setPrinter(LogPrinter printer) {
        System.setProperty("file.encoding", "UTF-8");
        Logger.printer = printer;
    }

    private static String format(String format, Object ... args) {
        if (format == null) {
            return "null";
        }
        if (args == null || args.length == 0) {
            return format;
        }
        return String.format(Locale.US, format, args);
    }

    private static boolean print(int level, String format, Object ... args) {
        if (level < logLevel) {
            return true;
        }
        LogPrinter printer = Logger.getPrinter();
        String msg = Logger.format(format, args);
        switch (level) {
            case 0: {
                printer.printDebug(msg);
                return true;
            }
            case 1: {
                printer.printInfo(msg);
                return true;
            }
            case 2: {
                printer.printWarn(msg);
                return true;
            }
            case 3: {
                printer.printError(msg);
                return true;
            }
        }
        return false;
    }

    private static boolean print(int level, Throwable thr) {
        String msg = Logger.parseThrowable(thr);
        return Logger.print(level, msg, new Object[0]);
    }

    public static boolean info(String format, Object ... args) {
        return Logger.print(1, format, args);
    }

    public static boolean debug(String format, Object ... args) {
        return Logger.print(0, format, args);
    }

    public static boolean warn(String format, Object ... args) {
        return Logger.print(2, format, args);
    }

    public static boolean warn(Throwable thr) {
        return Logger.print(2, thr);
    }

    public static boolean error(String format, Object ... args) {
        return Logger.print(3, format, args);
    }

    public static boolean error(Throwable thr) {
        return Logger.print(3, thr);
    }

    public static String parseThrowable(Throwable thr) {
        if (thr == null) {
            return "";
        }
        try {
            StringWriter writer = new StringWriter();
            thr.printStackTrace(new PrintWriter(writer));
            return writer.getBuffer().toString();
        }
        catch (Throwable ex2) {
            if (!Logger.warn(ex2)) {
                ex2.printStackTrace();
            }
            return "fail";
        }
    }

    private static class DefaultLogPrinter
    extends LogPrinter {
        private DefaultLogPrinter() {
        }

        @Override
        public void printInfo(String msg) {
            if (this.infoTag != null) {
                System.out.print(this.infoTag);
            }
            System.out.println(msg);
        }

        @Override
        public void printDebug(String msg) {
            if (this.debugTag != null) {
                System.out.print(this.debugTag);
            }
            System.out.println(msg);
        }

        @Override
        public void printWarn(String msg) {
            if (this.warnTag != null) {
                System.out.print(this.warnTag);
            }
            System.out.println(msg);
        }

        @Override
        public void printError(String msg) {
            if (this.errorTag != null) {
                System.out.print(this.errorTag);
            }
            System.out.println(msg);
        }
    }

    public static abstract class LogPrinter {
        public String infoTag = "[Bugly Plugin] <Info> ";
        public String debugTag = "[Bugly Plugin] <Debug> ";
        public String warnTag = "[Bugly Plugin] <Warn> ";
        public String errorTag = "[Bugly Plugin] <Error> ";

        public abstract void printInfo(String var1);

        public abstract void printDebug(String var1);

        public abstract void printWarn(String var1);

        public abstract void printError(String var1);
    }
}

