/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rmonitor.looper;

import android.content.Context;
import com.tencent.bugly.common.reporter.IReporter;
import com.tencent.bugly.common.reporter.data.ReportData;
import com.tencent.bugly.common.reporter.data.ReportStrategy;
import com.tencent.bugly.common.thread.ThreadManager;
import com.tencent.bugly.proguard.bm;
import com.tencent.bugly.proguard.bq;
import com.tencent.bugly.proguard.cj;
import com.tencent.bugly.proguard.hs;
import com.tencent.bugly.proguard.hz;
import com.tencent.bugly.proguard.ip;
import com.tencent.bugly.proguard.kf;
import com.tencent.bugly.proguard.ph;
import com.tencent.rmonitor.base.db.DBDataStatus;
import com.tencent.rmonitor.base.db.DBHandler;
import com.tencent.rmonitor.base.db.DBHelper;
import com.tencent.rmonitor.base.db.table.ReportDataTable;
import com.tencent.rmonitor.base.meta.BaseInfo;
import com.tencent.rmonitor.base.meta.LooperMeta;
import com.tencent.rmonitor.base.plugin.listener.ListenerManager;
import com.tencent.rmonitor.base.plugin.monitor.PluginController;
import com.tencent.rmonitor.base.reporter.ReporterMachine;
import com.tencent.rmonitor.common.logger.Logger;
import com.tencent.rmonitor.common.util.AppInfo;
import com.tencent.rmonitor.common.util.FileUtil;
import com.tencent.rmonitor.looper.LooperConfig;
import com.tencent.rmonitor.looper.MonitorInfo;
import com.tencent.rmonitor.sla.AttaEvent;
import com.tencent.rmonitor.sla.AttaEventReporter;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/tencent/rmonitor/looper/LooperReport;", "", "()V", "COLLECT_STACK_MSG_MAX_DELAY", "", "HAS_FULL_STACK", "", "LONG_LAG_LIMIT", "MAX_LONG_LAG_MAP_SIZE", "", "NO_FULL_STACK", "TAG", "longLagMap", "Ljava/util/HashMap;", "Lcom/tencent/bugly/common/reporter/data/ReportData;", "Lkotlin/collections/HashMap;", "buildReportData", "monitorInfo", "Lcom/tencent/rmonitor/looper/MonitorInfo;", "cancelCachedReportData", "", "reportData", "checkValid", "", "dealLongLag", "gotoReport", "gotoReportInner", "realReport", "reportSLA", "bugly-pro_release"})
public final class LooperReport {
    private static final String TAG = "RMonitor_lag_report";
    private static final long COLLECT_STACK_MSG_MAX_DELAY = 20L;
    private static final String NO_FULL_STACK = "0";
    private static final String HAS_FULL_STACK = "1";
    private static final long LONG_LAG_LIMIT = 5000L;
    private static final int MAX_LONG_LAG_MAP_SIZE = 20;
    private static final HashMap<Long, ReportData> longLagMap;
    public static final LooperReport INSTANCE;

    public final boolean gotoReport(@NotNull MonitorInfo monitorInfo) {
        Intrinsics.checkParameterIsNotNull((Object)monitorInfo, (String)"monitorInfo");
        boolean bl2 = false;
        if (monitorInfo.getFullStack() != null) {
            bl2 = this.gotoReportInner(monitorInfo);
        }
        this.reportSLA(monitorInfo);
        return bl2;
    }

    private final void reportSLA(MonitorInfo monitorInfo) {
        Object object = "RMLooperStackCollectStack";
        if (!ph.iJ().bp((String)object)) {
            return;
        }
        object = new AttaEvent((String)object);
        double d2 = monitorInfo.getAvgCollectStackMsgCost();
        ((AttaEvent)object).setParam0(String.valueOf(d2));
        long l2 = monitorInfo.getAvgCollectStackMsgDelay();
        ((AttaEvent)object).setParam1(String.valueOf(l2));
        int n2 = monitorInfo.getCollectStackMsgCount();
        ((AttaEvent)object).setParam2(String.valueOf(n2));
        ((AttaEvent)object).setParam3(String.valueOf(monitorInfo.getDuration()));
        ((AttaEvent)object).setEventCost((int)monitorInfo.getDuration());
        if (monitorInfo.getFullStack() == null) {
            ((AttaEvent)object).setParam4(NO_FULL_STACK);
        } else {
            ((AttaEvent)object).setParam4(HAS_FULL_STACK);
        }
        bm bm2 = bm.ak();
        Intrinsics.checkExpressionValueIsNotNull((Object)bm2, (String)"PrivacyInformation.getInstance()");
        String string = bm2.aj();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PrivacyInformation.getInstance().osVersion");
        ((AttaEvent)object).setParam5(string);
        bm bm3 = bm.ak();
        Intrinsics.checkExpressionValueIsNotNull((Object)bm3, (String)"PrivacyInformation.getInstance()");
        String string2 = bm3.ai();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PrivacyInformation.getInstance().manufacture");
        ((AttaEvent)object).setParam6(string2);
        bm bm4 = bm.ak();
        Intrinsics.checkExpressionValueIsNotNull((Object)bm4, (String)"PrivacyInformation.getInstance()");
        String string3 = bm4.getModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"PrivacyInformation.getInstance().model");
        ((AttaEvent)object).setParam7(string3);
        ((AttaEvent)object).setParam8(String.valueOf(monitorInfo.getQuickTraceFlag()));
        double d3 = d2 / 1000.0 + (double)l2;
        ((AttaEvent)object).setEventResult(d3 > 20.0 ? 0 : 1);
        AttaEventReporter.Companion.getInstance().addEvent((AttaEvent)object);
    }

    private final void dealLongLag(MonitorInfo monitorInfo, ReportData object) {
        if (monitorInfo.isDetectedLongLag()) {
            if (longLagMap.size() >= 20) {
                longLagMap.clear();
            }
            ((Map)longLagMap).put(monitorInfo.getLastStackRequestTime(), object);
            ((ReportData)object).getReportStrategy().setUploadStrategy(ReportStrategy.UploadStrategy.UPLOAD_NEXT_LAUNCH);
            if (Logger.verbos) {
                String string = ((ReportData)object).getParams().optString("client_identify");
                Logger.INSTANCE.v(TAG, "record unfinished long lag clientIdentify, duration: " + monitorInfo.getDuration() + ", requestTime: " + monitorInfo.getLastStackRequestTime() + ", clientIdentify: " + string);
                return;
            }
        } else if (monitorInfo.getDuration() >= 5000L) {
            ReportData reportData = longLagMap.remove(monitorInfo.getLastStackRequestTime());
            if (reportData != null) {
                this.cancelCachedReportData(reportData);
            }
            if (Logger.verbos) {
                object = ((ReportData)object).getParams().optString("client_identify");
                Logger.INSTANCE.v(TAG, "deal finished long lag clientIdentify, duration: " + monitorInfo.getDuration() + ", requestTime: " + monitorInfo.getLastStackRequestTime() + ", clientIdentify: " + (String)object);
            }
        }
    }

    private final void cancelCachedReportData(ReportData object) {
        long l2 = ((ReportData)object).getDbId() == 0 ? 1000L : 200L;
        object = new Runnable((ReportData)object){
            final /* synthetic */ ReportData $reportData;

            public final void run() {
                Object object;
                if (this.$reportData.getDbId() > 0 && (object = BaseInfo.dbHelper) != null && (object = ((DBHelper)((Object)object)).getDbHandler()) != null) {
                    ((DBHandler)object).updateStatus(ReportDataTable.Companion.getTableName(), this.$reportData.getDbId(), DBDataStatus.SENT.getValue());
                }
                if (Logger.debug) {
                    String string = this.$reportData.getParams().optString("client_identify");
                    Logger.INSTANCE.d("RMonitor_lag_report", "deal cached report data, clientIdentify: ".concat(String.valueOf(string)));
                }
            }
            {
                this.$reportData = reportData;
            }
        };
        ThreadManager.Companion.runInMonitorThread((Runnable)object, l2);
    }

    private final boolean gotoReportInner(MonitorInfo monitorInfo) {
        ReportData reportData = this.buildReportData(monitorInfo);
        this.dealLongLag(monitorInfo, reportData);
        if (this.checkValid(monitorInfo)) {
            return this.realReport(reportData, monitorInfo);
        }
        new ip().e(reportData);
        return false;
    }

    private final boolean realReport(ReportData reportData, MonitorInfo monitorInfo) {
        boolean bl2 = false;
        try {
            new LooperMeta(reportData.getParams(), monitorInfo.getThreadId(), monitorInfo.getThreadName());
            Iterator iterator = ((Iterable)ListenerManager.looperListener.getListenerList()).iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
            if (PluginController.INSTANCE.whetherPluginReportSampling("looper_stack")) {
                IReporter.DefaultImpls.a(ReporterMachine.INSTANCE, reportData);
            } else if (Logger.verbos) {
                Logger.INSTANCE.v(TAG, "miss report for sampling. [ThreadName: " + monitorInfo.getThreadName() + ", CostInMs: " + monitorInfo.getDuration() + ", Scene: " + monitorInfo.getScene() + ", Foreground: " + monitorInfo.isAppInForeground() + ']');
            }
            bl2 = true;
        }
        catch (Throwable throwable) {
            Logger.INSTANCE.w(TAG, "looper data may be error, " + throwable.getMessage());
        }
        return bl2;
    }

    private final ReportData buildReportData(MonitorInfo object) {
        Object object2 = bq.aq();
        object2.put("process_name", (Object)AppInfo.Companion.gl());
        object2.put("time_cost", ((MonitorInfo)object).getDuration());
        object2.put("stage", (Object)((MonitorInfo)object).getScene());
        object2.put("stack_interval", ((MonitorInfo)object).getLagParam().CO);
        object2.put("start_time", ((MonitorInfo)object).getLastStackRequestTime());
        object2.put("monitored_thread_name", (Object)((MonitorInfo)object).getThreadName());
        object2.put("app_in_foreground", ((MonitorInfo)object).isAppInForeground());
        object2.put("detect_strategy", (Object)((MonitorInfo)object).getLagParam().xj);
        kf.gx();
        kf.a(false, "looper_stack", ((MonitorInfo)object).getScene(), (JSONObject)object2);
        kf.gx();
        kf.p((JSONObject)object2);
        JSONObject jSONObject = null;
        if (object2.has("biz_extend_info")) {
            jSONObject = object2.getJSONObject("biz_extend_info");
        }
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        jSONObject.put("detect_strategy", (Object)((MonitorInfo)object).getLagParam().xj);
        object2.put("biz_extend_info", (Object)jSONObject);
        jSONObject = cj.aP().c(((MonitorInfo)object).getLastStackRequestTime() - 1000L, ((MonitorInfo)object).getLastStackRequestTime() + ((MonitorInfo)object).getDuration());
        object2.put("gc_info", (Object)jSONObject);
        jSONObject = bq.a((Context)BaseInfo.app, "looper", "looper_stack", BaseInfo.userMeta);
        jSONObject.put("Attributes", object2);
        long l2 = ((MonitorInfo)object).getLastStackRequestTime() + ((MonitorInfo)object).getDuration();
        long l3 = l2 / 1000L;
        jSONObject.put("event_time_in_ms", l2);
        jSONObject.put("event_time", l3);
        String string = BaseInfo.userMeta.uin;
        JSONObject jSONObject2 = jSONObject;
        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject2, (String)"params");
        object2 = new ReportData(string, 1, "Looper single", jSONObject2);
        ((ReportData)object2).setShouldRecordLinkData(true);
        if (((MonitorInfo)object).checkUseFileToTransStacks()) {
            String string2 = FileUtil.Companion.makeTempFileName("rmonitor_trace", "json");
            File file = new File(FileUtil.Companion.getTempPath(), string2);
            object = String.valueOf(((MonitorInfo)object).getFullStack());
            FileUtil.Companion.writeFile(file.getAbsolutePath(), (String)object, false);
            String string3 = file.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"file.absolutePath");
            ((ReportData)object2).addFile(string3, true, true);
            object = new JSONObject();
            object.put("file_stacks", (Object)string2);
            jSONObject.put("Body", object);
        } else {
            jSONObject.put("Body", (Object)((MonitorInfo)object).getFullStack());
        }
        return object2;
    }

    private final boolean checkValid(MonitorInfo monitorInfo) {
        hs hs2;
        hz hz2 = LooperConfig.INSTANCE.getPluginConfig("looper_stack");
        if (!(hz2 instanceof hs)) {
            hz2 = null;
        }
        if ((hs2 = (hs)hz2) == null || !hs2.fw()) {
            return true;
        }
        long l2 = monitorInfo.getDuration();
        if (l2 > hs2.fz()) {
            Logger.INSTANCE.i(TAG, "not valid sample for " + l2 + " exceed " + hs2.fz());
            return false;
        }
        int n2 = monitorInfo.getCollectStackMsgCount();
        long l3 = monitorInfo.getLagParam().CO;
        long l4 = l2 - l3 * (long)n2;
        long l5 = hs2.fy();
        long l6 = l3 + (long)n2 * l5;
        int n3 = hs2.fx();
        n3 = n2 >= n3 || l4 <= l6 ? 1 : 0;
        if (n3 == 0) {
            Logger.INSTANCE.i(TAG, "not valid sample for {totalCost: " + l2 + ", sliceCount: " + n2 + ", stackInterval: " + l3 + ", delay: " + l4 + ", delayLimit: " + l6 + '}');
        }
        return n3 != 0;
    }

    private LooperReport() {
    }

    static {
        INSTANCE = new LooperReport();
        longLagMap = new HashMap(20);
    }
}

