/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.library;

import android.content.Context;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.bugly.common.replay.BuglyReplayOptions;
import com.tencent.bugly.common.reporter.data.ReportStrategy;
import com.tencent.bugly.common.utils.ProcessUtil;
import com.tencent.bugly.library.BuglyBuilder;
import com.tencent.bugly.library.BuglyConstants;
import com.tencent.bugly.library.MonitorCallback;
import com.tencent.bugly.proguard.az;
import com.tencent.bugly.proguard.cf;
import com.tencent.bugly.proguard.dc;
import com.tencent.bugly.proguard.eh;
import com.tencent.bugly.proguard.fi;
import com.tencent.bugly.proguard.fj;
import com.tencent.bugly.proguard.gp;
import com.tencent.bugly.proguard.gw;
import com.tencent.bugly.proguard.hh;
import com.tencent.bugly.proguard.hi;
import com.tencent.bugly.proguard.hj;
import com.tencent.bugly.proguard.hk;
import com.tencent.bugly.proguard.hp;
import com.tencent.bugly.proguard.jp;
import com.tencent.bugly.proguard.jq;
import com.tencent.bugly.proguard.kb;
import com.tencent.bugly.proguard.ke;
import com.tencent.bugly.proguard.mz;
import com.tencent.bugly.proguard.ni;
import com.tencent.bugly.proguard.nj;
import com.tencent.bugly.proguard.nu;
import com.tencent.bugly.proguard.nv;
import com.tencent.bugly.proguard.nw;
import com.tencent.bugly.proguard.pj;
import com.tencent.bugly.proguard.q;
import com.tencent.bugly.proguard.r;
import com.tencent.rmonitor.base.plugin.listener.ICustomDataCollector;
import com.tencent.rmonitor.base.plugin.listener.ICustomDataCollectorForIssue;
import com.tencent.rmonitor.base.reporter.ReporterMachine;
import com.tencent.rmonitor.common.lifecycle.LifecycleCallback;
import com.tencent.rmonitor.common.logger.ILogProxy;
import com.tencent.rmonitor.common.logger.Logger;
import com.tencent.rmonitor.custom.ICustomDataEditor;
import com.tencent.rmonitor.manager.RMonitorLauncher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class Bugly
implements BuglyConstants {
    private static fi qH = null;

    public static boolean init(Context context, BuglyBuilder buglyBuilder) {
        return Bugly.init(context, buglyBuilder, ProcessUtil.isMainProcess(context));
    }

    public static boolean init(Context context, BuglyBuilder buglyBuilder, boolean bl2) {
        if (context == null) {
            Log.e((String)"Bugly_Init", (String)"Bugly init failed, please make sure context not null.");
            return false;
        }
        if (buglyBuilder == null) {
            Log.e((String)"Bugly_Init", (String)"Bugly init failed, please make sure Bugly builder not null.");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)buglyBuilder.serverHostType) && !q.f(buglyBuilder.serverHostType)) {
            Log.e((String)"Bugly_Init", (String)"Bugly init failed, please make sure serverHostType is valid.");
            return false;
        }
        long l2 = SystemClock.uptimeMillis();
        cf.f(context);
        context = cf.aI();
        r.a(buglyBuilder.cacheDataIntervalMs);
        BuglyBuilder buglyBuilder2 = buglyBuilder;
        Object object = context;
        if ("foreground".equals(buglyBuilder2.initAppState) || "background".equals(buglyBuilder2.initAppState)) {
            LifecycleCallback.initAppState(buglyBuilder2.initAppState);
        }
        Logger.INSTANCE.w("RMonitor_init", "initJsonProtocol");
        gp.eI();
        Logger.INSTANCE.w("RMonitor_init", "initConfig");
        hp.a.fr().a(new dc());
        hp.a.fr().a(new hi());
        hp.a.fr().a(new hj());
        hp.a.fr().a(new hh());
        hp.a.fr().a(new hk());
        hp.a.fr().a(new az());
        Logger.INSTANCE.w("RMonitor_init", "initPluginFactory");
        RMonitorLauncher.INSTANCE.setPluginFactory(new fj());
        mz.p((Context)object, buglyBuilder2.appId);
        object = buglyBuilder.getEmergencyReportPlugins();
        if (object != null && ((ArrayList)object).size() > 0) {
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                ReportStrategy.Companion.w(string);
            }
        }
        gp.n(context, buglyBuilder.appVersion);
        gp.k(context, buglyBuilder.userId);
        gp.l(context, buglyBuilder.uniqueId);
        gp.setRdmUuid(buglyBuilder.buildNumber);
        gp.m(context, buglyBuilder.deviceModel);
        gp.a(context, buglyBuilder.enableAllThreadStackCrash, buglyBuilder.enableAllThreadStackAnr);
        gp.setAppKey(buglyBuilder.appKey);
        gp.setAppVersionMode(buglyBuilder.appVersionType);
        gp.e(buglyBuilder.fetchConfigFromServerInSubProcess);
        gp.a(context, buglyBuilder.appId, buglyBuilder.debugMode, buglyBuilder.qJ);
        gp.o(context, buglyBuilder.appChannel);
        gp.aw(buglyBuilder.hotPatchNum);
        object = pj.iM();
        pj.iM().GO = true;
        ((pj)object).GN = true;
        ((pj)object).handler.removeMessages(1);
        ((pj)object).handler.removeMessages(2);
        Logger.INSTANCE.i("RMonitor_metric_sla_Helper", "disable metric and sla.");
        gw.a(107, context);
        gw.f(100, buglyBuilder.appKey);
        gw.f(101, buglyBuilder.appId);
        gw.f(103, buglyBuilder.appVersion);
        gw.f(109, buglyBuilder.buildNumber);
        gw.f(102, buglyBuilder.userId);
        gw.f(106, buglyBuilder.uniqueId);
        gw.f(113, buglyBuilder.deviceModel);
        gw.a(104, buglyBuilder.logLevel);
        gw.f(112, buglyBuilder.appVersionType);
        gw.a(214, buglyBuilder.enableCrashProtect);
        gw.a(111, buglyBuilder.spProvider);
        object = buglyBuilder.qI;
        if (bl2) {
            object.remove("sub_memory_quantile");
        } else {
            object.remove("memory_quantile");
        }
        gw.q((List<String>)object);
        long l3 = SystemClock.uptimeMillis();
        eh.a(l2, l3, true);
        return gp.eF() && kb.gn();
    }

    public static void updateUniqueId(Context context, String string) {
        if (!gp.eF() || !kb.gn()) {
            Log.e((String)"Bugly_Init", (String)"update unique id failed, pls init monitor first!");
            return;
        }
        gp.l(context, string);
        gw.f(106, string);
    }

    public static String getUniqueId() {
        if (!gp.eF() || !kb.gn()) {
            Log.e((String)"Bugly_Init", (String)"get unique id failed, pls init monitor first!");
            return "";
        }
        return gp.getDeviceId();
    }

    public static void updateUserId(Context context, String string) {
        if (!gp.eF() || !kb.gn()) {
            Log.e((String)"Bugly_Init", (String)"update user id failed, pls init monitor first!");
            return;
        }
        gp.k(context, string);
        gw.f(102, string);
    }

    public static void setUserInfoReportOpt(boolean bl2) {
        gp.setUserInfoReportOpt(bl2);
    }

    public static void setForegroundUserInfoReport(boolean bl2, long l2) {
        if (!gp.eF() || !kb.gn()) {
            Log.e((String)"Bugly_Init", (String)"setForegroundUserInfoReport failed, pls init monitor first!");
            return;
        }
        gp.setForegroundUserInfoReport(bl2, l2);
    }

    public static boolean reRegisterHandler() {
        if (!gp.eF() || !kb.gn()) {
            Log.e((String)"Bugly_Init", (String)"reRegisterHandler failed, pls init monitor first!");
            return false;
        }
        return gp.reRegisterHandler();
    }

    public static void updateDeviceModel(Context context, String string) {
        if (!gp.eF() || !kb.gn()) {
            Log.e((String)"Bugly_Init", (String)"update device model failed, pls init monitor first!");
            return;
        }
        gp.m(context, string);
        gw.f(113, string);
    }

    public static void updateAppChannel(Context context, String string) {
        if (!gp.eF() || !kb.gn()) {
            Log.e((String)"Bugly_Init", (String)"update app channel failed, pls init monitor first!");
            return;
        }
        gp.o(context, string);
    }

    public static void updateLogLevel(int n2) {
        if (!kb.gn()) {
            Log.e((String)"Bugly_Init", (String)"update log level failed, pls init monitor first!");
            return;
        }
        gw.a(104, n2);
    }

    public static void startInspectLeakObj(Object object) {
        if (!kb.gn()) {
            Log.e((String)"Bugly_Init", (String)"start inspect leak obj failed, pls init monitor first!");
            return;
        }
        nj.a(object, new ni());
    }

    public static void postException(Thread thread, int n2, String string, String string2, String string3, Map<String, String> map) {
        if (!gp.eF()) {
            Log.e((String)"Bugly_Init", (String)"post Exception failed, pls init monitor first!");
            return;
        }
        gp.postException(thread, n2, string, string2, string3, map);
    }

    public static void postException(int n2, String string, String string2, String string3, Map<String, String> map) {
        if (!gp.eF()) {
            Log.e((String)"Bugly_Init", (String)"post Exception failed, pls init monitor first!");
            return;
        }
        gp.postException(Thread.currentThread(), n2, string, string2, string3, map);
    }

    public static boolean handleCatchException(Thread thread, Throwable throwable, String string, byte[] byArray, boolean bl2) {
        if (!gp.eF()) {
            Log.e((String)"Bugly_Init", (String)"handle catch exception failed, pls init monitor first!");
            return false;
        }
        return gp.handleCatchException(thread, throwable, string, byArray, bl2);
    }

    public static boolean handleCatchException(Thread thread, Throwable throwable, String string, byte[] byArray) {
        if (!gp.eF()) {
            Log.e((String)"Bugly_Init", (String)"handle catch exception failed, pls init monitor first!");
            return false;
        }
        return gp.handleCatchException(thread, throwable, string, byArray, true);
    }

    public static void putUserData(Context context, String string, String string2) {
        if (!gp.eF()) {
            Log.e((String)"Bugly_Init", (String)"put user data failed, pls init monitor first!");
            return;
        }
        gp.putUserData(context, string, string2);
    }

    public static String removeUserData(Context context, String string) {
        if (!gp.eF()) {
            Log.e((String)"Bugly_Init", (String)"remove user data failed, pls init monitor first!");
            return null;
        }
        return gp.removeUserData(context, string);
    }

    public static boolean setAdditionalAttachmentPaths(String[] stringArray) {
        if (!gp.eF()) {
            Log.e((String)"Bugly_Init", (String)"set additional attachment paths failed, pls init monitor first!");
            return false;
        }
        return gp.setAdditionalAttachmentPaths(stringArray);
    }

    public static void enterScene(String object) {
        if (!kb.gn()) {
            Log.e((String)"Bugly_Init", (String)"enter scene failed, pls init monitor first!");
            return;
        }
        String string = object;
        object = jp.gc();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            ((jp)object).zz = string;
            ((jp)object).aJ(string);
            Iterator<jq> iterator = ((jp)object).zv.iterator();
            while (iterator.hasNext()) {
                iterator.next().onEnterScene(string);
            }
            ((jp)object).gd();
        }
    }

    public static void exitScene(String object) {
        if (!kb.gn()) {
            Log.e((String)"Bugly_Init", (String)"exit scene failed, pls init monitor first!");
            return;
        }
        String string = object;
        object = jp.gc();
        if (string == null || string.equals(((jp)object).zz)) {
            ((jp)object).zz = "";
            if (!TextUtils.isEmpty((CharSequence)((jp)object).zy)) {
                Object object2 = object;
                ((jp)object2).aJ(((jp)object2).zy);
            }
            Iterator<jq> iterator = ((jp)object).zv.iterator();
            while (iterator.hasNext()) {
                iterator.next().onExitScene(string);
            }
            ((jp)object).gd();
        }
    }

    public static void setCaseLabels(String string) {
        if (!gp.eF()) {
            Log.e((String)"Bugly_Init", (String)"set case labels fail, pls init bugly first!");
            return;
        }
        gp.setCaseLabels(string);
    }

    public static void setTestLabels(String string) {
        if (!gp.eF()) {
            Log.e((String)"Bugly_Init", (String)"set test labels fail, pls init bugly first!");
            return;
        }
        gp.setTestLabels(string);
    }

    public static boolean monitorEvent(String string, Map<String, Double> map, Map<String, String> map2) {
        return Bugly.monitorEvent(System.currentTimeMillis(), string, map, map2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean monitorEvent(long l2, String object, Map<String, Double> object2, Map<String, String> object3) {
        boolean bl2;
        if (!kb.gn()) {
            Log.e((String)"Bugly_Init", (String)"monitor event failed, pls init monitor first!");
            return false;
        }
        Object object5 = object;
        object5 = object2;
        object2 = object3;
        object = object5;
        Object object6 = object4;
        long l3 = l2;
        nw nw2 = nw.hT();
        if (1 == nw2.Em) {
            return false;
        }
        Object object7 = object2;
        object3 = object;
        object2 = object6;
        long l4 = l3;
        object = nw2;
        if (TextUtils.isEmpty((CharSequence)object2) || ((String)object2).length() > 64) {
            Logger.INSTANCE.d("RMonitor_CustomEvent", String.format("event_name{%s} is invalid", object2));
            return false;
        }
        Iterator iterator = object3;
        Object object8 = object;
        if (iterator != null) {
            nu nu2;
            int n2 = iterator.size();
            nv nv2 = ((nw)object8).En;
            int n3 = 50;
            if (nv2 != null && (nu2 = nv2.Eg) != null) {
                n3 = nu2.Ec;
            }
            if (n2 > n3) {
                Logger.INSTANCE.d("RMonitor_CustomEvent", String.format("size of metrics is over limit {%d}", iterator.size()));
                return false;
            }
            for (Map.Entry entry : iterator.entrySet()) {
                String string = (String)entry.getKey();
                if (TextUtils.isEmpty((CharSequence)string) || string.length() > 64) {
                    Logger.INSTANCE.d("RMonitor_CustomEvent", String.format("key{%s} is invalid", string));
                    return false;
                }
                Double d2 = (Double)entry.getValue();
                if (d2 == null) {
                    Logger.INSTANCE.d("RMonitor_CustomEvent", String.format("value of key{%s} is null", string));
                    return false;
                }
                if (!d2.isInfinite() && !d2.isNaN()) continue;
                Logger.INSTANCE.d("RMonitor_CustomEvent", String.format("value of key{%s} is invalid", string));
                return false;
            }
        }
        boolean bl3 = true;
        if (!bl3) {
            return false;
        }
        iterator = object7;
        Object object9 = object;
        if (iterator != null) {
            nu nu3;
            int n4 = iterator.size();
            nv nv3 = ((nw)object9).En;
            int n5 = 50;
            if (nv3 != null && (nu3 = nv3.Eg) != null) {
                n5 = nu3.Eb;
            }
            if (n4 > n5) {
                Logger.INSTANCE.d("RMonitor_CustomEvent", String.format("size of dimensions is over limit {%d}", iterator.size()));
                return false;
            }
            for (Map.Entry entry : iterator.entrySet()) {
                String string = (String)entry.getKey();
                if (TextUtils.isEmpty((CharSequence)string) || string.length() > 64) {
                    Logger.INSTANCE.d("RMonitor_CustomEvent", String.format("key{%s} is invalid", string));
                    return false;
                }
                String string2 = (String)entry.getValue();
                if (!TextUtils.isEmpty((CharSequence)string2) && string2.length() <= 256) continue;
                Logger.INSTANCE.d("RMonitor_CustomEvent", String.format("value{%s} of key{%s} is invalid", string2, string));
                return false;
            }
        }
        boolean bl4 = true;
        if (!bl4) {
            return false;
        }
        Object object10 = object = nw.a(l4, (String)object2, object3, (Map<String, String>)object7);
        if (object10 == null) {
            return false;
        }
        if (nw2.Em == 0) {
            object2 = nw2;
            if (ReporterMachine.INSTANCE.isStart()) {
                object3 = RMonitorLauncher.INSTANCE.getPlugin("custom_event", false);
                if (object3 instanceof nv) {
                    ((nw)object2).a((nv)object3, true);
                } else {
                    ((nw)object2).a(null, false);
                }
            } else {
                if (((nw)object2).El == 0L) {
                    ((nw)object2).El = System.currentTimeMillis();
                }
                if (Math.abs(System.currentTimeMillis() - ((nw)object2).El) > 1800000L) {
                    ((nw)object2).a(null, false);
                }
            }
        }
        if (bl2 = nw2.a((String)object6, (JSONObject)object)) {
            Logger.INSTANCE.d("RMonitor_CustomEvent", String.format("event_name{%s} is appended/cached.", object6));
            return bl2;
        } else {
            Logger.INSTANCE.d("RMonitor_CustomEvent", String.format("event_name{%s} is discarded.", object6));
        }
        return bl2;
    }

    public static ICustomDataEditor getGlobalCustomDataEditor() {
        if (!kb.gn()) {
            Log.e((String)"Bugly_Init", (String)"get global custom data editor failed, pls init monitor first!");
            return null;
        }
        return ke.gw();
    }

    public static void addCustomDataCollector(ICustomDataCollector iCustomDataCollector) {
        if (!kb.gn()) {
            Log.e((String)"Bugly_Init", (String)"add custom data collector failed, pls init monitor first!");
            return;
        }
        gw.b(216, iCustomDataCollector);
    }

    public static void addCustomDataCollector(ICustomDataCollectorForIssue iCustomDataCollectorForIssue) {
        if (!kb.gn()) {
            Log.e((String)"Bugly_Init", (String)"add custom data collector failed, pls init monitor first!");
            return;
        }
        gw.b(217, iCustomDataCollectorForIssue);
    }

    public static void removeCustomDataCollector(ICustomDataCollector iCustomDataCollector) {
        if (!kb.gn()) {
            Log.e((String)"Bugly_Init", (String)"remove custom data collector failed, pls init monitor first!");
            return;
        }
        gw.c(216, iCustomDataCollector);
    }

    public static void removeCustomDataCollector(ICustomDataCollectorForIssue iCustomDataCollectorForIssue) {
        if (!kb.gn()) {
            Log.e((String)"Bugly_Init", (String)"remove custom data collector failed, pls init monitor first!");
            return;
        }
        gw.c(217, iCustomDataCollectorForIssue);
    }

    public static void setMonitorCallback(String object, MonitorCallback monitorCallback) {
        if ("fps".equals(object)) {
            object = qH;
            if (object == null) {
                object = new fi();
                qH = object;
            }
            ((fi)object).a(monitorCallback);
        }
    }

    public static boolean checkAllPluginStarted(List<String> list) {
        if (!kb.gn()) {
            Log.e((String)"Bugly_Init", (String)"check plugin started failed, pls init monitor first!");
            return false;
        }
        return RMonitorLauncher.INSTANCE.checkAllDesiredPluginStarted(list);
    }

    public static boolean enableHookJavaStackTrace(boolean bl2) {
        if (!gp.eF()) {
            Log.e((String)"Bugly_Init", (String)"enable hook java stack trace failed, pls init first!");
            return false;
        }
        return gp.enableHookJavaStackTrace(bl2);
    }

    public static void setSdkLogProxy(ILogProxy iLogProxy) {
        gp.setSdkLogProxy(iLogProxy);
    }

    public static void setCrashMonitorAble(int n2, boolean bl2) {
        if (!gp.eF()) {
            Log.e((String)"Bugly_Init", (String)"set crash monitor able failed, pls init monitor first!");
            return;
        }
        switch (n2) {
            case 100: {
                gp.x(bl2);
                return;
            }
            case 101: {
                gp.y(bl2);
                return;
            }
            case 102: {
                gp.z(bl2);
                return;
            }
        }
        Log.e((String)"Bugly_Init", (String)"Crash monitor able set failed, please check crash type.");
    }

    public static void setPerformanceMonitorsAble(List<String> list, boolean bl2) {
        if (!kb.gn()) {
            Log.e((String)"Bugly_Init", (String)"set performance monitors able failed, pls init monitor first!");
            return;
        }
        if (bl2) {
            gw.q(list);
            return;
        }
        gw.r(list);
    }

    public static void setPerformanceMonitorAble(String string, boolean bl2) {
        if (!kb.gn()) {
            Log.e((String)"Bugly_Init", (String)"set performance monitors able failed, pls init monitor first!");
            return;
        }
        if (bl2) {
            gw.q(Collections.singletonList(string));
            return;
        }
        gw.r(Collections.singletonList(string));
    }

    public static void abolishPerformanceMonitors() {
        if (!kb.gn()) {
            Log.e((String)"Bugly_Init", (String)"abolish monitors failed, pls init monitor first!");
            return;
        }
        gw.abolish();
    }

    public static BuglyReplayOptions getReplayOptions() {
        if (!gp.eF()) {
            Log.e((String)"Bugly_Init", (String)"get replay options failed, pls init bugly first!");
            return null;
        }
        return gp.getReplayOptions();
    }

    public static void testCrash(int n2) {
        if (!gp.eF()) {
            Log.e((String)"Bugly_Init", (String)"test crash failed, pls init monitor first!");
            return;
        }
        switch (n2) {
            case 100: {
                gp.eG();
                return;
            }
            case 101: {
                gp.da();
                return;
            }
            case 102: {
                gp.eH();
                return;
            }
        }
        Log.e((String)"Bugly_Init", (String)"test crash failed, please check crash type.");
    }
}

