/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.common.utils;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import com.tencent.bugly.common.utils.AndroidVersion;
import com.tencent.rmonitor.common.logger.Logger;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/tencent/bugly/common/utils/ProcessUtil;", "", "()V", "Companion", "bugly-pro_release"})
public final class ProcessUtil {
    @NotNull
    public static final String TAG = "Bugly_ProcessUtil";
    private static String currProcessName;
    public static final Companion Companion;

    static {
        Companion = new Companion(0);
        currProcessName = "";
    }

    @JvmStatic
    @NotNull
    public static final String getProcessNameByCmdLine(int n2) {
        return com.tencent.bugly.common.utils.ProcessUtil$Companion.getProcessNameByCmdLine(n2);
    }

    @JvmStatic
    @Nullable
    public static final String getProcessNameByCmdLineInner(int n2) {
        return com.tencent.bugly.common.utils.ProcessUtil$Companion.getProcessNameByCmdLineInner(n2);
    }

    @JvmStatic
    @NotNull
    public static final String getCurrentProcessName(@Nullable Context context) {
        return com.tencent.bugly.common.utils.ProcessUtil$Companion.aS();
    }

    @JvmStatic
    public static final boolean isMainProcess(@Nullable Context context) {
        return com.tencent.bugly.common.utils.ProcessUtil$Companion.isMainProcess(context);
    }

    @JvmStatic
    @SuppressLint(value={"NewApi"})
    public static final boolean is64BitProcess(@NotNull Context context) {
        return com.tencent.bugly.common.utils.ProcessUtil$Companion.is64BitProcess(context);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\b\u0010\t\u001a\u00020\u0004H\u0003J\b\u0010\n\u001a\u00020\u0004H\u0003J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\u0011\u001a\u00020\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/tencent/bugly/common/utils/ProcessUtil$Companion;", "", "()V", "TAG", "", "currProcessName", "getCurrentProcessName", "context", "Landroid/content/Context;", "getCurrentProcessNameByActivityThread", "getCurrentProcessNameByApplication", "getProcessNameByCmdLine", "pid", "", "getProcessNameByCmdLineInner", "is64BitProcess", "", "isMainProcess", "bugly-pro_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public static String getProcessNameByCmdLine(int n2) {
            String string = com.tencent.bugly.common.utils.ProcessUtil$Companion.getProcessNameByCmdLineInner(n2);
            if (string == null || ((CharSequence)string).length() == 0) {
                string = String.valueOf(n2);
            }
            return string;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @JvmStatic
        @Nullable
        public static String getProcessNameByCmdLineInner(int n2) {
            Object object;
            InputStreamReader inputStreamReader = null;
            try {
                inputStreamReader = new FileReader("/proc/" + n2 + "/cmdline");
                object = new char[512];
                int n3 = inputStreamReader.read((char[])object);
                Logger.INSTANCE.d(ProcessUtil.TAG, "getProcessNameByCmdLineInner, ret: ".concat(String.valueOf(n3)));
                for (n3 = 0; n3 < 512 && object[n3] != '\u0000'; ++n3) {
                }
                String string = new String((char[])object).substring(0, n3);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                object = string;
            }
            catch (Throwable throwable) {
                object = null;
                try {
                    InputStreamReader inputStreamReader2 = inputStreamReader;
                    if (inputStreamReader2 == null) return object;
                    inputStreamReader2.close();
                    return object;
                }
                catch (Throwable throwable2) {
                    return object;
                }
            }
            catch (Throwable throwable) {
                try {
                    InputStreamReader inputStreamReader3 = inputStreamReader;
                    if (inputStreamReader3 == null) throw throwable;
                    inputStreamReader3.close();
                    throw throwable;
                }
                catch (Throwable throwable3) {}
                throw throwable;
            }
            try {
                inputStreamReader.close();
                return object;
            }
            catch (Throwable throwable) {
                return object;
            }
        }

        @SuppressLint(value={"DiscouragedPrivateApi", "PrivateApi"})
        private static String aR() {
            Object object;
            try {
                String string;
                object = Class.forName("android.app.ActivityThread", false, Application.class.getClassLoader()).getDeclaredMethod("currentProcessName", new Class[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"declaredMethod");
                ((Method)object).setAccessible(true);
                Object object2 = ((Method)object).invoke(null, new Object[0]);
                if (!(object2 instanceof String)) {
                    object2 = null;
                }
                if ((string = (String)object2) == null) {
                    string = "";
                }
                object = string;
            }
            catch (Throwable throwable) {
                Logger.INSTANCE.e(ProcessUtil.TAG, "getCurrentProcessNameByActivityThread ".concat(String.valueOf(throwable)));
                object = "";
            }
            return object;
        }

        @JvmStatic
        @NotNull
        public static String aS() {
            String string;
            if (!TextUtils.isEmpty((CharSequence)currProcessName)) {
                return currProcessName;
            }
            if (AndroidVersion.Companion.isOverP()) {
                String string2 = Application.getProcessName();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Application.getProcessName()");
            } else {
                string = "";
            }
            currProcessName = string;
            if (!TextUtils.isEmpty((CharSequence)currProcessName)) {
                Logger.INSTANCE.i(ProcessUtil.TAG, "getCurrentProcessNameByApplication, " + currProcessName);
                return currProcessName;
            }
            currProcessName = com.tencent.bugly.common.utils.ProcessUtil$Companion.aR();
            if (!TextUtils.isEmpty((CharSequence)currProcessName)) {
                Logger.INSTANCE.i(ProcessUtil.TAG, "getCurrentProcessNameByActivityThread, " + currProcessName);
                return currProcessName;
            }
            int n2 = Process.myPid();
            currProcessName = com.tencent.bugly.common.utils.ProcessUtil$Companion.getProcessNameByCmdLine(n2);
            if (!TextUtils.isEmpty((CharSequence)currProcessName)) {
                Logger.INSTANCE.i(ProcessUtil.TAG, "getProcessNameByCmdLine, " + currProcessName);
                return currProcessName;
            }
            currProcessName = String.valueOf(n2);
            Logger.INSTANCE.i(ProcessUtil.TAG, "getProcessNameByPid, " + currProcessName);
            return currProcessName;
        }

        @JvmStatic
        public static boolean isMainProcess(@Nullable Context context) {
            return context != null && Intrinsics.areEqual((Object)context.getPackageName(), (Object)com.tencent.bugly.common.utils.ProcessUtil$Companion.aS());
        }

        @JvmStatic
        @SuppressLint(value={"NewApi"})
        public static boolean is64BitProcess(@NotNull Context object) {
            Intrinsics.checkParameterIsNotNull((Object)object, (String)"context");
            if (AndroidVersion.Companion.isOverM()) {
                return Process.is64Bit();
            }
            if (AndroidVersion.Companion.isOverIceScreamSandwich()) {
                String string = "skia";
                try {
                    object = object.getClassLoader();
                    Object object2 = object.getClass().getMethod("findLibrary", String.class).invoke(object, string);
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    object = (String)object2;
                    if (object != null) {
                        return StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"lib64", (boolean)false, (int)2, null);
                    }
                }
                catch (Throwable throwable) {
                    Logger.INSTANCE.exception(ProcessUtil.TAG, throwable);
                }
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(byte by2) {
            this();
        }
    }
}

