/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.common.replay.tool;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.VectorDrawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.tencent.bugly.common.replay.BuglyReplayOptions;
import com.tencent.bugly.common.replay.tool.TextLayout;
import com.tencent.bugly.common.replay.viewhierarchy.ComposeViewHierarchyNode;
import com.tencent.bugly.common.replay.viewhierarchy.ViewHierarchyNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0005\u001a\u00020\u0006*\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a,\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0001H\u0000\u001a\u000e\u0010\u0011\u001a\u00020\u0012*\u0004\u0018\u00010\u0013H\u0001\u001a\u001a\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0015*\u00020\u0007H\u0000\u001a\u0016\u0010\u0016\u001a\u00020\u0006*\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\f\u0010\u0017\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\u001c\u0010\u0018\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001d"}, d2={"totalPaddingTopSafe", "", "Landroid/widget/TextView;", "getTotalPaddingTopSafe", "(Landroid/widget/TextView;)I", "addOnDrawListenerSafe", "", "Landroid/view/View;", "listener", "Landroid/view/ViewTreeObserver$OnDrawListener;", "getVisibleRects", "", "Landroid/graphics/Rect;", "Lcom/tencent/bugly/common/replay/tool/TextLayout;", "globalRect", "paddingLeft", "paddingTop", "isMaskable", "", "Landroid/graphics/drawable/Drawable;", "isVisibleToUser", "Lkotlin/Pair;", "removeOnDrawListenerSafe", "toOpaque", "traverse", "parentNode", "Lcom/tencent/bugly/common/replay/viewhierarchy/ViewHierarchyNode;", "options", "Lcom/tencent/bugly/common/replay/BuglyReplayOptions;", "bugly-pro_release"})
public final class ViewsKt {
    public static final void a(@NotNull View view, @NotNull ViewHierarchyNode viewHierarchyNode, @NotNull BuglyReplayOptions buglyReplayOptions) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"$this$traverse");
        Intrinsics.checkParameterIsNotNull((Object)viewHierarchyNode, (String)"parentNode");
        Intrinsics.checkParameterIsNotNull((Object)buglyReplayOptions, (String)"options");
        if (!(view instanceof ViewGroup)) {
            return;
        }
        if (ComposeViewHierarchyNode.INSTANCE.fromView(view, viewHierarchyNode, buglyReplayOptions)) {
            return;
        }
        if (((ViewGroup)view).getChildCount() == 0) {
            return;
        }
        ArrayList<ViewHierarchyNode> arrayList = new ArrayList<ViewHierarchyNode>(((ViewGroup)view).getChildCount());
        int n2 = ((ViewGroup)view).getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            View view2 = ((ViewGroup)view).getChildAt(i2);
            if (view2 == null) continue;
            ViewHierarchyNode viewHierarchyNode2 = ViewHierarchyNode.Companion.a(view2, viewHierarchyNode, ((ViewGroup)view).indexOfChild(view2), buglyReplayOptions);
            arrayList.add(viewHierarchyNode2);
            ViewsKt.a(view2, viewHierarchyNode2, buglyReplayOptions);
        }
        viewHierarchyNode.setChildren((List<? extends ViewHierarchyNode>)arrayList);
    }

    @NotNull
    public static final Pair<Boolean, Rect> b(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"$this$isVisibleToUser");
        if (view.isAttachedToWindow()) {
            if (view.getWindowVisibility() != 0) {
                return TuplesKt.to((Object)Boolean.FALSE, null);
            }
            View view2 = view;
            while (view2 instanceof View) {
                float f2;
                float f3 = f2 = Build.VERSION.SDK_INT >= 29 ? view2.getTransitionAlpha() : 1.0f;
                if (view2.getAlpha() <= 0.0f || f2 <= 0.0f || view2.getVisibility() != 0) {
                    return TuplesKt.to((Object)Boolean.FALSE, null);
                }
                view2 = view2.getParent();
            }
            view2 = new Rect();
            Point point = new Point();
            return TuplesKt.to((Object)view.getGlobalVisibleRect((Rect)view2, point), (Object)view2);
        }
        return TuplesKt.to((Object)Boolean.FALSE, null);
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    @TargetApi(value=21)
    public static final boolean a(@Nullable Drawable drawable) {
        Drawable drawable2 = drawable;
        if (drawable2 instanceof InsetDrawable || drawable2 instanceof ColorDrawable || drawable2 instanceof VectorDrawable || drawable2 instanceof GradientDrawable) {
            return false;
        }
        if (drawable2 instanceof BitmapDrawable) {
            Bitmap bitmap = ((BitmapDrawable)drawable).getBitmap();
            if (bitmap == null) {
                return false;
            }
            drawable = bitmap;
            return !bitmap.isRecycled() && drawable.getHeight() > 10 && drawable.getWidth() > 10;
        }
        return true;
    }

    @NotNull
    public static final List<Rect> a(@Nullable TextLayout textLayout, @NotNull Rect rect, int n2, int n3) {
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"globalRect");
        if (textLayout == null) {
            return CollectionsKt.listOf((Object)rect);
        }
        List list = new ArrayList();
        int n4 = textLayout.getLineCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = (int)textLayout.getPrimaryHorizontal(i2, textLayout.getLineStart(i2));
            int n6 = textLayout.getEllipsisCount(i2);
            int n7 = textLayout.getLineVisibleEnd(i2);
            n6 = (int)textLayout.getPrimaryHorizontal(i2, n7 - n6 + (n6 > 0 ? 1 : 0));
            if (n6 == 0 && n7 > 0) {
                n6 = (int)textLayout.getPrimaryHorizontal(i2, n7 - 1) + 1;
            }
            n7 = textLayout.getLineTop(i2);
            int n8 = textLayout.getLineBottom(i2);
            Rect rect2 = new Rect();
            new Rect().left = rect.left + n2 + n5;
            rect2.right = rect2.left + (n6 - n5);
            rect2.top = rect.top + n3 + n7;
            rect2.bottom = rect2.top + (n8 - n7);
            ((Collection)list).add(rect2);
        }
        return list;
    }

    public static final int e(int n2) {
        return n2 | 0xFF000000;
    }

    public static final void a(@Nullable View view, @NotNull ViewTreeObserver.OnDrawListener onDrawListener) {
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)onDrawListener, (String)"listener");
                if (view == null || view.getViewTreeObserver() == null) break block4;
                ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
                Intrinsics.checkExpressionValueIsNotNull((Object)viewTreeObserver, (String)"viewTreeObserver");
                if (viewTreeObserver.isAlive()) break block5;
            }
            return;
        }
        try {
            view.getViewTreeObserver().addOnDrawListener(onDrawListener);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    public static final void b(@Nullable View view, @NotNull ViewTreeObserver.OnDrawListener onDrawListener) {
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)onDrawListener, (String)"listener");
                if (view == null || view.getViewTreeObserver() == null) break block4;
                ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
                Intrinsics.checkExpressionValueIsNotNull((Object)viewTreeObserver, (String)"viewTreeObserver");
                if (viewTreeObserver.isAlive()) break block5;
            }
            return;
        }
        try {
            view.getViewTreeObserver().removeOnDrawListener(onDrawListener);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }
}

