/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.common.replay.tool;

import android.annotation.SuppressLint;
import com.tencent.rmonitor.common.logger.Logger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a:\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0001\u001a\"\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011*\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"shutdownTimeoutMillis", "", "gracefullyShutdown", "", "Ljava/util/concurrent/ExecutorService;", "scheduleAtFixedRateSafely", "Ljava/util/concurrent/ScheduledFuture;", "Ljava/util/concurrent/ScheduledExecutorService;", "taskName", "", "initialDelay", "period", "unit", "Ljava/util/concurrent/TimeUnit;", "task", "Ljava/lang/Runnable;", "submitSafely", "Ljava/util/concurrent/Future;", "bugly-pro_release"})
public final class ExecutorsKt {
    private static final long shutdownTimeoutMillis = 2000L;

    public static final void gracefullyShutdown(@NotNull ExecutorService executorService) {
        Intrinsics.checkParameterIsNotNull((Object)executorService, (String)"$this$gracefullyShutdown");
        synchronized (executorService) {
            if (!executorService.isShutdown()) {
                executorService.shutdown();
            }
            try {
                if (!executorService.awaitTermination(2000L, TimeUnit.MILLISECONDS)) {
                    executorService.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
            return;
        }
    }

    @Nullable
    public static final Future<?> submitSafely(@NotNull ExecutorService object, @NotNull String string, @NotNull Runnable runnable2) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"$this$submitSafely");
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"taskName");
        Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"task");
        try {
            object = object.submit(new Runnable(runnable2, string){
                final /* synthetic */ Runnable $task;
                final /* synthetic */ String $taskName;

                public final void run() {
                    try {
                        this.$task.run();
                        return;
                    }
                    catch (Throwable throwable) {
                        Logger.INSTANCE.exception("Failed to execute task " + this.$taskName, throwable);
                        return;
                    }
                }
                {
                    this.$task = runnable2;
                    this.$taskName = string;
                }
            });
        }
        catch (Throwable throwable) {
            Logger.INSTANCE.exception("Failed to submit task " + string + " to executor", throwable);
            object = null;
        }
        return object;
    }

    @SuppressLint(value={"DiscouragedApi"})
    @Nullable
    public static final ScheduledFuture<?> scheduleAtFixedRateSafely(@NotNull ScheduledExecutorService object, @NotNull String string, long l2, long l3, @NotNull TimeUnit timeUnit, @NotNull Runnable runnable2) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"$this$scheduleAtFixedRateSafely");
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"taskName");
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"unit");
        Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"task");
        try {
            object = object.scheduleAtFixedRate(new Runnable(runnable2, string){
                final /* synthetic */ Runnable $task;
                final /* synthetic */ String $taskName;

                public final void run() {
                    try {
                        this.$task.run();
                        return;
                    }
                    catch (Throwable throwable) {
                        Logger.INSTANCE.exception("Failed to execute task " + this.$taskName, throwable);
                        return;
                    }
                }
                {
                    this.$task = runnable2;
                    this.$taskName = string;
                }
            }, l2, l3, timeUnit);
        }
        catch (Throwable throwable) {
            Logger.INSTANCE.exception("Failed to schedule task ".concat(String.valueOf(string)), throwable);
            object = null;
        }
        return object;
    }
}

