/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.examples.BasicOperations.Account;

import com.tencent.ads.ApiContextConfig;
import com.tencent.ads.TencentAds;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.exception.TencentAdsSDKException;
import com.tencent.ads.model.DateRange;
import com.tencent.ads.model.FundStatementsDailyGetResponseData;
import java.util.Arrays;
import java.util.List;

public class GetFundStatementsDaily {
    public String ACCESS_TOKEN = "YOUR ACCESS TOKEN";
    public TencentAds tencentAds;
    public Long accountId = null;
    public String fundType = "FUND_TYPE_GIFT";
    public DateRange dateRange = new DateRange();
    public String tradeType = null;
    public List<String> fields = Arrays.asList("fund_type", "trade_type", "time", "amount", "description");

    public void init() {
        this.tencentAds = TencentAds.getInstance();
        this.tencentAds.init(new ApiContextConfig().accessToken(this.ACCESS_TOKEN).isDebug(true));
        this.tencentAds.useSandbox();
        this.buildParams();
    }

    public void buildParams() {
        String startDate = "REPORT START DATE";
        this.dateRange.setStartDate(startDate);
        String endDate = "REPORT END DATE";
        this.dateRange.setEndDate(endDate);
    }

    public FundStatementsDailyGetResponseData getFundStatementsDaily() throws Exception {
        FundStatementsDailyGetResponseData response = this.tencentAds.fundStatementsDaily().fundStatementsDailyGet(this.accountId, this.fundType, this.dateRange, this.tradeType, this.fields);
        return response;
    }

    public static void main(String[] args) {
        try {
            GetFundStatementsDaily getFundStatementsDaily = new GetFundStatementsDaily();
            getFundStatementsDaily.init();
            FundStatementsDailyGetResponseData fundStatementsDailyGetResponseData = getFundStatementsDaily.getFundStatementsDaily();
        }
        catch (TencentAdsResponseException e) {
            e.printStackTrace();
        }
        catch (TencentAdsSDKException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

