/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.ProductItemsListGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ProductItemsListApi {
    private ApiClient apiClient;

    public ProductItemsListApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProductItemsListApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call productItemsListGetCall(Long accountId, Long productCatalogId, Long pageSize, Long page, String sortByProductLastModTime, String sortByProductName, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/product_items_list/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (productCatalogId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("product_catalog_id", productCatalogId));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (sortByProductLastModTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort_by_product_last_mod_time", sortByProductLastModTime));
        }
        if (sortByProductName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort_by_product_name", sortByProductName));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call productItemsListGetValidateBeforeCall(Long accountId, Long productCatalogId, Long pageSize, Long page, String sortByProductLastModTime, String sortByProductName, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling productItemsListGet(Async)");
        }
        if (productCatalogId == null) {
            throw new ApiException("Missing the required parameter 'productCatalogId' when calling productItemsListGet(Async)");
        }
        if (pageSize == null) {
            throw new ApiException("Missing the required parameter 'pageSize' when calling productItemsListGet(Async)");
        }
        if (page == null) {
            throw new ApiException("Missing the required parameter 'page' when calling productItemsListGet(Async)");
        }
        Call call = this.productItemsListGetCall(accountId, productCatalogId, pageSize, page, sortByProductLastModTime, sortByProductName, fields, progressListener, progressRequestListener);
        return call;
    }

    public ProductItemsListGetResponse productItemsListGet(Long accountId, Long productCatalogId, Long pageSize, Long page, String sortByProductLastModTime, String sortByProductName, List<String> fields) throws ApiException {
        ApiResponse<ProductItemsListGetResponse> resp = this.productItemsListGetWithHttpInfo(accountId, productCatalogId, pageSize, page, sortByProductLastModTime, sortByProductName, fields);
        return resp.getData();
    }

    public ApiResponse<ProductItemsListGetResponse> productItemsListGetWithHttpInfo(Long accountId, Long productCatalogId, Long pageSize, Long page, String sortByProductLastModTime, String sortByProductName, List<String> fields) throws ApiException {
        Call call = this.productItemsListGetValidateBeforeCall(accountId, productCatalogId, pageSize, page, sortByProductLastModTime, sortByProductName, fields, null, null);
        Type localVarReturnType = new TypeToken<ProductItemsListGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call productItemsListGetAsync(Long accountId, Long productCatalogId, Long pageSize, Long page, String sortByProductLastModTime, String sortByProductName, List<String> fields, final ApiCallback<ProductItemsListGetResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.productItemsListGetValidateBeforeCall(accountId, productCatalogId, pageSize, page, sortByProductLastModTime, sortByProductName, fields, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ProductItemsListGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

