package com.tencent.ads.examples.BasicOperations.AudiencesManagement;

import com.tencent.ads.ApiContextConfig;
import com.tencent.ads.TencentAds;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.exception.TencentAdsSDKException;
import com.tencent.ads.model.*;
import com.tencent.ads.model.CustomTagsDeleteRequest;
import com.tencent.ads.model.CustomTagsDeleteResponse;

public class DeleteCustomTags {
  /** YOUR ACCESS TOKEN */
  public String ACCESS_TOKEN = "YOUR ACCESS TOKEN";

  /** TencentAds */
  public TencentAds tencentAds;

  public Long accountId = null;
  public CustomTagsDeleteRequest data = new CustomTagsDeleteRequest();
  public Long tagId = null;

  public void init() {
    this.tencentAds = TencentAds.getInstance();
    this.tencentAds.init(
        new ApiContextConfig().accessToken(ACCESS_TOKEN).isDebug(true)); // debug==true 会打印请求详细信息
    this.tencentAds.useSandbox(); // 默认使用沙箱环境，如果要请求线上，这里需要设为线上环境
    this.buildParams();
  }

  public void buildParams() {
    data.setAccountId(accountId);

    data.setTagId(tagId);
  }

  public CustomTagsDeleteResponse deleteCustomTags() throws Exception {
    CustomTagsDeleteResponse response = tencentAds.customTags().customTagsDelete(data);
    return response;
  }

  public static void main(String[] args) {
    try {
      DeleteCustomTags deleteCustomTags = new DeleteCustomTags();
      deleteCustomTags.init();
      CustomTagsDeleteResponse response = deleteCustomTags.deleteCustomTags();
    } catch (TencentAdsResponseException e) {
      e.printStackTrace();
    } catch (TencentAdsSDKException e) {
      e.printStackTrace();
    } catch (Exception e) {
      e.printStackTrace();
    }
  }
}
