/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.examples.AdvancedOperations;

import com.tencent.ads.ApiContextConfig;
import com.tencent.ads.ApiException;
import com.tencent.ads.TencentAds;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.exception.TencentAdsSDKException;
import com.tencent.ads.model.AgeStruct;
import com.tencent.ads.model.AudienceType;
import com.tencent.ads.model.CustomAudienceFilesAddResponseData;
import com.tencent.ads.model.CustomAudiencesAddRequest;
import com.tencent.ads.model.CustomAudiencesAddResponseData;
import com.tencent.ads.model.GeoLocations;
import com.tencent.ads.model.TargetingTagsGetListStruct;
import com.tencent.ads.model.TargetingTagsGetResponseData;
import com.tencent.ads.model.TargetingsAddRequest;
import com.tencent.ads.model.TargetingsAddResponseData;
import com.tencent.ads.model.WriteTargetingSetting;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class AddComplexTargetings {
    public String ACCESS_TOKEN = "YOUR ACCESS TOKEN";
    public Long ACCOUNT_ID = 0L;
    public String AUDIENCE_FILE_POS_IMEI = "YOUR AUDIENCE FILE PATH";
    public String AUDIENCE_FILE_NEG_IMEI = "YOUR AUDIENCE FILE PATH";
    public TencentAds tencentAds;

    public void init() {
        this.tencentAds = TencentAds.getInstance();
        this.tencentAds.init(new ApiContextConfig().accessToken(this.ACCESS_TOKEN).isDebug(true));
        this.tencentAds.useSandbox();
    }

    public Long addComplexTargetings() throws ApiException {
        List<String> regionNameList = Arrays.asList("\u5317\u4eac\u5e02", "\u4e0a\u6d77\u5e02", "\u5e7f\u4e1c\u7701");
        List<Long> regionIdList = this.getTargetingRegion(regionNameList);
        Long positionAudiences = this.addCustomAudience(this.AUDIENCE_FILE_POS_IMEI);
        Long negativeAudiences = this.addCustomAudience(this.AUDIENCE_FILE_NEG_IMEI);
        Long targetingId = this.addTargeting(regionIdList, positionAudiences, negativeAudiences);
        return targetingId;
    }

    protected List<Long> getTargetingRegion(List<String> regionNameList) throws ApiException {
        ArrayList<Long> res = new ArrayList<Long>();
        TargetingTagsGetResponseData responseData = this.tencentAds.targetingTags().targetingTagsGet("REGION", null, null, null);
        if (responseData != null && responseData.getList() != null) {
            for (TargetingTagsGetListStruct s : responseData.getList()) {
                if (!regionNameList.contains(s.getName())) continue;
                res.add(s.getId());
            }
        }
        return res;
    }

    protected Long addCustomAudience(String audienceFilePath) throws ApiException {
        CustomAudiencesAddRequest addRequest = new CustomAudiencesAddRequest();
        addRequest.setAccountId(this.ACCOUNT_ID);
        addRequest.setName("SDK sample aud" + UUID.randomUUID().toString().substring(0, 6));
        addRequest.setType(AudienceType.CUSTOMER_FILE);
        addRequest.setDescription("created by SDK samples");
        CustomAudiencesAddResponseData customAudiencesAddResponseData = this.tencentAds.customAudiences().customAudiencesAdd(addRequest);
        if (customAudiencesAddResponseData != null && customAudiencesAddResponseData.getAudienceId() != null) {
            Long audienceId = customAudiencesAddResponseData.getAudienceId();
            CustomAudienceFilesAddResponseData customAudienceFilesAddResponseData = this.tencentAds.customAudienceFiles().customAudienceFilesAdd(this.ACCOUNT_ID, audienceId, "IMEI", new File(audienceFilePath), null, null, null);
            if (customAudienceFilesAddResponseData != null && customAudienceFilesAddResponseData.getCustomAudienceFileId() != null) {
                return audienceId;
            }
        }
        return null;
    }

    protected Long addTargeting(List<Long> regionIdList, Long positionAudiences, Long negativeAudiences) throws ApiException {
        TargetingsAddRequest targetingsAddRequest = new TargetingsAddRequest();
        targetingsAddRequest.setAccountId(this.ACCOUNT_ID);
        targetingsAddRequest.setTargetingName("SDK sample targeting" + UUID.randomUUID().toString().substring(0, 6));
        targetingsAddRequest.setTargeting(new WriteTargetingSetting().gender(Arrays.asList("MALE")).age(Arrays.asList(new AgeStruct().max(45L).min(23L))).geoLocation(new GeoLocations().locationTypes(Arrays.asList("LIVE_IN")).regions(regionIdList)).userOs(Arrays.asList("IOS")).customAudience(Arrays.asList(positionAudiences)).excludedCustomAudience(Arrays.asList(negativeAudiences)));
        targetingsAddRequest.setDescription("created by SDK samples");
        TargetingsAddResponseData targetingsAddResponseData = this.tencentAds.targetings().targetingsAdd(targetingsAddRequest);
        if (targetingsAddResponseData != null) {
            return targetingsAddResponseData.getTargetingId();
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            AddComplexTargetings addComplexTargetings = new AddComplexTargetings();
            addComplexTargetings.init();
            Long l = addComplexTargetings.addComplexTargetings();
        }
        catch (TencentAdsResponseException e) {
            e.printStackTrace();
        }
        catch (TencentAdsSDKException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

