/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.DateRange;
import com.tencent.ads.model.UserActionSetReportsGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UserActionSetReportsApi {
    private ApiClient apiClient;

    public UserActionSetReportsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserActionSetReportsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call userActionSetReportsGetCall(Long accountId, Long userActionSetId, DateRange dateRange, String timeGranularity, String aggregation, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/user_action_set_reports/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (userActionSetId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("user_action_set_id", userActionSetId));
        }
        if (dateRange != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("date_range", dateRange));
        }
        if (timeGranularity != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("time_granularity", timeGranularity));
        }
        if (aggregation != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("aggregation", aggregation));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call userActionSetReportsGetValidateBeforeCall(Long accountId, Long userActionSetId, DateRange dateRange, String timeGranularity, String aggregation, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling userActionSetReportsGet(Async)");
        }
        if (userActionSetId == null) {
            throw new ApiException("Missing the required parameter 'userActionSetId' when calling userActionSetReportsGet(Async)");
        }
        if (dateRange == null) {
            throw new ApiException("Missing the required parameter 'dateRange' when calling userActionSetReportsGet(Async)");
        }
        if (timeGranularity == null) {
            throw new ApiException("Missing the required parameter 'timeGranularity' when calling userActionSetReportsGet(Async)");
        }
        Call call = this.userActionSetReportsGetCall(accountId, userActionSetId, dateRange, timeGranularity, aggregation, fields, progressListener, progressRequestListener);
        return call;
    }

    public UserActionSetReportsGetResponse userActionSetReportsGet(Long accountId, Long userActionSetId, DateRange dateRange, String timeGranularity, String aggregation, List<String> fields) throws ApiException {
        ApiResponse<UserActionSetReportsGetResponse> resp = this.userActionSetReportsGetWithHttpInfo(accountId, userActionSetId, dateRange, timeGranularity, aggregation, fields);
        return resp.getData();
    }

    public ApiResponse<UserActionSetReportsGetResponse> userActionSetReportsGetWithHttpInfo(Long accountId, Long userActionSetId, DateRange dateRange, String timeGranularity, String aggregation, List<String> fields) throws ApiException {
        Call call = this.userActionSetReportsGetValidateBeforeCall(accountId, userActionSetId, dateRange, timeGranularity, aggregation, fields, null, null);
        Type localVarReturnType = new TypeToken<UserActionSetReportsGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call userActionSetReportsGetAsync(Long accountId, Long userActionSetId, DateRange dateRange, String timeGranularity, String aggregation, List<String> fields, final ApiCallback<UserActionSetReportsGetResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.userActionSetReportsGetValidateBeforeCall(accountId, userActionSetId, dateRange, timeGranularity, aggregation, fields, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserActionSetReportsGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

