/*
 * Decompiled with CFR 0.152.
 */
package com.taxjar.exception;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;

public class TaxjarException
extends Exception {
    private Integer statusCode;

    public TaxjarException(String errorMessage, int statusCode) {
        super(TaxjarException.parseMessage(errorMessage), null);
        this.statusCode = TaxjarException.parseStatusCode(errorMessage, statusCode);
    }

    public TaxjarException(String errorMessage) {
        this(errorMessage, null);
    }

    public TaxjarException(String errorMessage, Throwable err) {
        super(TaxjarException.parseMessage(errorMessage), err);
        this.statusCode = TaxjarException.parseStatusCode(errorMessage);
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    private static String parseMessage(String errorMessage) {
        Gson gson = new Gson();
        if (errorMessage == null || errorMessage.equals("")) {
            return "";
        }
        try {
            JsonObject json = (JsonObject)gson.fromJson(errorMessage, JsonObject.class);
            JsonElement error = json.get("error");
            JsonElement detail = json.get("detail");
            if (error != null && detail != null) {
                return error.getAsString() + " - " + detail.getAsString();
            }
            return errorMessage;
        }
        catch (JsonSyntaxException e) {
            return errorMessage;
        }
    }

    private static Integer parseStatusCode(String errorMessage, int statusCode) {
        if (errorMessage == null || errorMessage.equals("")) {
            return statusCode;
        }
        return TaxjarException.parseStatusCode(errorMessage);
    }

    private static Integer parseStatusCode(String errorMessage) {
        Gson gson = new Gson();
        if (errorMessage == null) {
            return 0;
        }
        try {
            JsonObject json = (JsonObject)gson.fromJson(errorMessage, JsonObject.class);
            JsonElement status = json.get("status");
            if (status != null) {
                return status.getAsInt();
            }
            return 0;
        }
        catch (JsonSyntaxException e) {
            return 0;
        }
    }
}

