/*
 * Decompiled with CFR 0.152.
 */
package com.taxjar;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.taxjar.exception.TaxjarException;
import com.taxjar.model.categories.CategoryResponse;
import com.taxjar.model.customers.CustomerResponse;
import com.taxjar.model.customers.CustomersResponse;
import com.taxjar.model.nexus.RegionResponse;
import com.taxjar.model.rates.RateResponse;
import com.taxjar.model.summarized_rates.SummaryRateResponse;
import com.taxjar.model.taxes.TaxResponse;
import com.taxjar.model.transactions.OrderResponse;
import com.taxjar.model.transactions.OrdersResponse;
import com.taxjar.model.transactions.RefundResponse;
import com.taxjar.model.transactions.RefundsResponse;
import com.taxjar.model.validations.AddressResponse;
import com.taxjar.model.validations.ValidationResponse;
import com.taxjar.net.ApiCallback;
import com.taxjar.net.ApiRequest;
import com.taxjar.net.Endpoints;
import com.taxjar.net.Listener;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class Taxjar {
    public static final String DEFAULT_API_URL = "https://api.taxjar.com";
    public static final String SANDBOX_API_URL = "https://api.sandbox.taxjar.com";
    public static final String API_VERSION = "v2";
    public static final String VERSION = "3.0.0";
    protected static Endpoints apiService;
    protected String apiUrl;
    protected String apiToken;
    protected long timeout = 30000L;

    public Taxjar(String apiToken) {
        this(apiToken, null);
    }

    public Taxjar(String apiToken, Map<String, Object> params) {
        this.apiToken = apiToken;
        this.apiUrl = DEFAULT_API_URL;
        this.buildClient(params);
    }

    public void buildClient(Map<String, Object> params) {
        final String apiToken = this.apiToken;
        if (params != null) {
            for (Map.Entry<String, Object> param : params.entrySet()) {
                try {
                    this.getClass().getDeclaredField(param.getKey()).set(this, param.getValue());
                }
                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {}
            }
        }
        OkHttpClient client = new OkHttpClient.Builder().addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request newRequest = chain.request().newBuilder().addHeader("Authorization", "Bearer " + apiToken).addHeader("User-Agent", "TaxJarJava/3.0.0").build();
                return chain.proceed(newRequest);
            }
        }).connectTimeout(this.timeout, TimeUnit.MILLISECONDS).writeTimeout(this.timeout, TimeUnit.MILLISECONDS).readTimeout(this.timeout, TimeUnit.MILLISECONDS).build();
        Gson gson = new GsonBuilder().setLenient().create();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this.apiUrl + "/" + API_VERSION + "/").addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).client(client).build();
        apiService = (Endpoints)retrofit.create(Endpoints.class);
    }

    public String getApiConfig(String key) {
        try {
            return this.getClass().getDeclaredField(key).get(this).toString();
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            return "";
        }
    }

    public void setApiConfig(String key, Object value) {
        try {
            this.getClass().getDeclaredField(key).set(this, value);
            this.buildClient(null);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
    }

    public CategoryResponse categories() throws TaxjarException {
        Call<CategoryResponse> call = apiService.getCategories();
        return new ApiRequest<CategoryResponse>(call).execute();
    }

    public void categories(Listener<CategoryResponse> listener) {
        Call<CategoryResponse> call = apiService.getCategories();
        call.enqueue(new ApiCallback<CategoryResponse>(listener));
    }

    public RateResponse ratesForLocation(String zip) throws TaxjarException {
        Call<RateResponse> call = apiService.getRate(zip);
        return new ApiRequest<RateResponse>(call).execute();
    }

    public RateResponse ratesForLocation(String zip, Map<String, String> params) throws TaxjarException {
        Call<RateResponse> call = apiService.getRate(zip, params);
        return new ApiRequest<RateResponse>(call).execute();
    }

    public void ratesForLocation(String zip, Listener<RateResponse> listener) throws TaxjarException {
        Call<RateResponse> call = apiService.getRate(zip);
        call.enqueue(new ApiCallback<RateResponse>(listener));
    }

    public void ratesForLocation(String zip, Map<String, String> params, Listener<RateResponse> listener) throws TaxjarException {
        Call<RateResponse> call = apiService.getRate(zip, params);
        call.enqueue(new ApiCallback<RateResponse>(listener));
    }

    public TaxResponse taxForOrder(Map<String, Object> params) throws TaxjarException {
        Call<TaxResponse> call = apiService.getTax(params);
        return new ApiRequest<TaxResponse>(call).execute();
    }

    public void taxForOrder(Map<String, Object> params, Listener<TaxResponse> listener) {
        Call<TaxResponse> call = apiService.getTax(params);
        call.enqueue(new ApiCallback<TaxResponse>(listener));
    }

    public OrdersResponse listOrders() throws TaxjarException {
        Call<OrdersResponse> call = apiService.getOrders();
        return new ApiRequest<OrdersResponse>(call).execute();
    }

    public OrdersResponse listOrders(Map<String, String> params) throws TaxjarException {
        Call<OrdersResponse> call = apiService.getOrders(params);
        return new ApiRequest<OrdersResponse>(call).execute();
    }

    public void listOrders(Listener<OrdersResponse> listener) {
        Call<OrdersResponse> call = apiService.getOrders();
        call.enqueue(new ApiCallback<OrdersResponse>(listener));
    }

    public void listOrders(Map<String, String> params, Listener<OrdersResponse> listener) {
        Call<OrdersResponse> call = apiService.getOrders(params);
        call.enqueue(new ApiCallback<OrdersResponse>(listener));
    }

    public OrderResponse showOrder(String transactionId) throws TaxjarException {
        Call<OrderResponse> call = apiService.getOrder(transactionId);
        return new ApiRequest<OrderResponse>(call).execute();
    }

    public void showOrder(String transactionId, Listener<OrderResponse> listener) {
        Call<OrderResponse> call = apiService.getOrder(transactionId);
        call.enqueue(new ApiCallback<OrderResponse>(listener));
    }

    public OrderResponse createOrder(Map<String, Object> params) throws TaxjarException {
        Call<OrderResponse> call = apiService.createOrder(params);
        return new ApiRequest<OrderResponse>(call).execute();
    }

    public void createOrder(Map<String, Object> params, Listener<OrderResponse> listener) {
        Call<OrderResponse> call = apiService.createOrder(params);
        call.enqueue(new ApiCallback<OrderResponse>(listener));
    }

    public OrderResponse updateOrder(String transactionId, Map<String, Object> params) throws TaxjarException {
        Call<OrderResponse> call = apiService.updateOrder(transactionId, params);
        return new ApiRequest<OrderResponse>(call).execute();
    }

    public void updateOrder(String transactionId, Map<String, Object> params, Listener<OrderResponse> listener) {
        Call<OrderResponse> call = apiService.updateOrder(transactionId, params);
        call.enqueue(new ApiCallback<OrderResponse>(listener));
    }

    public OrderResponse deleteOrder(String transactionId) throws TaxjarException {
        Call<OrderResponse> call = apiService.deleteOrder(transactionId);
        return new ApiRequest<OrderResponse>(call).execute();
    }

    public void deleteOrder(String transactionId, Listener<OrderResponse> listener) {
        Call<OrderResponse> call = apiService.deleteOrder(transactionId);
        call.enqueue(new ApiCallback<OrderResponse>(listener));
    }

    public RefundsResponse listRefunds() throws TaxjarException {
        Call<RefundsResponse> call = apiService.getRefunds();
        return new ApiRequest<RefundsResponse>(call).execute();
    }

    public RefundsResponse listRefunds(Map<String, String> params) throws TaxjarException {
        Call<RefundsResponse> call = apiService.getRefunds(params);
        return new ApiRequest<RefundsResponse>(call).execute();
    }

    public void listRefunds(Listener<RefundsResponse> listener) {
        Call<RefundsResponse> call = apiService.getRefunds();
        call.enqueue(new ApiCallback<RefundsResponse>(listener));
    }

    public void listRefunds(Map<String, String> params, Listener<RefundsResponse> listener) {
        Call<RefundsResponse> call = apiService.getRefunds(params);
        call.enqueue(new ApiCallback<RefundsResponse>(listener));
    }

    public RefundResponse showRefund(String transactionId) throws TaxjarException {
        Call<RefundResponse> call = apiService.getRefund(transactionId);
        return new ApiRequest<RefundResponse>(call).execute();
    }

    public void showRefund(String transactionId, Listener<RefundResponse> listener) {
        Call<RefundResponse> call = apiService.getRefund(transactionId);
        call.enqueue(new ApiCallback<RefundResponse>(listener));
    }

    public RefundResponse createRefund(Map<String, Object> params) throws TaxjarException {
        Call<RefundResponse> call = apiService.createRefund(params);
        return new ApiRequest<RefundResponse>(call).execute();
    }

    public void createRefund(Map<String, Object> params, Listener<RefundResponse> listener) {
        Call<RefundResponse> call = apiService.createRefund(params);
        call.enqueue(new ApiCallback<RefundResponse>(listener));
    }

    public RefundResponse createRefund(String transactionId, Map<String, Object> params) throws TaxjarException {
        Call<RefundResponse> call = apiService.updateRefund(transactionId, params);
        return new ApiRequest<RefundResponse>(call).execute();
    }

    public void createRefund(String transactionId, Map<String, Object> params, Listener<RefundResponse> listener) {
        Call<RefundResponse> call = apiService.updateRefund(transactionId, params);
        call.enqueue(new ApiCallback<RefundResponse>(listener));
    }

    public RefundResponse updateRefund(String transactionId, Map<String, Object> params) throws TaxjarException {
        Call<RefundResponse> call = apiService.updateRefund(transactionId, params);
        return new ApiRequest<RefundResponse>(call).execute();
    }

    public void updateRefund(String transactionId, Map<String, Object> params, Listener<RefundResponse> listener) {
        Call<RefundResponse> call = apiService.updateRefund(transactionId, params);
        call.enqueue(new ApiCallback<RefundResponse>(listener));
    }

    public RefundResponse deleteRefund(String transactionId) throws TaxjarException {
        Call<RefundResponse> call = apiService.deleteRefund(transactionId);
        return new ApiRequest<RefundResponse>(call).execute();
    }

    public void deleteRefund(String transactionId, Listener<RefundResponse> listener) {
        Call<RefundResponse> call = apiService.deleteRefund(transactionId);
        call.enqueue(new ApiCallback<RefundResponse>(listener));
    }

    public CustomersResponse listCustomers() throws TaxjarException {
        Call<CustomersResponse> call = apiService.getCustomers();
        return new ApiRequest<CustomersResponse>(call).execute();
    }

    public CustomersResponse listCustomers(Map<String, String> params) throws TaxjarException {
        Call<CustomersResponse> call = apiService.getCustomers(params);
        return new ApiRequest<CustomersResponse>(call).execute();
    }

    public void listCustomers(Listener<CustomersResponse> listener) {
        Call<CustomersResponse> call = apiService.getCustomers();
        call.enqueue(new ApiCallback<CustomersResponse>(listener));
    }

    public void listCustomers(Map<String, String> params, Listener<CustomersResponse> listener) {
        Call<CustomersResponse> call = apiService.getCustomers(params);
        call.enqueue(new ApiCallback<CustomersResponse>(listener));
    }

    public CustomerResponse showCustomer(String customerId) throws TaxjarException {
        Call<CustomerResponse> call = apiService.getCustomer(customerId);
        return new ApiRequest<CustomerResponse>(call).execute();
    }

    public void showCustomer(String customerId, Listener<CustomerResponse> listener) {
        Call<CustomerResponse> call = apiService.getCustomer(customerId);
        call.enqueue(new ApiCallback<CustomerResponse>(listener));
    }

    public CustomerResponse createCustomer(Map<String, Object> params) throws TaxjarException {
        Call<CustomerResponse> call = apiService.createCustomer(params);
        return new ApiRequest<CustomerResponse>(call).execute();
    }

    public void createCustomer(Map<String, Object> params, Listener<CustomerResponse> listener) {
        Call<CustomerResponse> call = apiService.createCustomer(params);
        call.enqueue(new ApiCallback<CustomerResponse>(listener));
    }

    public CustomerResponse updateCustomer(String customerId, Map<String, Object> params) throws TaxjarException {
        Call<CustomerResponse> call = apiService.updateCustomer(customerId, params);
        return new ApiRequest<CustomerResponse>(call).execute();
    }

    public void updateCustomer(String customerId, Map<String, Object> params, Listener<CustomerResponse> listener) {
        Call<CustomerResponse> call = apiService.updateCustomer(customerId, params);
        call.enqueue(new ApiCallback<CustomerResponse>(listener));
    }

    public CustomerResponse deleteCustomer(String customerId) throws TaxjarException {
        Call<CustomerResponse> call = apiService.deleteCustomer(customerId);
        return new ApiRequest<CustomerResponse>(call).execute();
    }

    public void deleteCustomer(String customerId, Listener<CustomerResponse> listener) {
        Call<CustomerResponse> call = apiService.deleteCustomer(customerId);
        call.enqueue(new ApiCallback<CustomerResponse>(listener));
    }

    public RegionResponse nexusRegions() throws TaxjarException {
        Call<RegionResponse> call = apiService.getRegions();
        return new ApiRequest<RegionResponse>(call).execute();
    }

    public void nexusRegions(Listener<RegionResponse> listener) {
        Call<RegionResponse> call = apiService.getRegions();
        call.enqueue(new ApiCallback<RegionResponse>(listener));
    }

    public AddressResponse validateAddress(Map<String, Object> params) throws TaxjarException {
        Call<AddressResponse> call = apiService.getAddresses(params);
        return new ApiRequest<AddressResponse>(call).execute();
    }

    public void validateAddress(Map<String, Object> params, Listener<AddressResponse> listener) {
        Call<AddressResponse> call = apiService.getAddresses(params);
        call.enqueue(new ApiCallback<AddressResponse>(listener));
    }

    public ValidationResponse validateVat(Map<String, String> params) throws TaxjarException {
        Call<ValidationResponse> call = apiService.getValidation(params);
        return new ApiRequest<ValidationResponse>(call).execute();
    }

    public void validateVat(Map<String, String> params, Listener<ValidationResponse> listener) {
        Call<ValidationResponse> call = apiService.getValidation(params);
        call.enqueue(new ApiCallback<ValidationResponse>(listener));
    }

    public SummaryRateResponse summaryRates() throws TaxjarException {
        Call<SummaryRateResponse> call = apiService.getSummaryRates();
        return new ApiRequest<SummaryRateResponse>(call).execute();
    }

    public void summaryRates(Listener<SummaryRateResponse> listener) {
        Call<SummaryRateResponse> call = apiService.getSummaryRates();
        call.enqueue(new ApiCallback<SummaryRateResponse>(listener));
    }
}

