/*
 * Decompiled with CFR 0.152.
 */
package com.julienvey.trello.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.julienvey.trello.domain.Action;
import com.julienvey.trello.domain.Argument;
import com.julienvey.trello.domain.Badges;
import com.julienvey.trello.domain.Label;
import com.julienvey.trello.domain.Member;
import com.julienvey.trello.domain.TrelloEntity;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Card
extends TrelloEntity {
    private String id;
    private String name;
    private String idList;
    private String desc;
    private String url;
    private Date due;
    private List<String> idMembers;
    private List<Label> labels;
    private Badges badges;
    private List<CardCheckItem> checkItemStates;
    private boolean closed;
    private Date dateLastActivity;
    private String idBoard;
    private List<String> idChecklists;
    private List<String> idMembersVoted;
    private String idShort;
    private String idAttachmentCover;
    private boolean manualCoverAttachment;
    private int pos;
    private String shortLink;
    private String shortUrl;
    private boolean subscribed;

    public void addLabels(String ... labels) {
        this.trelloService.addLabelsToCard(this.id, labels);
    }

    public void addComment(String comment) {
        this.trelloService.addCommentToCard(this.id, comment);
    }

    public List<Action> getActions(Argument ... filters) {
        return this.trelloService.getCardActions(this.id, filters);
    }

    public List<Member> fetchMembers(Argument ... args) {
        return this.trelloService.getCardMembers(this.id, args);
    }

    public void deleteAttachment(String attachmentId) {
        this.trelloService.deleteAttachment(this.id, attachmentId);
    }

    public void delete() {
        this.getTrelloService().deleteCard(this.id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdList() {
        return this.idList;
    }

    public void setIdList(String idList) {
        this.idList = idList;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Date getDue() {
        return this.due;
    }

    public void setDue(Date due) {
        this.due = due;
    }

    public List<String> getIdMembers() {
        return this.idMembers;
    }

    public void setIdMembers(List<String> idMembers) {
        this.idMembers = idMembers;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public void setLabels(List<Label> labels) {
        this.labels = labels;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<CardCheckItem> getCheckItemStates() {
        return this.checkItemStates;
    }

    public void setCheckItemStates(List<CardCheckItem> checkItemStates) {
        this.checkItemStates = checkItemStates;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public Date getDateLastActivity() {
        return this.dateLastActivity;
    }

    public void setDateLastActivity(Date dateLastActivity) {
        this.dateLastActivity = dateLastActivity;
    }

    public String getIdBoard() {
        return this.idBoard;
    }

    public void setIdBoard(String idBoard) {
        this.idBoard = idBoard;
    }

    public List<String> getIdChecklists() {
        return this.idChecklists;
    }

    public void setIdChecklists(List<String> idChecklists) {
        this.idChecklists = idChecklists;
    }

    public List<String> getIdMembersVoted() {
        return this.idMembersVoted;
    }

    public void setIdMembersVoted(List<String> idMembersVoted) {
        this.idMembersVoted = idMembersVoted;
    }

    public String getIdShort() {
        return this.idShort;
    }

    public void setIdShort(String idShort) {
        this.idShort = idShort;
    }

    public String getIdAttachmentCover() {
        return this.idAttachmentCover;
    }

    public void setIdAttachmentCover(String idAttachmentCover) {
        this.idAttachmentCover = idAttachmentCover;
    }

    public boolean isManualCoverAttachment() {
        return this.manualCoverAttachment;
    }

    public void setManualCoverAttachment(boolean manualCoverAttachment) {
        this.manualCoverAttachment = manualCoverAttachment;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public String getShortLink() {
        return this.shortLink;
    }

    public void setShortLink(String shortLink) {
        this.shortLink = shortLink;
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }

    public void setSubscribed(boolean subscribed) {
        this.subscribed = subscribed;
    }

    public Badges getBadges() {
        return this.badges;
    }

    public void setBadges(Badges badges) {
        this.badges = badges;
    }

    public String getShortUrl() {
        return this.shortUrl;
    }

    public void setShortUrl(String shortUrl) {
        this.shortUrl = shortUrl;
    }

    public Card update() {
        return this.trelloService.updateCard(this);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CardCheckItem {
        private String idCheckItem;
        private String state;

        public String getIdCheckItem() {
            return this.idCheckItem;
        }

        public void setIdCheckItem(String idCheckItem) {
            this.idCheckItem = idCheckItem;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }
    }
}

