/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.internal.asm;

import com.alibaba.fastjson2.internal.asm.MethodCollector;
import com.alibaba.fastjson2.internal.asm.Type;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class TypeCollector {
    static final Map<String, String> PRIMITIVES;
    final String methodName;
    final Class<?>[] parameterTypes;
    protected MethodCollector collector;

    public TypeCollector(String methodName, Class<?>[] parameterTypes) {
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.collector = null;
    }

    protected MethodCollector visitMethod(int access, String name, String desc) {
        int i;
        if (this.collector != null) {
            return null;
        }
        if (!name.equals(this.methodName)) {
            return null;
        }
        Type[] argTypes = Type.getArgumentTypes(desc);
        int longOrDoubleQuantity = 0;
        for (i = 0; i < argTypes.length; ++i) {
            Type t = argTypes[i];
            String className = t.getClassName();
            if (!"long".equals(className) && !"double".equals(className)) continue;
            ++longOrDoubleQuantity;
        }
        if (argTypes.length != this.parameterTypes.length) {
            return null;
        }
        for (i = 0; i < argTypes.length; ++i) {
            if (this.correctTypeName(argTypes[i], this.parameterTypes[i].getName())) continue;
            return null;
        }
        this.collector = new MethodCollector(Modifier.isStatic(access) ? 0 : 1, argTypes.length + longOrDoubleQuantity);
        return this.collector;
    }

    private boolean correctTypeName(Type type, String paramTypeName) {
        String typeName = type.getClassName();
        StringBuilder braces = new StringBuilder();
        while (typeName.endsWith("[]")) {
            braces.append('[');
            typeName = typeName.substring(0, typeName.length() - 2);
        }
        if (braces.length() != 0) {
            String symbol = PRIMITIVES.get(typeName);
            typeName = symbol != null ? braces.append(symbol).toString() : braces.append('L').append(typeName).append(';').toString();
        }
        return typeName.equals(paramTypeName);
    }

    public String[] getParameterNamesForMethod() {
        if (this.collector == null || !this.collector.debugInfoPresent) {
            return new String[0];
        }
        return this.collector.getResult().split(",");
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("int", "I");
        map.put("boolean", "Z");
        map.put("byte", "B");
        map.put("char", "C");
        map.put("short", "S");
        map.put("float", "F");
        map.put("long", "J");
        map.put("double", "D");
        PRIMITIVES = map;
    }
}

